/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import java.util.List;
import org.graphper.api.GraphResource;
import org.graphper.draw.AbstractRenderEngine;
import org.graphper.draw.Brush;
import org.graphper.draw.ClusterEditor;
import org.graphper.draw.ClusterPipelineTrigger;
import org.graphper.draw.DrawBoard;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.ExecuteException;
import org.graphper.draw.FailInitResourceException;
import org.graphper.draw.GraphEditor;
import org.graphper.draw.GraphPipelineTrigger;
import org.graphper.draw.LineEditor;
import org.graphper.draw.LinePipelineTrigger;
import org.graphper.draw.NodeEditor;
import org.graphper.draw.NodePipelineTrigger;
import org.graphper.draw.PipelineFactory;
import org.graphper.draw.RenderEngine;
import org.graphper.util.Asserts;

public abstract class PipelineRenderEngine<NB extends Brush, LB extends Brush, CB extends Brush, GB extends Brush>
extends AbstractRenderEngine
implements RenderEngine {
    protected volatile List<NodeEditor<NB>> nodeEditors;
    protected volatile List<LineEditor<LB>> lineEditors;
    protected volatile List<ClusterEditor<CB>> clusterEditors;
    protected volatile List<GraphEditor<GB>> graphEditors;
    protected final PipelineFactory pipelineFactory;

    protected PipelineRenderEngine(PipelineFactory pipelineFactory) {
        Asserts.nullArgument(pipelineFactory, "pipelineFactory");
        this.pipelineFactory = pipelineFactory;
    }

    @Override
    public GraphResource render0(DrawGraph drawGraph) throws ExecuteException {
        Asserts.nullArgument(drawGraph, "drawGraph");
        GraphPipelineTrigger<Brush, GraphEditor<GB>> graphExecutePipeline = this.pipelineFactory.graphExecutePipeline(this.graphEditors(), drawGraph);
        ClusterPipelineTrigger<Brush, ClusterEditor<CB>> clusterExecutePipeline = this.pipelineFactory.clusterExecutePipeline(this.clusterEditors(), drawGraph);
        NodePipelineTrigger<Brush, NodeEditor<NB>> nodeExecutePipeline = this.pipelineFactory.nodeExecutePipeline(this.nodeEditors(), drawGraph);
        LinePipelineTrigger<Brush, LineEditor<LB>> lineExecutePipeline = this.pipelineFactory.lineExecutePipeline(this.lineEditors(), drawGraph);
        try {
            DrawBoard<NB, LB, CB, GB> board = this.drawBoard(drawGraph);
            graphExecutePipeline.trigger(board::drawGraph);
            clusterExecutePipeline.trigger(board::drawCluster);
            nodeExecutePipeline.trigger(board::drawNode);
            lineExecutePipeline.trigger(board::drawLine);
            return board.graphResource();
        }
        catch (FailInitResourceException ex) {
            throw new ExecuteException(ex);
        }
    }

    private synchronized List<NodeEditor<NB>> nodeEditors() {
        if (this.nodeEditors == null) {
            this.nodeEditors = this.initNodeEditors();
        }
        return this.nodeEditors;
    }

    private synchronized List<LineEditor<LB>> lineEditors() {
        if (this.lineEditors == null) {
            this.lineEditors = this.initLineEditors();
        }
        return this.lineEditors;
    }

    private synchronized List<ClusterEditor<CB>> clusterEditors() {
        if (this.clusterEditors == null) {
            this.clusterEditors = this.initClusterEditors();
        }
        return this.clusterEditors;
    }

    private synchronized List<GraphEditor<GB>> graphEditors() {
        if (this.graphEditors == null) {
            this.graphEditors = this.initGraphEditors();
        }
        return this.graphEditors;
    }

    protected abstract List<NodeEditor<NB>> initNodeEditors();

    protected abstract List<LineEditor<LB>> initLineEditors();

    protected abstract List<ClusterEditor<CB>> initClusterEditors();

    protected abstract List<GraphEditor<GB>> initGraphEditors();

    protected abstract DrawBoard<NB, LB, CB, GB> drawBoard(DrawGraph var1);
}

