/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import java.util.List;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.ext.RegularPolylinePropCalc;
import org.graphper.def.FlatPoint;
import org.graphper.draw.CustomizeShapeRender;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;
import org.graphper.util.CollectionUtils;

public class RegularShapeRender
extends CustomizeShapeRender {
    @Override
    public void drawSvg(SvgBrush nodeBrush, NodeDrawProp nodeDrawProp) {
        NodeShape nodeShape = nodeDrawProp.nodeAttrs().getNodeShape();
        RegularPolylinePropCalc shapePropCalc = (RegularPolylinePropCalc)nodeShape.getShapePropCalc();
        List<FlatPoint> points = shapePropCalc.calcPoints(nodeDrawProp);
        if (CollectionUtils.isEmpty(points)) {
            return;
        }
        Element shapeElement = nodeBrush.getShapeElement(nodeDrawProp, "polygon");
        String pointsStr = SvgEditor.generatePolylinePoints(points);
        shapeElement.setAttribute("points", pointsStr);
    }

    @Override
    public String getShapeName() {
        return NodeShapeEnum.REGULAR_POLYLINE.getName();
    }
}

