/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.common;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache_gs.commons.lang3.StringUtils;
import org.apache_gs.commons.text.StringEscapeUtils;
import org.graphper.api.FileType;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DefaultGraphResource;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.FailInitResourceException;
import org.graphper.draw.common.SvgConverter;
import org.graphper.draw.svg.Document;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgConstants;
import org.graphper.util.ClassUtils;
import org.graphper.util.FontUtils;

public class AndroidImgConverter
implements SvgConverter,
SvgConstants {
    private static Class<?> PATH;
    private static Class<?> COLOR;
    private static Class<?> STYLE;
    private static Class<?> PAINT;
    private static Class<?> RECTF;
    private static Class<?> CONFIG;
    private static Class<?> POINTF;
    private static Class<?> CANVAS;
    private static Class<?> MATRIX;
    private static Class<?> BIT_MAP;
    private static Class<?> TYPE_FACE;
    private static Class<?> PATH_EFFECT;
    private static Class<?> COMPRESS_FORMAT;
    private static Class<?> DASH_PATH_EFFECT;

    @Override
    public int order() {
        return 0;
    }

    @Override
    public boolean envSupport() {
        return PATH != null && DASH_PATH_EFFECT != null;
    }

    @Override
    public FileType[] supportFileTypes() {
        return new FileType[]{FileType.PNG, FileType.JPEG};
    }

    @Override
    public DefaultGraphResource convert(Document document, DrawGraph drawGraph, FileType fileType) throws FailInitResourceException {
        if (document == null || drawGraph == null || fileType == null) {
            throw new FailInitResourceException("Lack parameters to convert image");
        }
        ImgContext imgContext = new ImgContext();
        document.accessEles((ele, children) -> {
            try {
                if (Objects.equals(ele.tagName(), "svg")) {
                    this.initImage(drawGraph, fileType, imgContext, (Element)ele);
                    return;
                }
                Object canvas = imgContext.canvas;
                if (canvas == null) {
                    return;
                }
                if (Objects.equals(ele.tagName(), "ellipse")) {
                    this.drawEllipse((Element)ele, canvas);
                    return;
                }
                if (Objects.equals(ele.tagName(), "text")) {
                    this.drawString((Element)ele, canvas);
                    return;
                }
                if (Objects.equals(ele.tagName(), "polygon")) {
                    this.drawPolygon((Element)ele, canvas);
                    return;
                }
                if (Objects.equals(ele.tagName(), "path")) {
                    this.drawPath((Element)ele, canvas);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        if (imgContext.img == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ClassUtils.invoke(imgContext.img, "compress", new Class[]{COMPRESS_FORMAT, Integer.TYPE, OutputStream.class}, new Object[]{Enum.valueOf(COMPRESS_FORMAT, fileType.getType().toUpperCase()), 100, baos});
            String label = drawGraph.getGraphviz().graphAttrs().getLabel();
            return new DefaultGraphResource(label, fileType.getType(), baos);
        }
        catch (Exception e) {
            throw new FailInitResourceException(e);
        }
    }

    private void initImage(DrawGraph drawGraph, FileType fileType, ImgContext imgContext, Element ele) throws Exception {
        int h = this.toInt(ele.getAttribute("height"));
        int w = this.toInt(ele.getAttribute("width"));
        imgContext.img = ClassUtils.invokeStatic(AndroidImgConverter.BIT_MAP, "createBitmap", new Class[]{Integer.TYPE, Integer.TYPE, AndroidImgConverter.CONFIG}, w, h, Enum.valueOf(AndroidImgConverter.CONFIG, "ARGB_8888"));
        imgContext.canvas = ClassUtils.newObject(AndroidImgConverter.CANVAS, imgContext.img);
        ClassUtils.invoke(imgContext.canvas, "drawColor", ClassUtils.getStaticField(COLOR, "WHITE"));
        FlatPoint scale = drawGraph.getGraphviz().graphAttrs().getScale();
        if (scale != null) {
            Object transform = ClassUtils.newObject(MATRIX);
            ClassUtils.invoke(transform, "setScale", Float.valueOf((float)scale.getX()), Float.valueOf((float)scale.getY()));
            ClassUtils.invoke(imgContext.canvas, "setMatrix", transform);
        }
    }

    private void drawEllipse(Element ele, Object canvas) throws Exception {
        float x = this.toFloat(ele.getAttribute("cx"));
        float y = this.toFloat(ele.getAttribute("cy"));
        float rx = this.toFloat(ele.getAttribute("rx"));
        float ry = this.toFloat(ele.getAttribute("ry"));
        Object rectF = ClassUtils.newObject(RECTF, Float.valueOf(x - rx), Float.valueOf(y - ry), Float.valueOf(x + rx), Float.valueOf(y + ry));
        Object border = ClassUtils.newObject(PAINT);
        Object fill = ClassUtils.newObject(PAINT);
        if (this.setShapeCommonAttr(ele, border, true)) {
            ClassUtils.invoke(canvas, "drawOval", rectF, border);
        }
        if (this.setShapeCommonAttr(ele, fill, false)) {
            ClassUtils.invoke(canvas, "drawOval", rectF, fill);
        }
    }

    private void drawString(Element ele, Object canvas) throws Exception {
        String text = ele.textContext();
        if (StringUtils.isNotEmpty(text)) {
            text = StringEscapeUtils.unescapeXml(text);
        }
        int fontSize = this.toInt(ele.getAttribute("font-size"));
        double x = this.toDouble(ele.getAttribute("x"));
        double y = this.toDouble(ele.getAttribute("y"));
        String fontName = ele.getAttribute("font-family");
        fontName = fontName == null ? FontUtils.DEFAULT_FONT : fontName;
        FlatPoint size = FontUtils.measure(text, fontName, fontSize, 0.0);
        Integer color = this.toColor(ele.getAttribute("fill"));
        Object paint = ClassUtils.newObject(PAINT);
        if (color != null) {
            ClassUtils.invoke(paint, "setColor", color);
        }
        Object typeface = ClassUtils.invokeStatic(TYPE_FACE, "create", new Class[]{String.class, Integer.TYPE}, fontName, ClassUtils.getStaticField(TYPE_FACE, "NORMAL"));
        ClassUtils.invoke(paint, "setTypeface", typeface);
        ClassUtils.invoke(paint, "setTextSize", Float.valueOf(fontSize));
        ClassUtils.invoke(canvas, "drawText", new Class[]{String.class, Float.TYPE, Float.TYPE, PAINT}, new Object[]{text, Float.valueOf((float)(x - size.getWidth() / 2.0)), Float.valueOf((float)y), paint});
    }

    private void drawPolygon(Element ele, Object canvas) throws Exception {
        Object[] path = this.toPoints(ele.getAttribute("points"));
        if (path == null) {
            return;
        }
        this.drawPath(ele, canvas, path, false, true);
    }

    private void drawPath(Element ele, Object canvas) throws Exception {
        String points = ele.getAttribute("d");
        Object[] pointFs = this.toPoints(points);
        if (pointFs == null || points.length() == 0) {
            return;
        }
        this.drawPath(ele, canvas, pointFs, points.contains("C"), false);
    }

    private void drawPath(Element ele, Object canvas, Object[] pointFs, boolean isCurve, boolean needClose) throws Exception {
        int i;
        Object path = ClassUtils.newObject(PATH);
        ClassUtils.invoke(path, "moveTo", this.getX(pointFs[0]), this.getY(pointFs[0]));
        if (isCurve) {
            for (i = 1; i < pointFs.length; i += 3) {
                Object p1 = pointFs[i];
                Object p2 = pointFs[i + 1];
                Object p3 = pointFs[i + 2];
                ClassUtils.invoke(path, "cubicTo", this.getX(p1), this.getY(p1), this.getX(p2), this.getY(p2), this.getX(p3), this.getY(p3));
                ClassUtils.invoke(path, "moveTo", this.getX(p3), this.getY(p3));
            }
        } else {
            for (i = 1; i < pointFs.length; ++i) {
                ClassUtils.invoke(path, "lineTo", this.getX(pointFs[i]), this.getY(pointFs[i]));
            }
        }
        if (needClose) {
            ClassUtils.invoke(path, "close");
        }
        Object border = ClassUtils.newObject(PAINT);
        Object fill = ClassUtils.newObject(PAINT);
        if (this.setShapeCommonAttr(ele, border, true)) {
            ClassUtils.invoke(canvas, "drawPath", path, border);
        }
        if (this.setShapeCommonAttr(ele, fill, false)) {
            ClassUtils.invoke(canvas, "drawPath", path, fill);
        }
    }

    private boolean setShapeCommonAttr(Element ele, Object paint, boolean isBorder) throws Exception {
        Integer color = isBorder ? this.toColor(ele.getAttribute("stroke")) : this.toColor(ele.getAttribute("fill"));
        if (color == null) {
            return false;
        }
        ClassUtils.invoke(paint, "setColor", color);
        if (isBorder) {
            double strokeWidth;
            ClassUtils.invoke(paint, "setStyle", Enum.valueOf(STYLE, "STROKE"));
            String sw = ele.getAttribute("stroke-width");
            double d = strokeWidth = sw != null ? this.toDouble(sw) : 1.0;
            if (strokeWidth <= 0.0) {
                return false;
            }
            float[] dashPattern = this.toFloatPair(ele.getAttribute("stroke-dasharray"));
            if (dashPattern != null) {
                Object dashPathEffect = ClassUtils.newObject(DASH_PATH_EFFECT, dashPattern, Float.valueOf(0.0f));
                ClassUtils.invokeOne(paint, "setPathEffect", PATH_EFFECT, dashPathEffect);
            }
            ClassUtils.invoke(paint, "setStrokeWidth", Float.valueOf((float)strokeWidth));
        } else {
            ClassUtils.invoke(paint, "setStyle", Enum.valueOf(STYLE, "FILL"));
        }
        return true;
    }

    private Object getX(Object point) throws Exception {
        return ClassUtils.getField(point, "x");
    }

    private Object getY(Object point) throws Exception {
        return ClassUtils.getField(point, "y");
    }

    private int toInt(String doubleStr) {
        if (StringUtils.isEmpty(doubleStr)) {
            return 0;
        }
        return (int)Double.parseDouble(doubleStr.replaceAll("pt", ""));
    }

    private float toFloat(String doubleStr) {
        if (StringUtils.isEmpty(doubleStr)) {
            return 0.0f;
        }
        return Float.parseFloat(doubleStr.replaceAll("pt", ""));
    }

    private double toDouble(String doubleStr) {
        if (StringUtils.isEmpty(doubleStr)) {
            return 0.0;
        }
        return Double.parseDouble(doubleStr.replaceAll("pt", ""));
    }

    public Integer toColor(String hexColorCode) throws Exception {
        if (hexColorCode == null || "none".equals(hexColorCode)) {
            return null;
        }
        return (Integer)ClassUtils.invokeStatic(COLOR, "parseColor", new Class[]{String.class}, hexColorCode);
    }

    private float[] toFloatPair(String pair) {
        if (StringUtils.isEmpty(pair)) {
            return null;
        }
        String[] p = pair.split(",");
        float[] fp = new float[]{this.toFloat(p[0]), this.toFloat(p[1])};
        return fp;
    }

    private Object[] toPoints(String points) throws Exception {
        if (StringUtils.isEmpty(points)) {
            return null;
        }
        points = points.replace("M", "");
        points = points.replace("C", " ");
        String[] pointPairs = points.split(" ");
        Object[] pointFs = new Object[pointPairs.length];
        for (int i = 0; i < pointPairs.length; ++i) {
            String[] point = pointPairs[i].split(",");
            pointFs[i] = ClassUtils.newObject(POINTF, Float.valueOf(this.toFloat(point[0])), Float.valueOf(this.toFloat(point[1])));
        }
        return pointFs;
    }

    static {
        try {
            PATH = Class.forName("android.graphics.Path");
            COLOR = Class.forName("android.graphics.Color");
            STYLE = Class.forName("android.graphics.Paint$Style");
            PAINT = Class.forName("android.graphics.Paint");
            RECTF = Class.forName("android.graphics.RectF");
            CONFIG = Class.forName("android.graphics.Bitmap$Config");
            POINTF = Class.forName("android.graphics.PointF");
            CANVAS = Class.forName("android.graphics.Canvas");
            MATRIX = Class.forName("android.graphics.Matrix");
            BIT_MAP = Class.forName("android.graphics.Bitmap");
            TYPE_FACE = Class.forName("android.graphics.Typeface");
            PATH_EFFECT = Class.forName("android.graphics.PathEffect");
            COMPRESS_FORMAT = Class.forName("android.graphics.Bitmap$CompressFormat");
            DASH_PATH_EFFECT = Class.forName("android.graphics.DashPathEffect");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ImgContext {
        private Object img;
        private Object canvas;

        private ImgContext() {
        }
    }
}

