/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import org.graphper.api.FileType;
import org.graphper.api.GraphResource;
import org.graphper.draw.DefaultGraphResource;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.FailInitResourceException;
import org.graphper.draw.common.SvgConverter;
import org.graphper.draw.svg.SvgDrawBoard;
import org.graphper.layout.EnvStrategy;
import org.graphper.util.CollectionUtils;

public class CommonDrawBoard
extends SvgDrawBoard {
    private FileType fileType;
    private static final List<SvgConverter> converters;

    public CommonDrawBoard(DrawGraph drawGraph) {
        super(drawGraph);
    }

    public void setImageType(FileType fileType) {
        this.fileType = fileType;
    }

    @Override
    public synchronized GraphResource graphResource() throws FailInitResourceException {
        FileType type;
        FileType fileType = type = this.fileType == null ? FileType.SVG : this.fileType;
        if (type == FileType.SVG) {
            return super.graphResource();
        }
        if (CollectionUtils.isEmpty(converters)) {
            this.throwsUnsupportedImgConvert();
        }
        for (SvgConverter converter : converters) {
            DefaultGraphResource resource;
            if (!converter.support(type) || (resource = converter.convert(this.svgDocument, this.drawGraph, type)) == null) continue;
            return resource;
        }
        this.throwsUnsupportedImgConvert();
        return null;
    }

    private void throwsUnsupportedImgConvert() throws FailInitResourceException {
        throw new FailInitResourceException("Do not have Converter");
    }

    static {
        ServiceLoader<SvgConverter> converterServiceLoader = ServiceLoader.load(SvgConverter.class);
        ArrayList<SvgConverter> svgConverters = null;
        for (SvgConverter converter : converterServiceLoader) {
            if (!converter.envSupport()) continue;
            if (svgConverters == null) {
                svgConverters = new ArrayList<SvgConverter>();
            }
            svgConverters.add(converter);
        }
        if (CollectionUtils.isEmpty(svgConverters)) {
            converters = Collections.emptyList();
        } else {
            svgConverters.sort(Comparator.comparing(EnvStrategy::order));
            converters = Collections.unmodifiableList(svgConverters);
        }
    }
}

