/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.common;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache_gs.commons.lang3.StringUtils;
import org.apache_gs.commons.text.StringEscapeUtils;
import org.graphper.api.FileType;
import org.graphper.def.FlatPoint;
import org.graphper.draw.DefaultGraphResource;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.FailInitResourceException;
import org.graphper.draw.common.SvgConverter;
import org.graphper.draw.svg.Document;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgConstants;
import org.graphper.util.ClassUtils;
import org.graphper.util.FontUtils;

public class DefaultImgConverter
implements SvgConverter,
SvgConstants {
    private static Class<?> KEY;
    private static Class<?> FONT;
    private static Class<?> COLOR;
    private static Class<?> SHAPE;
    private static Class<?> LINE2D;
    private static Class<?> PATH2D;
    private static Class<?> POINT2D;
    private static Class<?> CURVE2D;
    private static Class<?> ELLIPSE;
    private static Class<?> IMAGEIO;
    private static Class<?> STROKE_C;
    private static Class<?> RENDER_IMG;
    private static Class<?> BUFFERED_IMG;
    private static Class<?> BASIC_STROKE;
    private static Class<?> AFFINE_TRANSFORM;

    @Override
    public int order() {
        if (Boolean.TRUE.toString().equals(System.getProperty("use.local.img.converter"))) {
            return Integer.MIN_VALUE;
        }
        return 1;
    }

    @Override
    public boolean envSupport() {
        return KEY != null && AFFINE_TRANSFORM != null;
    }

    @Override
    public FileType[] supportFileTypes() {
        return new FileType[]{FileType.PNG, FileType.JPG, FileType.JPEG, FileType.GIF};
    }

    @Override
    public DefaultGraphResource convert(Document document, DrawGraph drawGraph, FileType fileType) throws FailInitResourceException {
        if (document == null || drawGraph == null || fileType == null) {
            throw new FailInitResourceException("Lack parameters to convert image");
        }
        ImgContext imgContext = new ImgContext();
        document.accessEles((ele, children) -> {
            try {
                if (Objects.equals(ele.tagName(), "svg")) {
                    this.initImage(drawGraph, fileType, imgContext, (Element)ele);
                    return;
                }
                Object g2d = imgContext.g2d;
                if (g2d == null) {
                    return;
                }
                if (Objects.equals(ele.tagName(), "ellipse")) {
                    this.drawEllipse((Element)ele, g2d);
                    return;
                }
                if (Objects.equals(ele.tagName(), "text")) {
                    this.drawString((Element)ele, g2d);
                    return;
                }
                if (Objects.equals(ele.tagName(), "polygon")) {
                    this.drawPolygon((Element)ele, g2d);
                    return;
                }
                if (Objects.equals(ele.tagName(), "path")) {
                    this.drawPath((Element)ele, g2d);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        if (imgContext.img == null) {
            return null;
        }
        try {
            ClassUtils.invoke(imgContext.g2d, "dispose");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ClassUtils.invokeStatic(IMAGEIO, "write", new Class[]{RENDER_IMG, String.class, OutputStream.class}, imgContext.img, fileType.getType(), baos);
            String label = drawGraph.getGraphviz().graphAttrs().getLabel();
            return new DefaultGraphResource(label, fileType.getType(), baos);
        }
        catch (Exception e) {
            throw new FailInitResourceException(e);
        }
    }

    private void initImage(DrawGraph drawGraph, FileType fileType, ImgContext imgContext, Element ele) throws Exception {
        int h = this.toInt(ele.getAttribute("height"));
        int w = this.toInt(ele.getAttribute("width"));
        FlatPoint scale = drawGraph.getGraphviz().graphAttrs().getScale();
        Object transform = ClassUtils.newObject(AFFINE_TRANSFORM);
        if (scale != null) {
            ClassUtils.invoke(transform, "scale", scale.getX() * 1.3333, scale.getY() * 1.3333);
        }
        w = (int)((double)w * 1.3333);
        h = (int)((double)h * 1.3333);
        if (fileType == FileType.PNG) {
            imgContext.setImg(ClassUtils.newObject(BUFFERED_IMG, w, h, ClassUtils.getStaticField(BUFFERED_IMG, "TYPE_INT_ARGB")));
        } else {
            imgContext.setImg(ClassUtils.newObject(BUFFERED_IMG, w, h, ClassUtils.getStaticField(BUFFERED_IMG, "TYPE_INT_RGB")));
        }
        Object g2d = imgContext.g2d;
        ClassUtils.invoke(g2d, "setTransform", transform);
        ClassUtils.invoke(g2d, "setBackground", ClassUtils.getStaticField(COLOR, "WHITE"));
        ClassUtils.invoke(g2d, "clearRect", 0, 0, w, h);
    }

    private void drawEllipse(Element ele, Object g2d) throws Exception {
        double x = this.toDouble(ele.getAttribute("cx"));
        double y = this.toDouble(ele.getAttribute("cy"));
        double w = this.toDouble(ele.getAttribute("rx"));
        double h = this.toDouble(ele.getAttribute("ry"));
        Object ellipse = ClassUtils.newObject(ELLIPSE, x - w, y - h, 2.0 * w, 2.0 * h);
        this.setShapeCommonAttr(ele, g2d, ellipse);
    }

    private void drawString(Element ele, Object g2d) throws Exception {
        String text = ele.textContext();
        if (StringUtils.isNotEmpty(text)) {
            text = StringEscapeUtils.unescapeXml(text);
        }
        int fontSize = this.toInt(ele.getAttribute("font-size"));
        double x = this.toDouble(ele.getAttribute("x"));
        double y = this.toDouble(ele.getAttribute("y"));
        String fontName = ele.getAttribute("font-family");
        FlatPoint size = FontUtils.measure(text, fontName, fontSize, 0.0);
        Object color = this.toColor(ele.getAttribute("fill"));
        if (color == null) {
            color = ClassUtils.getStaticField(COLOR, "BLACK");
        }
        ClassUtils.invoke(g2d, "setColor", color);
        fontName = fontName == null ? FontUtils.DEFAULT_FONT : fontName;
        ClassUtils.invoke(g2d, "setFont", ClassUtils.newObject(FONT, fontName, ClassUtils.getStaticField(FONT, "PLAIN"), fontSize));
        ClassUtils.invoke(g2d, "drawString", text, Float.valueOf((float)(x - size.getWidth() / 2.0)), Float.valueOf((float)y));
    }

    private void drawPolygon(Element ele, Object g2d) throws Exception {
        Object polygon = ClassUtils.newObject(PATH2D);
        Object[] path = this.toPoints(ele.getAttribute("points"));
        if (path == null) {
            return;
        }
        for (int i = 0; i < path.length; ++i) {
            if (i == 0) {
                ClassUtils.invoke(polygon, "moveTo", this.getPointX(path[i]), this.getPointY(path[i]));
                continue;
            }
            ClassUtils.invoke(polygon, "lineTo", this.getPointX(path[i]), this.getPointY(path[i]));
        }
        ClassUtils.invoke(polygon, "closePath");
        this.setShapeCommonAttr(ele, g2d, polygon);
    }

    private void drawPath(Element ele, Object g2d) throws Exception {
        String points = ele.getAttribute("d");
        Object[] path = this.toPoints(points);
        if (path == null) {
            return;
        }
        Object path2D = ClassUtils.newObject(PATH2D);
        if (points.contains("C")) {
            for (int i = 3; i < path.length; i += 3) {
                Object p1 = path[i - 3];
                Object p2 = path[i - 2];
                Object p3 = path[i - 1];
                Object p4 = path[i];
                Object curve = ClassUtils.newObject(CURVE2D, this.getPointX(p1), this.getPointY(p1), this.getPointX(p2), this.getPointY(p2), this.getPointX(p3), this.getPointY(p3), this.getPointX(p4), this.getPointY(p4));
                ClassUtils.invoke(path2D, "append", new Class[]{SHAPE, Boolean.TYPE}, new Object[]{curve, true});
            }
        } else {
            for (int i = 1; i < path.length; ++i) {
                Object start = path[i - 1];
                Object end = path[i];
                Object line = ClassUtils.newObject(LINE2D, this.getPointX(start), this.getPointY(start), this.getPointX(end), this.getPointY(end));
                ClassUtils.invoke(path2D, "append", new Class[]{SHAPE, Boolean.TYPE}, new Object[]{line, true});
            }
        }
        this.setShapeCommonAttr(ele, g2d, path2D);
    }

    private void setShapeCommonAttr(Element ele, Object g2d, Object shape) throws Exception {
        float[] dashPattern;
        double strokeWidth;
        Object color = this.toColor(ele.getAttribute("fill"));
        Object borderColor = this.toColor(ele.getAttribute("stroke"));
        if (color == null && borderColor == null) {
            return;
        }
        String sw = ele.getAttribute("stroke-width");
        double d = strokeWidth = sw != null ? this.toDouble(sw) : 1.0;
        if (strokeWidth <= 0.0 && color == null) {
            return;
        }
        if (color != null) {
            ClassUtils.invoke(g2d, "setColor", color);
            ClassUtils.invokeOne(g2d, "fill", SHAPE, shape);
        }
        Object stroke = (dashPattern = this.toFloatPair(ele.getAttribute("stroke-dasharray"))) != null ? ClassUtils.newObject(BASIC_STROKE, new Class[]{Float.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, float[].class, Float.TYPE}, new Object[]{Float.valueOf((float)strokeWidth), ClassUtils.getStaticField(BASIC_STROKE, "CAP_BUTT"), ClassUtils.getStaticField(BASIC_STROKE, "JOIN_ROUND"), Float.valueOf(5.0f), dashPattern, 0}) : ClassUtils.newObject(BASIC_STROKE, Float.valueOf((float)strokeWidth));
        ClassUtils.invokeOne(g2d, "setStroke", STROKE_C, stroke);
        ClassUtils.invokeOne(g2d, "setColor", COLOR, borderColor);
        ClassUtils.invokeOne(g2d, "draw", SHAPE, shape);
    }

    private Object getPointX(Object point) throws Exception {
        return ClassUtils.invoke(point, "getX");
    }

    private Object getPointY(Object point) throws Exception {
        return ClassUtils.invoke(point, "getY");
    }

    private int toInt(String doubleStr) {
        if (StringUtils.isEmpty(doubleStr)) {
            return 0;
        }
        return (int)Double.parseDouble(doubleStr.replaceAll("pt", ""));
    }

    private double toDouble(String doubleStr) {
        if (StringUtils.isEmpty(doubleStr)) {
            return 0.0;
        }
        return Double.parseDouble(doubleStr.replaceAll("pt", ""));
    }

    private float toFloat(String doubleStr) {
        if (StringUtils.isEmpty(doubleStr)) {
            return 0.0f;
        }
        return Float.parseFloat(doubleStr.replaceAll("pt", ""));
    }

    private float[] toFloatPair(String pair) {
        if (StringUtils.isEmpty(pair)) {
            return null;
        }
        String[] p = pair.split(",");
        float[] fp = new float[]{this.toFloat(p[0]), this.toFloat(p[1])};
        return fp;
    }

    private Object[] toPoints(String points) throws Exception {
        if (StringUtils.isEmpty(points)) {
            return null;
        }
        points = points.replace("M", "");
        points = points.replace("C", " ");
        String[] pointPairs = points.split(" ");
        Object[] point2d = new Object[pointPairs.length];
        for (int i = 0; i < pointPairs.length; ++i) {
            String[] point = pointPairs[i].split(",");
            point2d[i] = ClassUtils.newObject(POINT2D, this.toDouble(point[0]), this.toDouble(point[1]));
        }
        return point2d;
    }

    public Object toColor(String hexColorCode) throws Exception {
        if (hexColorCode == null || "none".equals(hexColorCode)) {
            return null;
        }
        int rgb = Integer.parseInt(hexColorCode.substring(1), 16);
        return ClassUtils.newObject(COLOR, rgb);
    }

    static {
        try {
            KEY = Class.forName("java.awt.RenderingHints$Key");
            FONT = Class.forName("java.awt.Font");
            COLOR = Class.forName("java.awt.Color");
            SHAPE = Class.forName("java.awt.Shape");
            LINE2D = Class.forName("java.awt.geom.Line2D$Double");
            PATH2D = Class.forName("java.awt.geom.Path2D$Double");
            POINT2D = Class.forName("java.awt.geom.Point2D$Double");
            CURVE2D = Class.forName("java.awt.geom.CubicCurve2D$Double");
            ELLIPSE = Class.forName("java.awt.geom.Ellipse2D$Double");
            IMAGEIO = Class.forName("javax.imageio.ImageIO");
            STROKE_C = Class.forName("java.awt.Stroke");
            BASIC_STROKE = Class.forName("java.awt.BasicStroke");
            RENDER_IMG = Class.forName("java.awt.image.RenderedImage");
            BUFFERED_IMG = Class.forName("java.awt.image.BufferedImage");
            AFFINE_TRANSFORM = Class.forName("java.awt.geom.AffineTransform");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ImgContext {
        private Object img;
        private Object g2d;

        private ImgContext() {
        }

        public void setImg(Object img) throws Exception {
            this.img = img;
            if (this.img != null) {
                this.g2d = ClassUtils.invoke(img, "createGraphics");
                ClassUtils.invoke(this.g2d, "setRenderingHint", new Class[]{KEY, Object.class}, ClassUtils.getStaticField(Class.forName("java.awt.RenderingHints"), "KEY_ANTIALIASING"), ClassUtils.getStaticField(Class.forName("java.awt.RenderingHints"), "VALUE_ANTIALIAS_ON"));
            }
        }
    }
}

