/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.common;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.FileType;
import org.graphper.draw.DefaultGraphResource;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.FailInitResourceException;
import org.graphper.draw.common.BatikImgConverter;
import org.graphper.draw.svg.Document;
import org.graphper.util.ClassUtils;

public class SvgToPdfConverter
extends BatikImgConverter {
    private static Class<?> PDF_TRANSCODER;
    private static Class<?> TRANSCODING_HINTS;
    private static Class<?> SVG_A_TRANSCODER;
    private static Class<?> XML_A_TRANSCODER;
    private static Class<?> SVG_DOM_IMPL;

    @Override
    public int order() {
        return 0;
    }

    @Override
    public boolean envSupport() {
        if (!super.envSupport()) {
            return false;
        }
        return PDF_TRANSCODER != null && SVG_DOM_IMPL != null;
    }

    @Override
    public FileType[] supportFileTypes() {
        return new FileType[]{FileType.PDF};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DefaultGraphResource convert(Document document, DrawGraph drawGraph, FileType fileType) throws FailInitResourceException {
        if (document == null) throw new FailInitResourceException("Lack parameters to convert image");
        if (drawGraph == null) throw new FailInitResourceException("Lack parameters to convert image");
        if (fileType == null) {
            throw new FailInitResourceException("Lack parameters to convert image");
        }
        String svg = document.toXml();
        if (StringUtils.isEmpty(svg)) {
            throw new FailInitResourceException("Can not get svg");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(svg.getBytes(StandardCharsets.UTF_8));){
            Object transcoder = ClassUtils.newObject(PDF_TRANSCODER);
            Object transcodingHints = ClassUtils.newObject(TRANSCODING_HINTS);
            Class[] paramTypes = new Class[]{Object.class, Object.class};
            ClassUtils.invoke(transcodingHints, "put", paramTypes, new Object[]{ClassUtils.getStaticField(SVG_A_TRANSCODER, "KEY_WIDTH"), Float.valueOf(1000.0f)});
            ClassUtils.invoke(transcodingHints, "put", paramTypes, new Object[]{ClassUtils.getStaticField(SVG_A_TRANSCODER, "KEY_HEIGHT"), Float.valueOf(1000.0f)});
            ClassUtils.invoke(transcodingHints, "put", paramTypes, ClassUtils.getStaticField(XML_A_TRANSCODER, "KEY_DOM_IMPLEMENTATION"), ClassUtils.invokeStatic(SVG_DOM_IMPL, "getDOMImplementation"));
            ClassUtils.invoke(transcodingHints, "put", paramTypes, ClassUtils.getStaticField(XML_A_TRANSCODER, "KEY_DOCUMENT_ELEMENT_NAMESPACE_URI"), ClassUtils.getStaticField(SVG_DOM_IMPL, "SVG_NAMESPACE_URI"));
            ClassUtils.invoke(transcodingHints, "put", paramTypes, new Object[]{ClassUtils.getStaticField(XML_A_TRANSCODER, "KEY_DOCUMENT_ELEMENT"), FileType.SVG.getType()});
            ClassUtils.invoke(transcoder, "setTranscodingHints", transcodingHints);
            DefaultGraphResource defaultGraphResource = this.getFileGraphResource(drawGraph, FileType.PDF, is, transcoder);
            return defaultGraphResource;
        }
        catch (Exception e) {
            throw new FailInitResourceException(e);
        }
    }

    static {
        try {
            PDF_TRANSCODER = Class.forName("org.apache.fop.svg.PDFTranscoder");
            TRANSCODING_HINTS = Class.forName("org.apache.batik.transcoder.TranscodingHints");
            SVG_A_TRANSCODER = Class.forName("org.apache.batik.transcoder.SVGAbstractTranscoder");
            XML_A_TRANSCODER = Class.forName("org.apache.batik.transcoder.XMLAbstractTranscoder");
            SVG_DOM_IMPL = Class.forName("org.apache.batik.anim.dom.SVGDOMImplementation");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

