/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graphper.api.Node;
import org.graphper.draw.Brush;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgDocument;
import org.graphper.draw.svg.SvgDrawBoard;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public class SvgBrush
implements Brush {
    private Element wrapEle;
    private final Element element;
    private final SvgDocument svgDocument;
    private final SvgDrawBoard svgDrawBoard;
    private Map<String, List<Element>> eleGroups;

    public SvgBrush(Element element, SvgDocument svgDocument, SvgDrawBoard svgDrawBoard) {
        Asserts.nullArgument(element, "element");
        Asserts.nullArgument(svgDocument, "svgomDocument");
        Asserts.nullArgument(svgDrawBoard, "svgDrawBorad");
        this.element = element;
        this.svgDocument = svgDocument;
        this.svgDrawBoard = svgDrawBoard;
    }

    public String nodeId(Node node) {
        return this.drawBoard().nodeId(node);
    }

    public String lineId(LineDrawProp lineDrawProp) {
        return this.drawBoard().lineId(lineDrawProp);
    }

    public Element getOrCreateChildElementById(String id, String tagName) {
        Element ele = this.svgDocument.getElementById(id);
        if (ele == null) {
            ele = this.getCommonContainer().createChildElement(id, tagName);
            ele.setAttribute("id", id);
        }
        return ele;
    }

    public Element getShapeElement(NodeDrawProp node, String tagName) {
        String shapeId = SvgBrush.getId(this.nodeId(node.getNode()), tagName);
        return this.getOrCreateShapeEleById(shapeId, tagName);
    }

    public Element getOrCreateShapeEleById(String id, String tagName) {
        Element shapeEle = this.getOrCreateChildElementById(id, tagName);
        this.addGroup("shapeGroupKey", Collections.singletonList(shapeEle));
        return shapeEle;
    }

    public void addGroup(String key, Element ... group) {
        Asserts.illegalArgument(group == null || group.length == 0, "Group is empty");
        this.addGroup(key, Arrays.asList(group));
    }

    public void addGroup(String key, List<Element> group) {
        if (CollectionUtils.isEmpty(group)) {
            return;
        }
        if (this.eleGroups == null) {
            this.eleGroups = new HashMap<String, List<Element>>(1);
        }
        this.eleGroups.put(key, group);
    }

    public List<Element> getEleGroup(String groupKey) {
        if (this.eleGroups == null) {
            return Collections.emptyList();
        }
        List<Element> group = this.eleGroups.get(groupKey);
        return CollectionUtils.isEmpty(group) ? Collections.emptyList() : group;
    }

    public SvgDrawBoard drawBoard() {
        return this.svgDrawBoard;
    }

    public void setWrapEle(Element wrapEle) {
        this.wrapEle = wrapEle;
    }

    public static String getId(String parentElementId, String elementName) {
        return parentElementId + "_" + elementName;
    }

    private Element getCommonContainer() {
        return this.wrapEle != null ? this.wrapEle : this.element;
    }
}

