/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.graphper.draw.svg.Document;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgConstants;
import org.graphper.draw.svg.SvgElement;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public final class SvgDocument
implements SvgConstants,
Document,
Serializable {
    private static final long serialVersionUID = -9126509188726886245L;
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String DOC_TYPE = "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">";
    private final Map<String, SvgElement> elementMap = new LinkedHashMap<String, SvgElement>();

    public Iterable<SvgElement> children() {
        return this.elementMap.values();
    }

    @Override
    public Element getElementById(String id) {
        return this.elementMap.get(id);
    }

    @Override
    public SvgElement createElement(String tagName) {
        Asserts.nullArgument(tagName, "tagName is null");
        SvgElement ele = new SvgElement(tagName, this);
        int size = this.elementMap.size();
        ele.setId(String.valueOf(size));
        return ele;
    }

    @Override
    public boolean removeEle(String id) {
        return this.elementMap.remove(id) != null;
    }

    @Override
    public String toXml() {
        if (this.elementMap.size() == 0) {
            return null;
        }
        StringBuilder xml = new StringBuilder();
        xml.append(XML_VERSION);
        xml.append(DOC_TYPE);
        BiConsumer<Element, List<Element>> consumer = (ele, children) -> {
            String attr = ele.toAttrStr();
            xml.append("<").append(ele.tagName());
            if (attr != null) {
                xml.append(attr);
            }
            xml.append(">");
            if (ele.textContext() != null) {
                xml.append(ele.textContext());
            }
        };
        this.accessEles(consumer, ele -> xml.append("<").append("/").append(ele.tagName()).append(">"));
        return xml.toString();
    }

    @Override
    public void accessEles(BiConsumer<Element, List<Element>> consumer) {
        this.accessEles(consumer, null);
    }

    private void accessEles(BiConsumer<Element, List<Element>> preConsumer, Consumer<Element> postConsumer) {
        if (preConsumer == null || this.elementMap.size() == 0) {
            return;
        }
        LinkedHashMap<Element, List<Element>> groups = new LinkedHashMap<Element, List<Element>>();
        for (SvgElement element : this.elementMap.values()) {
            groups.compute(element.parent(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<SvgElement>();
                }
                v.add(element);
                return v;
            });
        }
        List roots = (List)groups.get(null);
        if (CollectionUtils.isEmpty(roots)) {
            return;
        }
        for (Element root : roots) {
            this.accessEle(root, groups, preConsumer, postConsumer);
        }
    }

    private void accessEle(Element element, Map<Element, List<Element>> groups, BiConsumer<Element, List<Element>> preConsumer, Consumer<Element> postConsumer) {
        if (element == null) {
            return;
        }
        List<Element> children = groups.get(element);
        children = CollectionUtils.isEmpty(children) ? Collections.emptyList() : children;
        preConsumer.accept(element, children);
        for (Element child : children) {
            this.accessEle(child, groups, preConsumer, postConsumer);
        }
        if (postConsumer != null) {
            postConsumer.accept(element);
        }
    }

    void setId(String oldId, String id, SvgElement element) {
        Asserts.nullArgument(id, "id");
        Asserts.nullArgument(element, "element");
        Asserts.illegalArgument(Objects.equals(oldId, id), "The id equals to oldKey");
        this.elementMap.put(id, element);
        if (oldId != null) {
            this.elementMap.remove(oldId);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvgDocument that = (SvgDocument)o;
        return Objects.equals(this.elementMap, that.elementMap);
    }

    public int hashCode() {
        return Objects.hash(this.elementMap);
    }

    public String toString() {
        return this.toXml();
    }
}

