/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.Cluster;
import org.graphper.api.FileType;
import org.graphper.api.GraphAttrs;
import org.graphper.api.GraphResource;
import org.graphper.api.Line;
import org.graphper.api.Node;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.DefaultGraphResource;
import org.graphper.draw.DrawBoard;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.FailInitResourceException;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgDocument;
import org.graphper.draw.svg.SvgElement;
import org.graphper.util.Asserts;

public class SvgDrawBoard
implements DrawBoard<SvgBrush, SvgBrush, SvgBrush, SvgBrush> {
    public static final String GRAPH_ROOT = "graph_root";
    private static final String VIEWBOX_VAL = "0.00 0.00 %s %s";
    private static final String XMLNS_VAL = "http://www.w3.org/2000/svg";
    private static final String XMLNS_XLINK_VAL = "http://www.w3.org/1999/xlink";
    protected final SvgDocument svgDocument;
    protected final Element graphElement;
    protected final DrawGraph drawGraph;

    public SvgDrawBoard(DrawGraph drawGraph) {
        Asserts.nullArgument(drawGraph, "DrawGraph");
        this.drawGraph = drawGraph;
        double width = drawGraph.width();
        double height = drawGraph.height();
        FlatPoint scale = drawGraph.getGraphviz().graphAttrs().getScale();
        if (scale != null) {
            width *= scale.getX();
            height *= scale.getY();
        }
        this.svgDocument = new SvgDocument();
        SvgElement svg = this.svgDocument.createElement("svg");
        svg.setAttribute("xmlns", XMLNS_VAL);
        svg.setAttribute("xmlns:xlink", XMLNS_XLINK_VAL);
        svg.setAttribute("height", height + "pt");
        svg.setAttribute("width", width + "pt");
        svg.setAttribute("viewBox", String.format(VIEWBOX_VAL, width, height));
        this.graphElement = svg.createChildElement("g");
        this.graphElement.setAttribute("id", GRAPH_ROOT);
        this.graphElement.setAttribute("class", "graph");
    }

    @Override
    public synchronized SvgBrush drawGraph(GraphvizDrawProp graphvizDrawProp) {
        String transform = "scale(%s) rotate(%s)";
        FlatPoint scale = graphvizDrawProp.getGraphviz().graphAttrs().getScale();
        if (scale == null) {
            transform = String.format(transform, "1 1", "%s");
        } else {
            String scaleStr = scale.getX() + " " + scale.getY();
            transform = String.format(transform, scaleStr, "%s");
        }
        transform = String.format(transform, "0");
        this.graphElement.setAttribute("transform", transform);
        Element element = this.graphElement.createChildElement("g");
        element.setAttribute("id", "graph_0");
        element.setAttribute("class", "graph");
        return new SvgBrush(element, this.svgDocument, this);
    }

    @Override
    public synchronized SvgBrush drawCluster(ClusterDrawProp cluster) {
        Element element = this.graphElement.createChildElement("g");
        element.setAttribute("id", this.clusterId(cluster));
        element.setAttribute("class", "cluster");
        return new SvgBrush(element, this.svgDocument, this);
    }

    @Override
    public synchronized SvgBrush drawNode(NodeDrawProp nodeDrawProp) {
        Element element = this.graphElement.createChildElement("g");
        element.setAttribute("id", this.nodeId(nodeDrawProp));
        element.setAttribute("class", "node");
        return new SvgBrush(element, this.svgDocument, this);
    }

    @Override
    public synchronized SvgBrush drawLine(LineDrawProp line) {
        Element element = this.graphElement.createChildElement("g");
        element.setAttribute("id", this.lineId(line));
        return new SvgBrush(element, this.svgDocument, this);
    }

    @Override
    public boolean removeNode(Node node) {
        return this.svgDocument.removeEle(this.nodeId(node));
    }

    @Override
    public boolean removeLine(Line line) {
        return this.svgDocument.removeEle(this.lineId(line));
    }

    @Override
    public synchronized GraphResource graphResource() throws FailInitResourceException {
        String label = this.drawGraph.getGraphviz().graphAttrs().getLabel();
        String svg = this.svgDocument.toXml();
        if (StringUtils.isEmpty(svg)) {
            throw new FailInitResourceException("Can not generate svg xml");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(svg.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new FailInitResourceException(e);
        }
        return new DefaultGraphResource(label != null ? label : "graphviz", FileType.SVG.getType(), os);
    }

    public GraphAttrs graphAttrs() {
        return this.drawGraph.getGraphviz().graphAttrs();
    }

    public DrawGraph drawGraph() {
        return this.drawGraph;
    }

    public String clusterId(ClusterDrawProp clusterDrawProp) {
        Objects.requireNonNull(clusterDrawProp);
        return this.clusterId(clusterDrawProp.getCluster());
    }

    public String nodeId(NodeDrawProp nodeDrawProp) {
        Objects.requireNonNull(nodeDrawProp);
        return this.nodeId(nodeDrawProp.getNode());
    }

    public String lineId(LineDrawProp lineDrawProp) {
        Objects.requireNonNull(lineDrawProp);
        return this.lineId(lineDrawProp.getLine());
    }

    public String clusterId(Cluster cluster) {
        Objects.requireNonNull(cluster);
        return this.drawGraph.clusterId(cluster);
    }

    public String nodeId(Node node) {
        Objects.requireNonNull(node);
        return this.drawGraph.nodeId(node);
    }

    public String lineId(Line line) {
        Objects.requireNonNull(line);
        return this.drawGraph.lineId(line);
    }
}

