/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg;

import java.util.List;
import java.util.function.Consumer;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.attributes.Color;
import org.graphper.api.ext.Box;
import org.graphper.def.FlatPoint;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgConstants;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;
import org.graphper.util.FontUtils;

public class SvgEditor
implements SvgConstants {
    public static void setText(Element text, double fontSize, TextLineAttribute textLineAttribute) {
        Asserts.nullArgument(text, "text element");
        Asserts.nullArgument(textLineAttribute, "text line attribute");
        text.setAttribute("x", String.valueOf(textLineAttribute.getX()));
        text.setAttribute("y", String.valueOf(textLineAttribute.getY()));
        text.setAttribute("text-anchor", "middle");
        text.setAttribute("font-size", String.valueOf(fontSize));
        TextAttribute attribute = textLineAttribute.getTextAttribute();
        if (attribute.fontColor != null) {
            text.setAttribute("fill", attribute.fontColor.value());
        }
        if (attribute.fontName != null) {
            text.setAttribute("font-family", attribute.fontName);
        }
    }

    public static void text(TextAttribute textAttribute) {
        Asserts.nullArgument(textAttribute, "textAttribute");
        if (textAttribute.lineAttributeConsumer == null) {
            return;
        }
        double halfHeight = textAttribute.fontsize / 2.0;
        String[] lines = textAttribute.label.split("\n");
        int midIndex = (lines.length - 1) / 2;
        boolean oddLen = (lines.length & 1) == 1;
        double xc = textAttribute.centerPoint.getX() - halfHeight / 8.0;
        double t = halfHeight / 3.0;
        for (int i = 0; i < lines.length; ++i) {
            double yc = textAttribute.centerPoint.getY() - t;
            yc -= (double)(midIndex - i) * textAttribute.fontsize;
            if (oddLen) {
                yc += halfHeight;
            }
            textAttribute.lineAttributeConsumer.accept(new TextLineAttribute(xc, yc, i, lines[i], textAttribute));
        }
    }

    public static String getPathPointStr(FlatPoint point) {
        return SvgEditor.getPathPointStr(point, true);
    }

    public static String getPathPointStr(FlatPoint point, boolean needSpace) {
        Asserts.nullArgument(point, "point");
        String v = point.getX() + "," + point.getY();
        return needSpace ? v + " " : v;
    }

    public static String pointsToSvgLine(FlatPoint start, List<FlatPoint> points, boolean isCurve) {
        if (CollectionUtils.isEmpty(points)) {
            return null;
        }
        start = start == null ? points.get(0) : start;
        StringBuilder path = new StringBuilder("M").append(start.getX()).append(",").append(start.getY());
        if (isCurve) {
            path.append("C");
        } else {
            path.append(" ");
        }
        for (int i = 1; i < points.size(); ++i) {
            FlatPoint flatPoint = points.get(i);
            path.append(flatPoint.getX()).append(",").append(flatPoint.getY()).append(" ");
        }
        return path.toString();
    }

    public static String pointsToSvgPath(boolean isCurve, double ... positions) {
        Asserts.nullArgument(positions, "positions");
        Asserts.illegalArgument(positions.length == 0 || positions.length % 2 != 0, "Wrong positions length, can not be empty and must be even");
        StringBuilder sb = new StringBuilder("M");
        for (int i = 0; i < positions.length; i += 2) {
            double horPos = positions[i];
            double verPos = positions[i + 1];
            if (i == 0 && isCurve) {
                sb.append(horPos).append(",").append(verPos).append("C");
                continue;
            }
            sb.append(horPos).append(",").append(verPos).append(" ");
        }
        return sb.toString();
    }

    public static String roundedBox(int maxRoundedLen, Box box) {
        Asserts.nullArgument(box, "box");
        Asserts.illegalArgument(maxRoundedLen <= 0, "Max rounded length less than 0");
        double leftBorder = box.getLeftBorder();
        double rightBorder = box.getRightBorder();
        double upBorder = box.getUpBorder();
        double downBorder = box.getDownBorder();
        int cornerLen = Math.min(maxRoundedLen, (int)box.getWidth() / 2);
        cornerLen = Math.min(cornerLen, (int)box.getHeight() / 2);
        return SvgEditor.pointsToSvgPath(true, leftBorder, upBorder + (double)cornerLen, leftBorder, upBorder + (double)cornerLen, leftBorder, downBorder - (double)cornerLen, leftBorder, downBorder - (double)cornerLen, leftBorder, downBorder, leftBorder, downBorder, leftBorder + (double)cornerLen, downBorder, leftBorder + (double)cornerLen, downBorder, rightBorder - (double)cornerLen, downBorder, rightBorder - (double)cornerLen, downBorder, rightBorder, downBorder, rightBorder, downBorder, rightBorder, downBorder - (double)cornerLen, rightBorder, downBorder - (double)cornerLen, rightBorder, upBorder + (double)cornerLen, rightBorder, upBorder + (double)cornerLen, rightBorder, upBorder, rightBorder, upBorder, rightBorder - (double)cornerLen, upBorder, rightBorder - (double)cornerLen, upBorder, leftBorder + (double)cornerLen, upBorder, leftBorder + (double)cornerLen, upBorder, leftBorder, upBorder, leftBorder, upBorder, leftBorder, upBorder + (double)cornerLen);
    }

    public static String generateBox(Box box) {
        Asserts.nullArgument(box, "box");
        return SvgEditor.generatePolylinePoints(box.getLeftBorder(), box.getUpBorder(), box.getRightBorder(), box.getUpBorder(), box.getRightBorder(), box.getDownBorder(), box.getLeftBorder(), box.getDownBorder(), box.getLeftBorder(), box.getUpBorder());
    }

    public static String generatePolylinePoints(List<FlatPoint> positions) {
        Asserts.nullArgument(positions, "positions");
        Asserts.illegalArgument(CollectionUtils.isEmpty(positions), "Wrong positions length, can not be empty and must be even");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < positions.size(); ++i) {
            FlatPoint p = positions.get(i);
            sb.append(p.getX()).append(",").append(p.getY()).append(" ");
        }
        return sb.toString();
    }

    public static String generatePolylinePoints(double ... positions) {
        Asserts.nullArgument(positions, "positions");
        Asserts.illegalArgument(positions.length == 0 || positions.length % 2 != 0, "Wrong positions length, can not be empty and must be even");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < positions.length; i += 2) {
            double horPos = positions[i];
            double verPos = positions[i + 1];
            sb.append(horPos).append(",").append(verPos).append(" ");
        }
        return sb.toString();
    }

    public static class TextLineAttribute {
        private final double x;
        private final double y;
        private final int lineNo;
        private final String line;
        private final TextAttribute textAttribute;

        public TextLineAttribute(double x, double y, int lineNo, String line, TextAttribute textAttribute) {
            this.x = x;
            this.y = y;
            this.lineNo = lineNo;
            this.line = line;
            this.textAttribute = textAttribute;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public String getLine() {
            return this.line;
        }

        public TextAttribute getTextAttribute() {
            return this.textAttribute;
        }
    }

    public static class TextAttribute {
        private final FlatPoint centerPoint;
        private final double fontsize;
        private final String label;
        private final Color fontColor;
        private final String fontName;
        private final Consumer<TextLineAttribute> lineAttributeConsumer;

        public TextAttribute(FlatPoint centerPoint, double fontsize, String label, Color fontColor, Consumer<TextLineAttribute> lineAttributeConsumer) {
            this(centerPoint, fontsize, label, fontColor, FontUtils.DEFAULT_FONT, lineAttributeConsumer);
        }

        public TextAttribute(FlatPoint centerPoint, double fontsize, String label, Color fontColor, String fontName, Consumer<TextLineAttribute> lineAttributeConsumer) {
            Asserts.nullArgument(centerPoint, "centerPoint");
            Asserts.illegalArgument(StringUtils.isEmpty(label), "label can not be empty");
            this.centerPoint = centerPoint;
            this.fontsize = fontsize;
            this.label = label;
            this.fontColor = fontColor;
            this.fontName = fontName;
            this.lineAttributeConsumer = lineAttributeConsumer;
        }
    }
}

