/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache_gs.commons.text.StringEscapeUtils;
import org.graphper.draw.svg.Document;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgConstants;
import org.graphper.draw.svg.SvgDocument;
import org.graphper.util.Asserts;

public final class SvgElement
implements SvgConstants,
Element,
Serializable {
    private static final long serialVersionUID = -4656435281889555382L;
    private String id;
    private final String tagName;
    private String textContext;
    private Map<String, String> attr;
    private SvgElement parent;
    private final SvgDocument document;

    SvgElement(String tagName, SvgDocument document) {
        Asserts.nullArgument(tagName, "tag name");
        Asserts.nullArgument(document, "document");
        this.tagName = tagName;
        this.document = document;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        Asserts.nullArgument(id, "id");
        if (Objects.equals(id, this.id)) {
            return;
        }
        this.document.setId(this.id, id, this);
        this.id = id;
    }

    @Override
    public String tagName() {
        return this.tagName;
    }

    @Override
    public Element parent() {
        return this.parent;
    }

    @Override
    public Element createChildElement(String tagName) {
        Asserts.nullArgument(tagName, "tagName");
        SvgElement childElement = this.document.createElement(tagName);
        childElement.parent = this;
        return childElement;
    }

    @Override
    public void setTextContent(String textContent) {
        this.textContext = StringEscapeUtils.escapeXml11(textContent);
    }

    @Override
    public void setAttribute(String attrName, String value) {
        Asserts.nullArgument(attrName, "attrName");
        Asserts.nullArgument(value, "value");
        value = StringEscapeUtils.escapeXml11(value);
        if (this.attr == null) {
            this.attr = new LinkedHashMap<String, String>(2);
        }
        this.attr.put(attrName, value);
        if (Objects.equals(attrName, "id")) {
            this.setId(value);
        }
    }

    @Override
    public String getAttribute(String attrName) {
        if (this.attr == null) {
            return null;
        }
        return this.attr.get(attrName);
    }

    @Override
    public String toAttrStr() {
        if (this.attr == null) {
            return null;
        }
        StringBuilder attrVal = new StringBuilder();
        for (Map.Entry<String, String> entry : this.attr.entrySet()) {
            attrVal.append(" ").append(entry.getKey()).append("=").append("\"").append(entry.getValue()).append("\"");
        }
        return attrVal.toString();
    }

    @Override
    public String textContext() {
        return this.textContext;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvgElement that = (SvgElement)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.tagName, that.tagName) && Objects.equals(this.textContext, that.textContext) && Objects.equals(this.attr, that.attr) && Objects.equals(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tagName, this.textContext, this.attr, this.parent);
    }
}

