/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.cluster;

import org.graphper.api.attributes.ClusterStyle;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.ClusterEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class ClusterBorderEditor
extends SvgEditor
implements ClusterEditor<SvgBrush> {
    private static final int MAX_CLUSTER_ROUNDED = 60;

    @Override
    public boolean edit(ClusterDrawProp cluster, SvgBrush brush) {
        Element clusterEle;
        cluster.check();
        ClusterStyle style = cluster.getCluster().clusterAttrs().getStyle();
        if (style == ClusterStyle.ROUNDED) {
            clusterEle = brush.getOrCreateChildElementById(SvgBrush.getId(cluster.id(), "path"), "path");
            String points = ClusterBorderEditor.roundedBox(60, cluster);
            clusterEle.setAttribute("d", points);
        } else {
            clusterEle = brush.getOrCreateChildElementById(SvgBrush.getId(cluster.id(), "polygon"), "polygon");
            String points = ClusterBorderEditor.generateBox(cluster);
            clusterEle.setAttribute("points", points);
        }
        brush.addGroup("shapeGroupKey", clusterEle);
        double penWidth = cluster.getCluster().clusterAttrs().getPenWidth();
        clusterEle.setAttribute("stroke-width", String.valueOf(penWidth));
        return true;
    }
}

