/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.cluster;

import org.graphper.api.ClusterAttrs;
import org.graphper.api.attributes.ClusterStyle;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.ClusterEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class ClusterHrefEditor
extends SvgEditor
implements ClusterEditor<SvgBrush> {
    @Override
    public boolean edit(ClusterDrawProp cluster, SvgBrush brush) {
        ClusterAttrs clusterAttrs = cluster.getCluster().clusterAttrs();
        if (clusterAttrs.getStyle() == ClusterStyle.INVIS) {
            return false;
        }
        if (clusterAttrs.getHref() == null) {
            return true;
        }
        String href = clusterAttrs.getHref();
        String id = brush.drawBoard().clusterId(cluster.getCluster());
        Element wrapEle = brush.getOrCreateShapeEleById("a_" + id, "a");
        brush.setWrapEle(wrapEle);
        wrapEle.setAttribute("xlink:href", href);
        wrapEle.setAttribute("xlink:title", clusterAttrs.getLabel());
        return true;
    }
}

