/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.cluster;

import java.util.function.Consumer;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.ClusterAttrs;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.ClusterEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class ClusterLabelEditor
extends SvgEditor
implements ClusterEditor<SvgBrush> {
    @Override
    public boolean edit(ClusterDrawProp cluster, SvgBrush brush) {
        ClusterAttrs clusterAttrs = cluster.getCluster().clusterAttrs();
        String label = clusterAttrs.getLabel();
        if (StringUtils.isEmpty(label)) {
            return true;
        }
        double fontSize = clusterAttrs.getFontSize();
        Consumer<SvgEditor.TextLineAttribute> lineConsumer = textLineAttribute -> {
            Element text = brush.getOrCreateChildElementById(SvgBrush.getId(cluster.id(), "text") + "_" + textLineAttribute.getLineNo(), "text");
            ClusterLabelEditor.setText(text, fontSize, textLineAttribute);
            text.setTextContent(textLineAttribute.getLine());
        };
        ClusterLabelEditor.text(new SvgEditor.TextAttribute(cluster.getLabelCenter(), fontSize, label, clusterAttrs.getFontColor(), clusterAttrs.getFontName(), lineConsumer));
        return true;
    }
}

