/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.cluster;

import org.graphper.api.ClusterAttrs;
import org.graphper.api.attributes.ClusterStyle;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.ClusterEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class ClusterStyleEditor
extends SvgEditor
implements ClusterEditor<SvgBrush> {
    @Override
    public boolean edit(ClusterDrawProp cluster, SvgBrush brush) {
        ClusterAttrs clusterAttrs = cluster.getCluster().clusterAttrs();
        ClusterStyle style = clusterAttrs.getStyle();
        if (style == null) {
            return true;
        }
        for (Element clusterEle : brush.getEleGroup("shapeGroupKey")) {
            this.setStyle(style, clusterEle);
        }
        return true;
    }

    private void setStyle(ClusterStyle style, Element cluster) {
        if (style == ClusterStyle.DASHED) {
            this.dashed(cluster);
        } else if (style == ClusterStyle.DOTTED) {
            this.dotted(cluster);
        } else if (style == ClusterStyle.BOLD) {
            this.bold(cluster);
        }
    }

    private void dashed(Element cluster) {
        cluster.setAttribute("fill", "none");
        cluster.setAttribute("stroke-dasharray", "5,2");
    }

    private void dotted(Element cluster) {
        cluster.setAttribute("fill", "none");
        cluster.setAttribute("stroke-dasharray", "1,5");
    }

    private void bold(Element cluster) {
        cluster.setAttribute("stroke-width", "2");
    }
}

