/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.graphviz;

import org.graphper.api.GraphAttrs;
import org.graphper.api.attributes.Color;
import org.graphper.draw.GraphEditor;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class GraphBasicEditor
extends SvgEditor
implements GraphEditor<SvgBrush> {
    @Override
    public boolean edit(GraphvizDrawProp graphvizDrawProp, SvgBrush brush) {
        GraphAttrs graphAttrs = graphvizDrawProp.getGraphviz().graphAttrs();
        this.setHref(graphvizDrawProp, brush);
        Element background = brush.getOrCreateChildElementById(SvgBrush.getId("graph_root", "polygon"), "polygon");
        double leftBorder = graphvizDrawProp.getLeftBorder();
        double rightBorder = graphvizDrawProp.getRightBorder();
        double topBorder = graphvizDrawProp.getUpBorder();
        double bottomBorder = graphvizDrawProp.getDownBorder();
        String points = leftBorder + "," + topBorder + " " + rightBorder + "," + topBorder + " " + rightBorder + "," + bottomBorder + " " + leftBorder + "," + bottomBorder + " " + leftBorder + "," + topBorder;
        this.setBgColor(graphAttrs, background);
        background.setAttribute("points", points);
        return true;
    }

    private void setHref(GraphvizDrawProp graphvizDrawProp, SvgBrush brush) {
        GraphAttrs graphAttrs = graphvizDrawProp.getGraphviz().graphAttrs();
        if (graphAttrs.getHref() == null) {
            return;
        }
        String href = graphAttrs.getHref();
        String id = "graph_0";
        Element wrapEle = brush.getOrCreateShapeEleById("a_" + id, "a");
        brush.setWrapEle(wrapEle);
        wrapEle.setAttribute("xlink:href", href);
        wrapEle.setAttribute("xlink:title", graphAttrs.getLabel());
    }

    private void setBgColor(GraphAttrs graphAttrs, Element background) {
        Color bgColor = graphAttrs.getBgColor();
        if (bgColor == null) {
            this.setDefaultBgColor(background);
        } else {
            background.setAttribute("fill", bgColor.value());
        }
    }

    private void setDefaultBgColor(Element background) {
        background.setAttribute("fill", Color.WHITE.value());
    }
}

