/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.graphviz;

import java.util.Arrays;
import java.util.List;
import org.graphper.api.attributes.Color;
import org.graphper.def.FlatPoint;
import org.graphper.draw.GraphEditor;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;
import org.graphper.layout.OrthoVisGraph;
import org.graphper.util.CollectionUtils;

public class GraphGridEditor
extends SvgEditor
implements GraphEditor<SvgBrush> {
    private static final String GRID_SEGMENT = "grid_segment";

    @Override
    public boolean edit(GraphvizDrawProp graphvizDrawProp, SvgBrush brush) {
        List<OrthoVisGraph.Segment> grid = graphvizDrawProp.getGrid();
        if (CollectionUtils.isEmpty(grid)) {
            return true;
        }
        for (int i = 0; i < grid.size(); ++i) {
            OrthoVisGraph.Segment segment = grid.get(i);
            List<FlatPoint> points = Arrays.asList(segment.getStart(), segment.getEnd());
            String path = GraphGridEditor.pointsToSvgLine(null, points, false);
            Element pathElement = brush.getOrCreateChildElementById("grid_segment_" + i, "path");
            pathElement.setAttribute("d", path);
            pathElement.setAttribute("fill", "none");
            pathElement.setAttribute("stroke", Color.BLACK.value());
            pathElement.setAttribute("stroke-dasharray", "1,5");
        }
        return true;
    }
}

