/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.graphviz;

import java.util.function.Consumer;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.GraphAttrs;
import org.graphper.draw.GraphEditor;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class GraphLabelEditor
extends SvgEditor
implements GraphEditor<SvgBrush> {
    @Override
    public boolean edit(GraphvizDrawProp graphvizDrawProp, SvgBrush brush) {
        GraphAttrs graphAttrs = graphvizDrawProp.getGraphviz().graphAttrs();
        String label = graphAttrs.getLabel();
        if (StringUtils.isEmpty(label)) {
            return true;
        }
        double fontSize = graphAttrs.getFontSize();
        Consumer<SvgEditor.TextLineAttribute> lineConsumer = textLineAttribute -> {
            Element text = brush.getOrCreateChildElementById(SvgBrush.getId("graph_root", "text") + "_" + textLineAttribute.getLineNo(), "text");
            GraphLabelEditor.setText(text, fontSize, textLineAttribute);
            text.setTextContent(textLineAttribute.getLine());
        };
        GraphLabelEditor.text(new SvgEditor.TextAttribute(graphvizDrawProp.getLabelCenter(), fontSize, label, graphAttrs.getFontColor(), graphAttrs.getFontName(), lineConsumer));
        return true;
    }
}

