/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.line;

import org.graphper.api.attributes.ArrowShape;
import org.graphper.api.attributes.Color;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.draw.ArrowDrawProp;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.LineEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class LineArrowEditor
extends SvgEditor
implements LineEditor<SvgBrush> {
    @Override
    public boolean edit(LineDrawProp lineDrawProp, SvgBrush brush) {
        if (lineDrawProp.getArrowHead() != null) {
            this.drawArrow(lineDrawProp, brush, lineDrawProp.getArrowHead(), "head", lineDrawProp.lineAttrs().getArrowHead());
        }
        if (lineDrawProp.getArrowTail() != null) {
            this.drawArrow(lineDrawProp, brush, lineDrawProp.getArrowTail(), "tail", lineDrawProp.lineAttrs().getArrowTail());
        }
        return true;
    }

    private void drawArrow(LineDrawProp lineDrawProp, SvgBrush brush, ArrowDrawProp arrow, String id, ArrowShape shape) {
        switch (shape) {
            case NORMAL: {
                this.normal(lineDrawProp, brush, arrow, id);
                break;
            }
            case BOX: {
                this.box(lineDrawProp, brush, arrow, id);
                break;
            }
            case DOT: {
                this.dot(lineDrawProp, brush, arrow, id);
                break;
            }
            case VEE: {
                this.vee(lineDrawProp, brush, arrow, id);
                break;
            }
            case CURVE: {
                this.curve(lineDrawProp, brush, arrow, id);
                break;
            }
        }
    }

    private void normal(LineDrawProp lineDrawProp, SvgBrush brush, ArrowDrawProp arrow, String id) {
        Element arrowElement = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(lineDrawProp), "polygon") + id, "polygon");
        this.setBasicProp(arrowElement);
        FlatPoint axisBegin = arrow.getAxisBegin();
        FlatPoint axisEnd = arrow.getAxisEnd();
        String points = axisEnd.getX() + "," + axisEnd.getY() + " ";
        FlatPoint axis = Vectors.sub(axisBegin, axisEnd);
        FlatPoint dirVector = new FlatPoint(-axis.getY(), axis.getX());
        double offsetX = axis.dist() * Math.abs(dirVector.getX()) / (3.0 * dirVector.dist());
        double offsetY = axis.dist() * Math.abs(dirVector.getY()) / (3.0 * dirVector.dist());
        points = points + this.getArrowSide(this.posSlope(axisBegin, axisEnd), offsetX, offsetY, true, axisBegin);
        points = points + axisEnd.getX() + "," + axisEnd.getY();
        arrowElement.setAttribute("points", points);
        brush.addGroup(this.arrowGroup(arrow), arrowElement);
    }

    private void box(LineDrawProp lineDrawProp, SvgBrush brush, ArrowDrawProp arrow, String id) {
        Element arrowElement = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(lineDrawProp), "polygon") + id, "polygon");
        this.setBasicProp(arrowElement);
        FlatPoint axisBegin = arrow.getAxisBegin();
        FlatPoint axisEnd = arrow.getAxisEnd();
        FlatPoint axis = Vectors.sub(axisBegin, axisEnd);
        FlatPoint dirVector = new FlatPoint(-axis.getY(), axis.getX());
        double offsetX = axis.dist() * Math.abs(dirVector.getX()) / (2.0 * dirVector.dist());
        double offsetY = axis.dist() * Math.abs(dirVector.getY()) / (2.0 * dirVector.dist());
        String points = this.getArrowSide(this.posSlope(axisBegin, axisEnd), offsetX, offsetY, true, axisBegin);
        points = points + this.getArrowSide(this.posSlope(axisBegin, axisEnd), offsetX, offsetY, false, axisEnd);
        arrowElement.setAttribute("points", points);
        brush.addGroup(this.arrowGroup(arrow), arrowElement);
    }

    private void dot(LineDrawProp lineDrawProp, SvgBrush brush, ArrowDrawProp arrow, String id) {
        Element arrowElement = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(lineDrawProp), "ellipse") + id, "ellipse");
        this.setBasicProp(arrowElement);
        FlatPoint axisBegin = arrow.getAxisBegin();
        FlatPoint axisEnd = arrow.getAxisEnd();
        FlatPoint axis = Vectors.sub(axisBegin, axisEnd);
        double radius = axis.dist() / 2.0;
        double x = (axisBegin.getX() + axisEnd.getX()) / 2.0;
        double y = (axisBegin.getY() + axisEnd.getY()) / 2.0;
        arrowElement.setAttribute("cx", String.valueOf(x));
        arrowElement.setAttribute("cy", String.valueOf(y));
        arrowElement.setAttribute("rx", String.valueOf(radius));
        arrowElement.setAttribute("ry", String.valueOf(radius));
        brush.addGroup(this.arrowGroup(arrow), arrowElement);
    }

    private void vee(LineDrawProp lineDrawProp, SvgBrush brush, ArrowDrawProp arrow, String id) {
        Element arrowElement = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(lineDrawProp), "polygon") + id, "polygon");
        this.setBasicProp(arrowElement);
        FlatPoint axisBegin = arrow.getAxisBegin();
        FlatPoint axisEnd = arrow.getAxisEnd();
        FlatPoint axis = Vectors.sub(axisBegin, axisEnd);
        FlatPoint veeEndPoint = Vectors.add(axisBegin, axis);
        axis.setX(axis.getX() * 2.0);
        axis.setY(axis.getY() * 2.0);
        FlatPoint dirVector = new FlatPoint(-axis.getY(), axis.getX());
        double offsetX = axis.dist() * Math.abs(dirVector.getX()) / (3.0 * dirVector.dist());
        double offsetY = axis.dist() * Math.abs(dirVector.getY()) / (3.0 * dirVector.dist());
        FlatPointPair pointPair = this.getArrowSidePoint(this.posSlope(axisBegin, axisEnd), offsetX, offsetY, true, veeEndPoint);
        String points = LineArrowEditor.getPathPointStr(pointPair.p1) + LineArrowEditor.getPathPointStr(axisBegin) + LineArrowEditor.getPathPointStr(pointPair.p2) + LineArrowEditor.getPathPointStr(axisEnd) + LineArrowEditor.getPathPointStr(pointPair.p1, false);
        arrowElement.setAttribute("points", points);
        brush.addGroup(this.arrowGroup(arrow), arrowElement);
    }

    private void curve(LineDrawProp lineDrawProp, SvgBrush brush, ArrowDrawProp arrow, String id) {
        Element arrowEle1 = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(lineDrawProp), "path") + id + "0", "path");
        Element arrowEle2 = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(lineDrawProp), "path") + id + "1", "path");
        Element axisEle = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(lineDrawProp), "path") + id + "2", "path");
        this.setBasicProp(arrowEle1, false);
        this.setBasicProp(arrowEle2, false);
        this.setBasicProp(axisEle, false);
        FlatPoint axisBegin = arrow.getAxisBegin();
        FlatPoint axisEnd = arrow.getAxisEnd();
        FlatPoint axis = Vectors.sub(axisBegin, axisEnd);
        FlatPoint dirVector = new FlatPoint(-axis.getY(), axis.getX());
        double offsetX = axis.dist() * Math.abs(dirVector.getX()) / (2.0 * dirVector.dist());
        double offsetY = axis.dist() * Math.abs(dirVector.getY()) / (2.0 * dirVector.dist());
        FlatPointPair pair1 = this.getArrowSidePoint(this.posSlope(axisBegin, axisEnd), offsetX, offsetY, true, axisBegin);
        FlatPointPair pair2 = this.getArrowSidePoint(this.posSlope(axisBegin, axisEnd), offsetX, offsetY, true, axisEnd);
        String points = "M" + LineArrowEditor.getPathPointStr(pair1.p1, false) + "C" + LineArrowEditor.getPathPointStr(pair1.p1) + LineArrowEditor.getPathPointStr(pair2.p1) + LineArrowEditor.getPathPointStr(axisEnd, false);
        arrowEle1.setAttribute("d", points);
        points = "M" + LineArrowEditor.getPathPointStr(pair1.p2, false) + "C" + LineArrowEditor.getPathPointStr(pair1.p2) + LineArrowEditor.getPathPointStr(pair2.p2) + LineArrowEditor.getPathPointStr(axisEnd, false);
        arrowEle2.setAttribute("d", points);
        points = "M" + LineArrowEditor.getPathPointStr(axisBegin) + LineArrowEditor.getPathPointStr(axisEnd, false);
        axisEle.setAttribute("d", points);
        brush.addGroup(this.arrowGroup(arrow), axisEle, arrowEle1, arrowEle2);
    }

    private void setBasicProp(Element arrowElement) {
        this.setBasicProp(arrowElement, true);
    }

    private void setBasicProp(Element arrowElement, boolean needFill) {
        if (needFill) {
            arrowElement.setAttribute("fill", Color.BLACK.value());
        } else {
            arrowElement.setAttribute("fill", "none");
        }
        arrowElement.setAttribute("stroke", Color.BLACK.value());
    }

    private String getArrowSide(boolean posSlope, double offsetX, double offsetY, boolean pos, FlatPoint point) {
        FlatPointPair pointPair = this.getArrowSidePoint(posSlope, offsetX, offsetY, pos, point);
        return pointPair.p1.getX() + "," + pointPair.p1.getY() + " " + pointPair.p2.getX() + "," + pointPair.p2.getY() + " ";
    }

    private FlatPointPair getArrowSidePoint(boolean posSlope, double offsetX, double offsetY, boolean pos, FlatPoint point) {
        if (posSlope) {
            if (pos) {
                return new FlatPointPair(new FlatPoint(point.getX() - offsetX, point.getY() + offsetY), new FlatPoint(point.getX() + offsetX, point.getY() - offsetY));
            }
            return new FlatPointPair(new FlatPoint(point.getX() + offsetX, point.getY() - offsetY), new FlatPoint(point.getX() - offsetX, point.getY() + offsetY));
        }
        if (pos) {
            return new FlatPointPair(new FlatPoint(point.getX() - offsetX, point.getY() - offsetY), new FlatPoint(point.getX() + offsetX, point.getY() + offsetY));
        }
        return new FlatPointPair(new FlatPoint(point.getX() + offsetX, point.getY() + offsetY), new FlatPoint(point.getX() - offsetX, point.getY() - offsetY));
    }

    private boolean posSlope(FlatPoint start, FlatPoint end) {
        return start.getY() - end.getY() < 0.0 == start.getX() - end.getX() < 0.0;
    }

    private String arrowGroup(ArrowDrawProp arrowDrawProp) {
        return arrowDrawProp.isHead() ? "headArrowGroupKey" : "tailArrowGroupKey";
    }

    private static class FlatPointPair {
        private final FlatPoint p1;
        private final FlatPoint p2;

        private FlatPointPair(FlatPoint p1, FlatPoint p2) {
            this.p1 = p1;
            this.p2 = p2;
        }
    }
}

