/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.line;

import java.util.Map;
import java.util.function.Consumer;
import org.graphper.api.FloatLabel;
import org.graphper.def.FlatPoint;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.LineEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class LineFloatLabelsEditor
extends SvgEditor
implements LineEditor<SvgBrush> {
    private static final String FLOAT_LABEL = "float_label";

    @Override
    public boolean edit(LineDrawProp lineDrawProp, SvgBrush brush) {
        int i = 0;
        for (Map.Entry<FloatLabel, FlatPoint> flatPointEntry : lineDrawProp.getFloatLabelFlatCenters().entrySet()) {
            FloatLabel floatLabel = flatPointEntry.getKey();
            if (floatLabel.ignoreTextLabel()) continue;
            FlatPoint flatPointCenter = flatPointEntry.getValue();
            int n = i++;
            Consumer<SvgEditor.TextLineAttribute> lineConsumer = textLineAttribute -> {
                String id = SvgBrush.getId(brush.lineId(lineDrawProp), "text_float_label" + n + textLineAttribute.getLineNo());
                Element text = brush.getOrCreateChildElementById(id, "text");
                LineFloatLabelsEditor.setText(text, floatLabel.getFontSize(), textLineAttribute);
                text.setTextContent(textLineAttribute.getLine());
            };
            LineFloatLabelsEditor.text(new SvgEditor.TextAttribute(flatPointCenter, floatLabel.getFontSize(), floatLabel.getLabel(), lineDrawProp.lineAttrs().getFontColor(), lineConsumer));
        }
        return true;
    }
}

