/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.line;

import org.graphper.api.LineAttrs;
import org.graphper.api.attributes.LineStyle;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.LineEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class LineHrefEditor
extends SvgEditor
implements LineEditor<SvgBrush> {
    @Override
    public boolean edit(LineDrawProp line, SvgBrush brush) {
        LineAttrs lineAttrs = line.lineAttrs();
        if (lineAttrs.getStyle() == LineStyle.INVIS) {
            return false;
        }
        if (lineAttrs.getHref() == null) {
            return true;
        }
        String href = lineAttrs.getHref();
        String id = brush.lineId(line);
        Element wrapEle = brush.getOrCreateShapeEleById("a_" + id, "a");
        brush.setWrapEle(wrapEle);
        wrapEle.setAttribute("xlink:href", href);
        wrapEle.setAttribute("xlink:title", lineAttrs.getLabel());
        return true;
    }
}

