/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.line;

import java.util.function.Consumer;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.LineAttrs;
import org.graphper.def.FlatPoint;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.LineEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class LineLabelEditor
extends SvgEditor
implements LineEditor<SvgBrush> {
    @Override
    public boolean edit(LineDrawProp lineDrawProp, SvgBrush brush) {
        String label = lineDrawProp.lineAttrs().getLabel();
        if (StringUtils.isEmpty(label) || lineDrawProp.getLabelCenter() == null) {
            return true;
        }
        Double fz = lineDrawProp.lineAttrs().getFontSize();
        double fontSize = fz == null ? 0.0 : fz;
        FlatPoint labelCenter = lineDrawProp.getLabelCenter();
        Consumer<SvgEditor.TextLineAttribute> lineConsumer = textLineAttribute -> {
            String id = SvgBrush.getId(brush.lineId(lineDrawProp), "text_" + textLineAttribute.getLineNo());
            Element text = brush.getOrCreateChildElementById(id, "text");
            LineLabelEditor.setText(text, fontSize, textLineAttribute);
            text.setTextContent(textLineAttribute.getLine());
        };
        LineAttrs lineAttrs = lineDrawProp.lineAttrs();
        LineLabelEditor.text(new SvgEditor.TextAttribute(labelCenter, fontSize, label, lineAttrs.getFontColor(), lineAttrs.getFontName(), lineConsumer));
        return true;
    }
}

