/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.line;

import org.graphper.api.attributes.Color;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.LineEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;
import org.graphper.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinePathEditor
extends SvgEditor
implements LineEditor<SvgBrush> {
    private static final Logger log = LoggerFactory.getLogger(LinePathEditor.class);

    @Override
    public boolean edit(LineDrawProp lineDrawProp, SvgBrush brush) {
        if (CollectionUtils.isEmpty(lineDrawProp)) {
            if (log.isWarnEnabled()) {
                log.warn("Find the wrong LineDrawProp attribute, terminate the drawing of the svg path, line={}", (Object)lineDrawProp.lineAttrs());
            }
            return true;
        }
        Element pathElement = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(lineDrawProp), "path"), "path");
        Color color = lineDrawProp.lineAttrs().getColor();
        pathElement.setAttribute("d", LinePathEditor.pointsToSvgLine(lineDrawProp.getStart(), lineDrawProp, lineDrawProp.isBesselCurve()));
        pathElement.setAttribute("fill", "none");
        pathElement.setAttribute("stroke", color.value());
        Element title = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(lineDrawProp), "title"), "title");
        String text = brush.drawBoard().drawGraph().getGraphviz().isDirected() ? lineDrawProp.getLine().tail().nodeAttrs().getLabel() + "->" + lineDrawProp.getLine().head().nodeAttrs().getLabel() : lineDrawProp.getLine().tail().nodeAttrs().getLabel() + "--" + lineDrawProp.getLine().head().nodeAttrs().getLabel();
        title.setTextContent(text);
        Double penWidth = lineDrawProp.lineAttrs().getPenWidth();
        if (penWidth != null) {
            pathElement.setAttribute("stroke-width", String.valueOf(penWidth));
        }
        return true;
    }
}

