/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.line;

import org.graphper.api.LineAttrs;
import org.graphper.api.attributes.ArrowShape;
import org.graphper.api.attributes.Color;
import org.graphper.api.attributes.LineStyle;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.LineEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;

public class LineStyleEditor
implements LineEditor<SvgBrush> {
    @Override
    public boolean edit(LineDrawProp line, SvgBrush brush) {
        this.setArrowProp(line.lineAttrs(), brush);
        LineStyle style = line.lineAttrs().getStyle();
        if (style == null) {
            return true;
        }
        if (style == LineStyle.INVIS) {
            brush.drawBoard().removeLine(line.getLine());
            return false;
        }
        Element pathEle = brush.getOrCreateChildElementById(SvgBrush.getId(brush.lineId(line), "path"), "path");
        if (style == LineStyle.DASHED) {
            this.dashed(pathEle);
            return true;
        }
        if (style == LineStyle.DOTTED) {
            this.dotted(pathEle);
            return true;
        }
        if (style == LineStyle.BOLD) {
            this.bold(pathEle);
            return true;
        }
        return true;
    }

    private void setArrowProp(LineAttrs lineAttrs, SvgBrush brush) {
        Double penWidth = lineAttrs.getPenWidth();
        Color color = lineAttrs.getColor();
        ArrowShape arrowHead = lineAttrs.getArrowHead();
        ArrowShape arrowTail = lineAttrs.getArrowTail();
        for (Element ele : brush.getEleGroup("tailArrowGroupKey")) {
            LineStyleEditor.setArrowStyle(penWidth, color, ele, arrowTail.isNeedFill());
        }
        for (Element ele : brush.getEleGroup("headArrowGroupKey")) {
            LineStyleEditor.setArrowStyle(penWidth, color, ele, arrowHead.isNeedFill());
        }
    }

    private static void setArrowStyle(Double penWidth, Color color, Element ele, boolean needFill) {
        ele.setAttribute("stroke", color.value());
        if (needFill) {
            ele.setAttribute("fill", color.value());
        }
        if (penWidth == null) {
            return;
        }
        ele.setAttribute("stroke-width", String.valueOf(penWidth));
    }

    private void dashed(Element pathEle) {
        pathEle.setAttribute("fill", "none");
        pathEle.setAttribute("stroke-dasharray", "5,2");
    }

    private void dotted(Element pathEle) {
        pathEle.setAttribute("fill", "none");
        pathEle.setAttribute("stroke-dasharray", "1,5");
    }

    private void bold(Element shape) {
        shape.setAttribute("stroke-width", "2");
    }
}

