/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.node;

import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.NodeStyle;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.NodeEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class NodeHrefEditor
extends SvgEditor
implements NodeEditor<SvgBrush> {
    @Override
    public boolean edit(NodeDrawProp node, SvgBrush brush) {
        NodeAttrs nodeAttrs = node.nodeAttrs();
        if (nodeAttrs.getStyle() == NodeStyle.INVIS) {
            return false;
        }
        if (nodeAttrs.getHref() == null) {
            return true;
        }
        String href = nodeAttrs.getHref();
        String id = brush.nodeId(node.getNode());
        Element wrapEle = brush.getOrCreateShapeEleById("a_" + id, "a");
        brush.setWrapEle(wrapEle);
        wrapEle.setAttribute("xlink:href", href);
        if (StringUtils.isNotEmpty(nodeAttrs.getLabel())) {
            wrapEle.setAttribute("xlink:title", nodeAttrs.getLabel());
        }
        return true;
    }
}

