/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.node;

import org.graphper.api.NodeAttrs;
import org.graphper.def.FlatPoint;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.NodeEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.node.AbstractNodeShapeEditor;

public class NodeImageEditor
extends AbstractNodeShapeEditor
implements NodeEditor<SvgBrush> {
    @Override
    public boolean edit(NodeDrawProp node, SvgBrush brush) {
        NodeAttrs nodeAttrs = node.nodeAttrs();
        if (nodeAttrs.getImage() == null) {
            return true;
        }
        String nodeId = brush.nodeId(node.getNode());
        Element imageEle = brush.getOrCreateShapeEleById(nodeId + "image", "image");
        imageEle.setAttribute("xlink:href", nodeAttrs.getImage());
        if (nodeAttrs.getImageSize() != null) {
            FlatPoint imageSize = nodeAttrs.getImageSize();
            double width = imageSize.getWidth();
            double height = imageSize.getHeight();
            imageEle.setAttribute("width", String.valueOf(width));
            imageEle.setAttribute("height", String.valueOf(height));
            imageEle.setAttribute("x", String.valueOf(node.getX() - width / 2.0));
            imageEle.setAttribute("y", String.valueOf(node.getY() - height / 2.0));
        } else {
            imageEle.setAttribute("width", String.valueOf(node.getWidth()));
            imageEle.setAttribute("height", String.valueOf(node.getHeight()));
            imageEle.setAttribute("x", String.valueOf(node.getLeftBorder()));
            imageEle.setAttribute("y", String.valueOf(node.getUpBorder()));
        }
        return true;
    }
}

