/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.node;

import java.util.function.Consumer;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.NodeEditor;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;

public class NodeLabelEditor
extends SvgEditor
implements NodeEditor<SvgBrush> {
    @Override
    public boolean edit(NodeDrawProp nodeDrawProp, SvgBrush brush) {
        NodeAttrs nodeAttrs = nodeDrawProp.nodeAttrs();
        String label = nodeAttrs.getLabel();
        if (StringUtils.isEmpty(label) || nodeDrawProp.getCell() != null || nodeDrawProp.getLabelCenter() == null || nodeAttrs.getNodeShape().ignoreLabel()) {
            return true;
        }
        double fontSize = nodeAttrs.getFontSize() == null ? 0.0 : nodeAttrs.getFontSize();
        Consumer<SvgEditor.TextLineAttribute> lineConsumer = textLineAttribute -> {
            String id = SvgBrush.getId(brush.nodeId(nodeDrawProp.getNode()), "text_" + textLineAttribute.getLineNo());
            Element text = brush.getOrCreateChildElementById(id, "text");
            NodeLabelEditor.setText(text, fontSize, textLineAttribute);
            text.setTextContent(textLineAttribute.getLine());
        };
        NodeLabelEditor.text(new SvgEditor.TextAttribute(nodeDrawProp.getLabelCenter(), fontSize, label, nodeAttrs.getFontColor(), nodeAttrs.getFontName(), lineConsumer));
        return nodeDrawProp.nodeAttrs().getNodeShape() != NodeShapeEnum.PLAIN_TEXT;
    }
}

