/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.ext.StarPropCalc;
import org.graphper.def.FlatPoint;
import org.graphper.draw.CustomizeShapeRender;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.SvgEditor;
import org.graphper.draw.svg.node.AbstractNodeShapeEditor;
import org.graphper.layout.Cell;

public class NodeShapeEditor
extends AbstractNodeShapeEditor {
    @Override
    public boolean edit(NodeDrawProp nodeDrawProp, SvgBrush brush) {
        NodeShape nodeShape = nodeDrawProp.nodeAttrs().getNodeShape();
        CustomizeShapeRender customizeShapeRender = CustomizeShapeRender.getCustomizeShapeRender(nodeShape.getName());
        if (customizeShapeRender != null) {
            customizeShapeRender.drawSvg(brush, nodeDrawProp);
        } else if (nodeShape instanceof NodeShapeEnum) {
            this.drawNodeShapeEnum(nodeDrawProp, (NodeShapeEnum)nodeShape, brush);
        }
        return true;
    }

    private void drawNodeShapeEnum(NodeDrawProp nodeDrawProp, NodeShapeEnum nodeShape, SvgBrush brush) {
        switch (nodeShape) {
            case ELLIPSE: {
                this.ellipse(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
                break;
            }
            case CIRCLE: 
            case POINT: {
                this.circle(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
                break;
            }
            case UNDERLINE: {
                this.underline(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
                break;
            }
            case RECT: {
                this.rect(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
                break;
            }
            case TRIANGLE: {
                this.triangle(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
                break;
            }
            case DIAMOND: {
                this.diamond(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
                break;
            }
            case TRAPEZIUM: {
                this.trapezium(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
                break;
            }
            case PARALLELOGRAM: {
                this.parallelogram(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
                break;
            }
            case STAR: {
                this.start(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
                break;
            }
            case NOTE: {
                this.note(nodeDrawProp, brush);
                break;
            }
            case CYLINDER: {
                this.cylinder(nodeDrawProp, brush);
                break;
            }
            case RECORD: {
                this.record(nodeDrawProp, brush, false);
                break;
            }
            case M_RECORD: {
                this.record(nodeDrawProp, brush, true);
                break;
            }
            default: {
                this.circle(nodeDrawProp, this.singleElement(nodeDrawProp, brush));
            }
        }
    }

    private Element singleElement(NodeDrawProp nodeDrawProp, SvgBrush brush) {
        return brush.getShapeElement(nodeDrawProp, this.getShapeElement(nodeDrawProp));
    }

    private void ellipse(NodeDrawProp nodeDrawProp, Element shapeElement) {
        this.ellipse(nodeDrawProp, shapeElement, nodeDrawProp.getHeight() / 2.0, nodeDrawProp.getWidth() / 2.0);
    }

    private void circle(NodeDrawProp nodeDrawProp, Element shapeElement) {
        double radius = nodeDrawProp.getHeight() / 2.0;
        this.ellipse(nodeDrawProp, shapeElement, radius, radius);
    }

    private void ellipse(NodeDrawProp nodeDrawProp, Element shapeElement, double height, double width) {
        double x = nodeDrawProp.getX();
        double y = nodeDrawProp.getY();
        shapeElement.setAttribute("cx", String.valueOf(x));
        shapeElement.setAttribute("cy", String.valueOf(y));
        shapeElement.setAttribute("rx", String.valueOf(width));
        shapeElement.setAttribute("ry", String.valueOf(height));
    }

    private void underline(NodeDrawProp nodeDrawProp, Element shapeElement) {
        String points = SvgEditor.generatePolylinePoints(nodeDrawProp.getLeftBorder(), nodeDrawProp.getDownBorder(), nodeDrawProp.getRightBorder(), nodeDrawProp.getDownBorder());
        shapeElement.setAttribute("points", points);
    }

    private void rect(NodeDrawProp nodeDrawProp, Element shapeElement) {
        String points = SvgEditor.generateBox(nodeDrawProp);
        shapeElement.setAttribute("points", points);
    }

    private void triangle(NodeDrawProp nodeDrawProp, Element shapeElement) {
        String points = SvgEditor.generatePolylinePoints(nodeDrawProp.getX(), nodeDrawProp.getUpBorder(), nodeDrawProp.getLeftBorder(), nodeDrawProp.getDownBorder(), nodeDrawProp.getRightBorder(), nodeDrawProp.getDownBorder());
        shapeElement.setAttribute("points", points);
    }

    private void diamond(NodeDrawProp nodeDrawProp, Element shapeElement) {
        String points = SvgEditor.generatePolylinePoints(nodeDrawProp.getLeftBorder(), nodeDrawProp.getY(), nodeDrawProp.getX(), nodeDrawProp.getUpBorder(), nodeDrawProp.getRightBorder(), nodeDrawProp.getY(), nodeDrawProp.getX(), nodeDrawProp.getDownBorder(), nodeDrawProp.getLeftBorder(), nodeDrawProp.getY());
        shapeElement.setAttribute("points", points);
    }

    private void trapezium(NodeDrawProp nodeDrawProp, Element shapeElement) {
        double leftTopX = nodeDrawProp.getLeftBorder() + nodeDrawProp.getWidth() / 4.0;
        double rightTopX = nodeDrawProp.getRightBorder() - nodeDrawProp.getWidth() / 4.0;
        String points = SvgEditor.generatePolylinePoints(nodeDrawProp.getLeftBorder(), nodeDrawProp.getDownBorder(), leftTopX, nodeDrawProp.getUpBorder(), rightTopX, nodeDrawProp.getUpBorder(), nodeDrawProp.getRightBorder(), nodeDrawProp.getDownBorder(), nodeDrawProp.getLeftBorder(), nodeDrawProp.getDownBorder());
        shapeElement.setAttribute("points", points);
    }

    private void parallelogram(NodeDrawProp nodeDrawProp, Element shapeElement) {
        double leftTopX = nodeDrawProp.getLeftBorder() + nodeDrawProp.getWidth() / 5.0;
        double rightDownX = nodeDrawProp.getRightBorder() - nodeDrawProp.getWidth() / 5.0;
        String points = SvgEditor.generatePolylinePoints(nodeDrawProp.getLeftBorder(), nodeDrawProp.getDownBorder(), leftTopX, nodeDrawProp.getUpBorder(), nodeDrawProp.getRightBorder(), nodeDrawProp.getUpBorder(), rightDownX, nodeDrawProp.getDownBorder(), nodeDrawProp.getLeftBorder(), nodeDrawProp.getDownBorder());
        shapeElement.setAttribute("points", points);
    }

    private void start(NodeDrawProp nodeDrawProp, Element shapeElement) {
        double outerRadius = nodeDrawProp.getHeight() / 2.0;
        double innerRadius = outerRadius / StarPropCalc.IN_OUT_RATIO;
        double arc = 1.5707963267948966;
        double[] ps = new double[22];
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                ps[i * 2] = nodeDrawProp.getX() + Math.cos(arc) * outerRadius;
                ps[i * 2 + 1] = nodeDrawProp.getY() - Math.sin(arc) * outerRadius;
            } else {
                ps[i * 2] = nodeDrawProp.getX() + Math.cos(arc) * innerRadius;
                ps[i * 2 + 1] = nodeDrawProp.getY() - Math.sin(arc) * innerRadius;
            }
            ps[20] = ps[0];
            ps[21] = ps[1];
            arc += 0.6283185307179586;
        }
        shapeElement.setAttribute("points", SvgEditor.generatePolylinePoints(ps));
    }

    private void note(NodeDrawProp nodeDrawProp, SvgBrush brush) {
        String nodeId = brush.nodeId(nodeDrawProp.getNode());
        brush.getShapeElement(nodeDrawProp, this.getShapeElement(nodeDrawProp));
        String shape = NodeShapeEnum.NOTE.getName();
        Element firstEle = brush.getOrCreateChildElementById(nodeId + shape + "0", "polygon");
        String points = SvgEditor.generatePolylinePoints(nodeDrawProp.getLeftBorder(), nodeDrawProp.getUpBorder(), nodeDrawProp.getRightBorder() - 6.0, nodeDrawProp.getUpBorder(), nodeDrawProp.getRightBorder(), nodeDrawProp.getUpBorder() + 6.0, nodeDrawProp.getRightBorder(), nodeDrawProp.getDownBorder(), nodeDrawProp.getLeftBorder(), nodeDrawProp.getDownBorder(), nodeDrawProp.getLeftBorder(), nodeDrawProp.getUpBorder());
        firstEle.setAttribute("points", points);
        Element secondEle = brush.getOrCreateChildElementById(nodeId + shape + "1", "polygon");
        points = SvgEditor.generatePolylinePoints(nodeDrawProp.getRightBorder() - 6.0, nodeDrawProp.getUpBorder(), nodeDrawProp.getRightBorder() - 6.0, nodeDrawProp.getUpBorder() + 6.0, nodeDrawProp.getRightBorder(), nodeDrawProp.getUpBorder() + 6.0);
        secondEle.setAttribute("points", points);
        brush.addGroup("shapeGroupKey", Arrays.asList(firstEle, secondEle));
    }

    private void cylinder(NodeDrawProp nodeDrawProp, SvgBrush brush) {
        String nodeId = brush.nodeId(nodeDrawProp.getNode());
        brush.getShapeElement(nodeDrawProp, this.getShapeElement(nodeDrawProp));
        String shape = NodeShapeEnum.CYLINDER.getName();
        double up = nodeDrawProp.getUpBorder() + 6.0;
        double down = nodeDrawProp.getDownBorder() - 6.0;
        double v2x = nodeDrawProp.getLeftBorder() + nodeDrawProp.getWidth() / 4.0;
        double v3x = nodeDrawProp.getRightBorder() - nodeDrawProp.getWidth() / 4.0;
        String points = SvgEditor.pointsToSvgPath(true, nodeDrawProp.getLeftBorder(), up, nodeDrawProp.getLeftBorder(), up, nodeDrawProp.getLeftBorder(), down, nodeDrawProp.getLeftBorder(), down, v2x, nodeDrawProp.getDownBorder(), v3x, nodeDrawProp.getDownBorder(), nodeDrawProp.getRightBorder(), down, nodeDrawProp.getRightBorder(), down, nodeDrawProp.getRightBorder(), up, nodeDrawProp.getRightBorder(), up, v3x, nodeDrawProp.getUpBorder(), v2x, nodeDrawProp.getUpBorder(), nodeDrawProp.getLeftBorder(), up);
        Element firstEle = brush.getOrCreateChildElementById(nodeId + shape + "0", "path");
        firstEle.setAttribute("d", points);
        points = SvgEditor.pointsToSvgPath(true, nodeDrawProp.getLeftBorder(), up, v2x, up + 6.0, v3x, up + 6.0, nodeDrawProp.getRightBorder(), up);
        Element secondEle = brush.getOrCreateChildElementById(nodeId + shape + "1", "path");
        secondEle.setAttribute("d", points);
        brush.addGroup("shapeGroupKey", Arrays.asList(firstEle, secondEle));
    }

    private void record(NodeDrawProp nodeDrawProp, SvgBrush brush, boolean radianCorner) {
        Element border;
        Cell.RootCell Cell2 = nodeDrawProp.getCell();
        if (Cell2 == null) {
            return;
        }
        String nodeId = brush.nodeId(nodeDrawProp.getNode());
        String borderId = nodeId + NodeShapeEnum.RECORD.getName() + "0";
        if (radianCorner) {
            border = brush.getOrCreateChildElementById(borderId, "path");
            border.setAttribute("d", this.mrecordBorder(nodeDrawProp));
        } else {
            border = brush.getOrCreateChildElementById(borderId, "polygon");
            border.setAttribute("points", SvgEditor.generateBox(nodeDrawProp));
        }
        ArrayList<Element> cellElements = new ArrayList<Element>(Cell2.childrenSize());
        cellElements.add(border);
        if (!nodeDrawProp.haveChildrenCell()) {
            this.record(nodeDrawProp, Cell2, brush, nodeId, new int[]{1}, cellElements);
        }
        brush.addGroup("shapeGroupKey", cellElements);
    }

    private void record(NodeDrawProp nodeDrawProp, Cell cell, SvgBrush brush, String nodeId, int[] cellNo, List<Element> cellElements) {
        if (cell.isLeaf()) {
            return;
        }
        int no = cellNo[0] = cellNo[0] + 1;
        for (int i = 0; i < cell.childrenSize(); ++i) {
            Cell child = cell.getChild(i);
            this.record(nodeDrawProp, child, brush, nodeId, cellNo, cellElements);
            FlatPoint offset = child.getOffset();
            double upBorder = nodeDrawProp.getUpBorder();
            double leftBorder = nodeDrawProp.getLeftBorder();
            upBorder += offset.getY();
            leftBorder += offset.getX();
            String cellId = nodeId + NodeShapeEnum.RECORD.getName() + no + "_" + i;
            if (child.isLeaf() && StringUtils.isNotEmpty(child.getLabel())) {
                FlatPoint labelCenter = child.getCenter(nodeDrawProp);
                this.recordTextSet(nodeDrawProp, brush, child.getLabel(), cellId, labelCenter);
            }
            if (this.needIgnoreDrawSplit(i, cell.childrenSize(), child)) continue;
            this.setRecordSplitEle(cellId, cell, child, brush, upBorder, leftBorder, cellElements);
        }
    }

    private String mrecordBorder(NodeDrawProp nodeDrawProp) {
        return SvgEditor.roundedBox(40, nodeDrawProp);
    }

    private void setRecordSplitEle(String cellId, Cell parent, Cell child, SvgBrush brush, double upBorder, double leftBorder, List<Element> cellElements) {
        double cellRightBorder = leftBorder + child.getWidth();
        Element cellEle = brush.getOrCreateChildElementById(cellId, "path");
        String points = child.isHor() ? SvgEditor.pointsToSvgPath(false, cellRightBorder, upBorder, cellRightBorder, upBorder + parent.getHeight()) : SvgEditor.pointsToSvgPath(false, leftBorder, upBorder, cellRightBorder, upBorder);
        cellEle.setAttribute("d", points);
        cellElements.add(cellEle);
    }

    private void recordTextSet(NodeDrawProp nodeDrawProp, SvgBrush brush, String label, String cellId, FlatPoint labelCenter) {
        NodeAttrs nodeAttrs = nodeDrawProp.nodeAttrs();
        double fontSize = nodeAttrs.getFontSize() == null ? 0.0 : nodeAttrs.getFontSize();
        Consumer<SvgEditor.TextLineAttribute> lineConsumer = textLineAttribute -> {
            String id = SvgBrush.getId(brush.nodeId(nodeDrawProp.getNode()), cellId + "text" + "_" + textLineAttribute.getLineNo());
            Element text = brush.getOrCreateChildElementById(id, "text");
            SvgEditor.setText(text, fontSize, textLineAttribute);
            text.setTextContent(textLineAttribute.getLine());
        };
        SvgEditor.text(new SvgEditor.TextAttribute(labelCenter, fontSize, label, nodeAttrs.getFontColor(), nodeAttrs.getFontName(), lineConsumer));
    }

    private boolean needIgnoreDrawSplit(int idx, int size, Cell current) {
        return current.isHor() && idx == size - 1 || !current.isHor() && idx == 0;
    }
}

