/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw.svg.node;

import org.graphper.api.Node;
import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.attributes.NodeStyle;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.svg.Element;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.draw.svg.node.AbstractNodeShapeEditor;

public class NodeStyleEditor
extends AbstractNodeShapeEditor {
    @Override
    public boolean edit(NodeDrawProp node, SvgBrush brush) {
        for (Element element : brush.getEleGroup("shapeGroupKey")) {
            this.setStyle(node, brush, element);
        }
        return true;
    }

    private void setStyle(NodeDrawProp node, SvgBrush brush, Element element) {
        NodeAttrs nodeAttrs = node.nodeAttrs();
        Double penWidth = nodeAttrs.getPenWidth();
        if (penWidth != null) {
            element.setAttribute("stroke-width", String.valueOf(penWidth));
        }
        NodeStyle style = nodeAttrs.getStyle();
        element.setAttribute("fill", "none");
        if (style == null) {
            element.setAttribute("fill", "none");
            this.pointAddFillStyle(node, brush, nodeAttrs, element);
            return;
        }
        this.drawStyle(brush, node, element, style);
        this.pointAddFillStyle(node, brush, nodeAttrs, element);
    }

    private void pointAddFillStyle(NodeDrawProp node, SvgBrush brush, NodeAttrs nodeAttrs, Element shapeElement) {
        if (nodeAttrs.getNodeShape() == NodeShapeEnum.POINT) {
            this.drawStyle(brush, node, shapeElement, NodeStyle.SOLID);
        }
    }

    private void drawStyle(SvgBrush brush, NodeDrawProp node, Element shape, NodeStyle nodeStyle) {
        if (nodeStyle == NodeStyle.DASHED) {
            this.dashed(shape);
        } else if (nodeStyle == NodeStyle.DOTTED) {
            this.dotted(shape);
        } else if (nodeStyle == NodeStyle.INVIS) {
            this.invis(node.getNode(), brush);
        } else if (nodeStyle == NodeStyle.BOLD) {
            this.bold(shape);
        }
    }

    private void dashed(Element shape) {
        shape.setAttribute("fill", "none");
        shape.setAttribute("stroke-dasharray", "5,2");
    }

    private void dotted(Element shape) {
        shape.setAttribute("fill", "none");
        shape.setAttribute("stroke-dasharray", "1,5");
    }

    private void invis(Node node, SvgBrush brush) {
        brush.drawBoard().removeNode(node);
    }

    private void bold(Element shape) {
        shape.setAttribute("stroke-width", "2");
    }
}

