/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.def.FlatPoint;
import org.graphper.layout.FontSelector;
import org.graphper.layout.MeasureText;
import org.graphper.util.FontUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWTMeasureText
implements MeasureText,
FontSelector {
    private static final Logger log = LoggerFactory.getLogger(AWTMeasureText.class);
    private static Constructor<?> FONT_CONS;
    private static Method GET_TRANSFORM;
    private static Method TEXT_GET_WIDTH;
    private static Method TEXT_GET_HEIGHT;
    private static Method STRING_BOUNDS_METHOD;
    private static Constructor<?> RENDER_CONSTRUCTOR;

    @Override
    public int order() {
        return 0;
    }

    @Override
    public boolean envSupport() {
        return AWTMeasureText.checkEnvSupport();
    }

    @Override
    public FlatPoint measure(String text, String fontName, double fontSize) {
        if (StringUtils.isEmpty(text) || fontSize <= 0.0) {
            return new FlatPoint(0.0, 0.0);
        }
        try {
            fontName = fontName == null ? FontUtils.DEFAULT_FONT : fontName;
            Object font = AWTMeasureText.newFont(fontName, (int)fontSize);
            Object affineTransform = GET_TRANSFORM.invoke(font, new Object[0]);
            Object render = RENDER_CONSTRUCTOR.newInstance(affineTransform, true, true);
            Object rectangle = STRING_BOUNDS_METHOD.invoke(font, text, render);
            double w = (Double)TEXT_GET_WIDTH.invoke(rectangle, new Object[0]);
            double h = (Double)TEXT_GET_HEIGHT.invoke(rectangle, new Object[0]) * (double)text.split("\n").length;
            return new FlatPoint(h, w);
        }
        catch (Exception e) {
            log.error("Measure text size had occurred error: ", (Throwable)e);
            return new FlatPoint(0.0, 0.0);
        }
    }

    private static boolean checkEnvSupport() {
        try {
            Class.forName("java.awt.Canvas");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Object newFont(String fontName, int fontSize) throws Exception {
        return FONT_CONS.newInstance(fontName, 0, fontSize);
    }

    private static Object fontMetrics(String fontName, int fontSize, Object fontMetricCanvas, Class<?> canvasClazz, Class<?> fontClazz) throws Exception {
        Object font = AWTMeasureText.newFont(fontName, fontSize);
        Method fontMetrics = canvasClazz.getMethod("getFontMetrics", fontClazz);
        fontMetrics.invoke(fontMetricCanvas, font);
        return font;
    }

    @Override
    public String defaultFont() {
        return "Default";
    }

    static {
        if (AWTMeasureText.checkEnvSupport()) {
            try {
                Class<?> canvasClazz = Class.forName("java.awt.Canvas");
                Object fontMetricCanvas = canvasClazz.newInstance();
                Class<?> fontClazz = Class.forName("java.awt.Font");
                GET_TRANSFORM = fontClazz.getMethod("getTransform", new Class[0]);
                FONT_CONS = fontClazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE);
                Class<?> affineTransform = Class.forName("java.awt.geom.AffineTransform");
                Class<?> fontRenderContext = Class.forName("java.awt.font.FontRenderContext");
                RENDER_CONSTRUCTOR = fontRenderContext.getConstructor(affineTransform, Boolean.TYPE, Boolean.TYPE);
                STRING_BOUNDS_METHOD = fontClazz.getMethod("getStringBounds", String.class, fontRenderContext);
                Class<?> rectangle2D = Class.forName("java.awt.geom.Rectangle2D");
                TEXT_GET_WIDTH = rectangle2D.getMethod("getWidth", new Class[0]);
                TEXT_GET_HEIGHT = rectangle2D.getMethod("getHeight", new Class[0]);
                AWTMeasureText.fontMetrics(null, 0, fontMetricCanvas, canvasClazz, fontClazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

