/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.graphper.api.Assemble;
import org.graphper.api.Cluster;
import org.graphper.api.ClusterAttrs;
import org.graphper.api.GraphAttrs;
import org.graphper.api.GraphContainer;
import org.graphper.api.Graphviz;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.Node;
import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.Labeljust;
import org.graphper.api.attributes.Labelloc;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.ext.NodeShapePost;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.ContainerDrawProp;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.RenderEngine;
import org.graphper.layout.Cell;
import org.graphper.layout.CellLabelCompiler;
import org.graphper.layout.CombineShifter;
import org.graphper.layout.DefaultVal;
import org.graphper.layout.LayoutAttach;
import org.graphper.layout.LayoutEngine;
import org.graphper.layout.Shifter;
import org.graphper.layout.ShifterStrategy;
import org.graphper.util.Asserts;
import org.graphper.util.ClassUtils;
import org.graphper.util.CollectionUtils;
import org.graphper.util.FontUtils;
import org.graphper.util.GraphvizUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayoutEngine
implements LayoutEngine {
    private static final Logger log = LoggerFactory.getLogger(AbstractLayoutEngine.class);
    private static final Map<String, Object> DEFAULT_NODE_ATTRS_MAP;
    private static final Map<String, Object> DEFAULT_CELL_ATTRS_MAP;
    private static final Map<String, Object> DEFAULT_LINE_ATTRS_MAP;

    public static void nodeLabelSet(NodeDrawProp nodeDrawProp, DrawGraph drawGraph, boolean needSetCenter) {
        Assemble assemble;
        if (nodeDrawProp == null || drawGraph == null) {
            return;
        }
        NodeShape nodeShape = nodeDrawProp.nodeAttrs().getNodeShape();
        FlatPoint labelCenter = Boolean.TRUE.equals(nodeDrawProp.nodeAttrs().getFixedSize()) ? new FlatPoint(nodeDrawProp.getX(), nodeDrawProp.getY()) : nodeShape.labelCenter(nodeDrawProp.getLabelSize(), nodeDrawProp);
        double x = labelCenter.getX();
        double y = labelCenter.getY();
        Labelloc labelloc = nodeDrawProp.nodeAttrs().getLabelloc();
        if (labelloc != null && nodeDrawProp.getLabelSize() != null) {
            FlatPoint labelSize = nodeDrawProp.getLabelSize();
            x += nodeDrawProp.getLabelHorOffset();
            y += nodeDrawProp.getLabelVerOffset();
            if (!needSetCenter) {
                drawGraph.updateXAxisRange(x - labelSize.getWidth() / 2.0);
                drawGraph.updateXAxisRange(x + labelSize.getWidth() / 2.0);
                drawGraph.updateYAxisRange(y - labelSize.getWidth() / 2.0);
                drawGraph.updateYAxisRange(y + labelSize.getWidth() / 2.0);
            }
        }
        if (needSetCenter) {
            nodeDrawProp.setLabelCenter(new FlatPoint(x, y));
        }
        if ((assemble = nodeDrawProp.getAssemble()) == null || nodeDrawProp.getLabelCenter() == null) {
            return;
        }
        AbstractLayoutEngine.setCellNodeOffset(drawGraph, labelCenter, assemble, false);
    }

    public static void setCellNodeOffset(DrawGraph drawGraph, FlatPoint labelCenter, Assemble assemble, boolean userLabelSize) {
        if (assemble == null || drawGraph == null || labelCenter == null) {
            return;
        }
        FlatPoint labelSize = assemble.size();
        for (Node cell : assemble.getCells()) {
            NodeDrawProp cellProp = drawGraph.getNodeDrawProp(cell);
            if (cellProp == null) continue;
            if (userLabelSize) {
                cellProp.initCellPos(labelSize, labelCenter, assemble);
            } else {
                cellProp.initCellPos();
            }
            drawGraph.updateXAxisRange(cellProp.getLeftBorder() - 5.0);
            drawGraph.updateXAxisRange(cellProp.getRightBorder() + 5.0);
            drawGraph.updateYAxisRange(cellProp.getUpBorder() - 5.0);
            drawGraph.updateYAxisRange(cellProp.getDownBorder() + 5.0);
            AbstractLayoutEngine.nodeLabelSet(cellProp, drawGraph, true);
        }
    }

    @Override
    public DrawGraph layout(Graphviz graphviz, RenderEngine renderEngine) {
        Asserts.nullArgument(graphviz, "Graphviz");
        Asserts.illegalArgument(graphviz.nodeNum() == 0, "Graphviz container is empty!");
        DrawGraph drawGraph = new DrawGraph(graphviz);
        LayoutAttach attachment = this.attachment(drawGraph);
        HashMap<Node, Integer> nodeId = new HashMap<Node, Integer>(graphviz.nodeNum());
        HashMap<Line, Integer> lineId = new HashMap<Line, Integer>(graphviz.lineNum());
        HashMap<GraphContainer, Integer> clusterId = new HashMap<GraphContainer, Integer>(graphviz.clusters().size());
        Consumer<GraphContainer> containerConsumer = c -> this.nodeLineClusterHandle(attachment, drawGraph, (GraphContainer)c, (Map<Node, Integer>)nodeId, (Map<Line, Integer>)lineId, (Map<GraphContainer, Integer>)clusterId);
        GraphvizUtils.dfs(Integer.MAX_VALUE, (boolean)Boolean.FALSE, new HashSet<GraphContainer>(), null, (GraphContainer)graphviz, containerConsumer::accept, containerConsumer::accept, this::dfsNeedContinue);
        this.nodeLineClusterHandle(attachment, drawGraph, graphviz, nodeId, lineId, clusterId);
        this.handleGraphviz(attachment, nodeId, drawGraph);
        this.layout(drawGraph, attachment);
        this.moveGraph(drawGraph, renderEngine, attachment);
        return drawGraph;
    }

    protected LayoutAttach attachment(DrawGraph drawGraph) {
        return null;
    }

    protected void consumerNode(Node node, LayoutAttach attachment, DrawGraph drawGraph, GraphContainer parentContainer) {
    }

    protected void consumerLine(Line line, LayoutAttach attach, DrawGraph drawGraph) {
    }

    protected void afterLayoutShifter(LayoutAttach attach) {
    }

    protected void afterRenderShifter(LayoutAttach attach) {
    }

    protected FlatPoint labelContainer(String label, String fontName, double fontSize) {
        return FontUtils.measure(label, fontName, fontSize, 0.0);
    }

    protected void containerLabelPos(DrawGraph drawGraph) {
        GraphvizDrawProp graphvizDrawProp = drawGraph.getGraphvizDrawProp();
        if (graphvizDrawProp.getLabelSize() != null) {
            GraphAttrs graphAttrs = graphvizDrawProp.getGraphviz().graphAttrs();
            this.containerLabelPos(graphvizDrawProp, graphAttrs.getLabelloc(), graphAttrs.getLabeljust());
        }
        for (ClusterDrawProp cluster : drawGraph.clusters()) {
            if (cluster.getLabelSize() == null) continue;
            ClusterAttrs clusterAttrs = cluster.getCluster().clusterAttrs();
            this.containerLabelPos(cluster, clusterAttrs.getLabelloc(), clusterAttrs.getLabeljust());
        }
    }

    protected abstract void layout(DrawGraph var1, LayoutAttach var2);

    protected abstract List<ShifterStrategy> shifterStrategies(DrawGraph var1);

    private void handleGraphviz(LayoutAttach attach, Map<Node, Integer> nodeId, DrawGraph drawGraph) {
        GraphvizDrawProp graphvizDrawProp = drawGraph.getGraphvizDrawProp();
        Graphviz graphviz = graphvizDrawProp.getGraphviz();
        GraphAttrs graphAttrs = graphviz.graphAttrs();
        Assemble assemble = graphvizDrawProp.getAssemble();
        FlatPoint labelSize = null;
        if (assemble == null) {
            String label = graphAttrs.getLabel();
            if (label != null) {
                labelSize = this.labelContainer(label, graphAttrs.getFontName(), graphAttrs.getFontSize());
            }
        } else {
            labelSize = assemble.size();
            this.assembleHandle(attach, drawGraph, null, nodeId, assemble);
        }
        graphvizDrawProp.setLabelSize(labelSize);
    }

    private void containerLabelPos(ContainerDrawProp containerDrawProp, Labelloc labelloc, Labeljust labeljust) {
        FlatPoint upperLeft = new FlatPoint(containerDrawProp.getLeftBorder(), containerDrawProp.getUpBorder());
        FlatPoint lowerRight = new FlatPoint(containerDrawProp.getRightBorder(), containerDrawProp.getDownBorder());
        FlatPoint labelPoint = new FlatPoint(labeljust.getX(upperLeft, lowerRight, containerDrawProp.getLabelSize()), labelloc.getY(upperLeft, lowerRight, containerDrawProp.getLabelSize()));
        containerDrawProp.setLabelCenter(labelPoint);
    }

    private boolean dfsNeedContinue(GraphContainer c) {
        return !c.isSubgraph() || c.isTransparent();
    }

    private void nodeLineClusterHandle(LayoutAttach attachment, DrawGraph drawGraph, GraphContainer container, Map<Node, Integer> nodeId, Map<Line, Integer> lineId, Map<GraphContainer, Integer> clusterId) {
        Iterable<Line> lines;
        Iterable<Node> nodes;
        if (this.dfsNeedContinue(container)) {
            nodes = container.directNodes();
            lines = container.directLines();
        } else {
            nodes = container.nodes();
            lines = container.lines();
        }
        for (Node node : nodes) {
            this.nodeHandle(attachment, drawGraph, container, nodeId, node, null, null, false, true, 0);
        }
        for (Line line : lines) {
            this.nodeHandle(attachment, drawGraph, container, nodeId, line.head(), null, null, false, true, 0);
            this.nodeHandle(attachment, drawGraph, container, nodeId, line.tail(), null, null, false, true, 0);
            this.lineHandle(attachment, drawGraph, container, lineId, nodeId, line);
        }
        if (container.isCluster()) {
            this.clusterHandle(attachment, drawGraph, (Cluster)container, nodeId, clusterId);
        }
    }

    private void nodeHandle(LayoutAttach attachment, DrawGraph drawGraph, GraphContainer container, Map<Node, Integer> nodeId, Node node, Cell.RootCell rootCell, FlatPoint offset, boolean isCell, boolean needCalcOffset, int depth) {
        Asserts.illegalArgument(depth > 1000, "The nesting depth of cell exceeds the upper limit");
        NodeDrawProp nodeDrawProp = drawGraph.getNodeDrawProp(node);
        NodeAttrs nodeAttrs = nodeDrawProp != null ? nodeDrawProp.nodeAttrs() : node.nodeAttrs().clone();
        try {
            if (isCell) {
                this.copyTempProperties(nodeAttrs, null, DEFAULT_CELL_ATTRS_MAP);
            } else {
                this.copyTempProperties(nodeAttrs, this.findFirstHaveTempParent(drawGraph.getGraphviz(), true, container), DEFAULT_NODE_ATTRS_MAP);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to access template property", e);
        }
        if (nodeDrawProp == null) {
            Assemble assemble;
            nodeDrawProp = new NodeDrawProp(node, nodeAttrs);
            drawGraph.nodePut(node, nodeDrawProp);
            Integer n = nodeId.get(node);
            if (n == null) {
                int nz = nodeId.size();
                nodeDrawProp.setId(nz);
                nodeId.put(node, nz);
            }
            this.nodeContainerSet(nodeDrawProp, nodeAttrs, drawGraph.needFlip());
            if (needCalcOffset && (nodeDrawProp.haveChildrenCell() || isCell)) {
                Cell cell = null;
                if (rootCell == null) {
                    rootCell = new Cell.RootCell(false);
                    nodeDrawProp.setCell(rootCell);
                    cell = rootCell;
                } else {
                    String id = nodeAttrs.getId();
                    if (id != null) {
                        cell = new Cell(false);
                        rootCell.put(id, cell);
                        if (rootCell.children == null) {
                            rootCell.children = new ArrayList(2);
                        }
                        rootCell.children.add(cell);
                    }
                }
                if (cell != null) {
                    cell.setShape(nodeAttrs.getNodeShape());
                    cell.setWidth(nodeDrawProp.getWidth());
                    cell.setHeight(nodeDrawProp.getHeight());
                    cell.setOffset(offset);
                }
            }
            if ((assemble = nodeDrawProp.getAssemble()) != null) {
                if (needCalcOffset) {
                    AbstractLayoutEngine.nodeLabelSet(nodeDrawProp, drawGraph, true);
                    FlatPoint center = nodeDrawProp.getLabelCenter();
                    FlatPoint labelSize = nodeDrawProp.getLabelSize();
                    if (center != null && labelSize != null) {
                        double vo = center.getY() - labelSize.getHeight() / 2.0 - nodeDrawProp.getUpBorder();
                        double ho = center.getX() - labelSize.getWidth() / 2.0 - nodeDrawProp.getLeftBorder();
                        if (offset == null) {
                            offset = new FlatPoint(ho, vo);
                        } else {
                            offset.setY(offset.getY() + vo);
                            offset.setX(offset.getX() + ho);
                        }
                        for (Node c : assemble.getCells()) {
                            double horOffset = assemble.horOffset(c);
                            double verOffset = assemble.verOffset(c);
                            FlatPoint of = new FlatPoint(offset.getX() + horOffset, offset.getY() + verOffset);
                            this.nodeHandle(attachment, drawGraph, container, nodeId, c, rootCell, of, true, needCalcOffset, depth + 1);
                            NodeDrawProp cellProp = drawGraph.getNodeDrawProp(c);
                            cellProp.setCellContainer(nodeDrawProp);
                        }
                    }
                } else {
                    for (Node c : assemble.getCells()) {
                        this.nodeHandle(attachment, drawGraph, container, nodeId, c, null, null, true, needCalcOffset, depth + 1);
                        NodeDrawProp cellProp = drawGraph.getNodeDrawProp(c);
                        cellProp.setCellContainer(nodeDrawProp);
                    }
                }
            }
        } else {
            nodeDrawProp.setNodeAttrs(nodeAttrs);
        }
        if (isCell) {
            nodeDrawProp.markIsCellProp();
        } else {
            this.consumerNode(node, attachment, drawGraph, container);
        }
    }

    private void lineHandle(LayoutAttach attachment, DrawGraph drawGraph, GraphContainer container, Map<Line, Integer> lineId, Map<Node, Integer> nodeId, Line line) {
        Integer n;
        LineDrawProp lineDrawProp = drawGraph.getLineDrawProp(line);
        LineAttrs lineAttrs = lineDrawProp != null ? lineDrawProp.lineAttrs() : line.lineAttrs().clone();
        try {
            this.copyTempProperties(lineAttrs, this.findFirstHaveTempParent(drawGraph.getGraphviz(), false, container), DEFAULT_LINE_ATTRS_MAP);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to access template property", e);
        }
        if (lineDrawProp == null) {
            lineDrawProp = new LineDrawProp(line, lineAttrs, drawGraph);
            drawGraph.linePut(line, lineDrawProp);
            Assemble assemble = lineDrawProp.getAssemble();
            this.assembleHandle(attachment, drawGraph, container, nodeId, assemble);
            for (Assemble floatAssemble : lineDrawProp.getFloatAssembles()) {
                this.assembleHandle(attachment, drawGraph, container, nodeId, floatAssemble);
            }
        }
        if ((n = lineId.get(line)) == null) {
            int nz = lineId.size();
            lineDrawProp.setId("line_" + nz);
            lineId.put(line, nz);
        }
        this.consumerLine(line, attachment, drawGraph);
    }

    private void assembleHandle(LayoutAttach attach, DrawGraph drawGraph, GraphContainer container, Map<Node, Integer> nodeId, Assemble assemble) {
        if (assemble == null) {
            return;
        }
        for (Node cell : assemble.getCells()) {
            this.nodeHandle(attach, drawGraph, container, nodeId, cell, null, null, true, false, 0);
        }
    }

    private void clusterHandle(LayoutAttach attach, DrawGraph drawGraph, Cluster cluster, Map<Node, Integer> nodeId, Map<GraphContainer, Integer> clusterId) {
        if (drawGraph.haveCluster(cluster)) {
            return;
        }
        ClusterDrawProp clusterDrawProp = new ClusterDrawProp(cluster);
        drawGraph.clusterPut(cluster, clusterDrawProp);
        Integer n = clusterId.get(cluster);
        if (n == null) {
            int nz = clusterId.size();
            clusterDrawProp.setClusterNo(nz);
            clusterDrawProp.setId("cluster_" + nz);
            clusterId.put(cluster, nz);
        }
        Assemble assemble = clusterDrawProp.getAssemble();
        this.assembleHandle(attach, drawGraph, null, nodeId, assemble);
        ClusterAttrs clusterAttrs = cluster.clusterAttrs();
        String label = clusterAttrs.getLabel();
        double fontSize = clusterAttrs.getFontSize();
        FlatPoint labelContainer = null;
        if (assemble == null) {
            if (label != null) {
                labelContainer = this.labelContainer(label, clusterAttrs.getFontName(), fontSize);
            }
        } else {
            labelContainer = assemble.size();
        }
        drawGraph.getClusterDrawProp(cluster).setLabelSize(labelContainer);
    }

    private void nodeContainerSet(NodeDrawProp nodeDrawProp, NodeAttrs nodeAttrs, boolean needFlip) {
        FlatPoint boxSize;
        boolean ignoreLabel;
        FlatPoint labelBox;
        NodeShape nodeShape = nodeAttrs.getNodeShape();
        double height = nodeAttrs.getHeight() == null ? nodeShape.getDefaultHeight() : nodeAttrs.getHeight().doubleValue();
        double width = nodeAttrs.getWidth() == null ? nodeShape.getDefaultWidth() : nodeAttrs.getWidth().doubleValue();
        double verMargin = 0.0;
        double horMargin = 0.0;
        if (nodeDrawProp.noChildrenCell() && this.isRecordShape(nodeShape)) {
            Cell.RootCell rootCell = CellLabelCompiler.compile(nodeAttrs.getLabel(), nodeAttrs.getFontName(), this.getFontSize(nodeAttrs), nodeAttrs.getMargin(), new FlatPoint(height, width), needFlip);
            labelBox = new FlatPoint(rootCell.getHeight(), rootCell.getWidth());
            nodeDrawProp.setCell(rootCell);
        } else {
            labelBox = this.sizeInit(nodeDrawProp.getAssemble(), nodeAttrs);
            if (nodeAttrs.getMargin() != null && nodeShape.needMargin()) {
                verMargin += nodeAttrs.getMargin().getHeight();
                horMargin += nodeAttrs.getMargin().getWidth();
            }
        }
        boolean bl = ignoreLabel = Boolean.TRUE.equals(nodeAttrs.getFixedSize()) || nodeShape.ignoreLabel();
        if (ignoreLabel) {
            boxSize = new FlatPoint(height, width);
        } else {
            FlatPoint labelSize = new FlatPoint(labelBox.getHeight(), labelBox.getWidth());
            if (nodeAttrs.getImageSize() != null) {
                FlatPoint imageSize = nodeAttrs.getImageSize();
                double h = Math.max(imageSize.getHeight() + verMargin, labelSize.getHeight());
                double w = Math.max(imageSize.getWidth() + horMargin, labelSize.getWidth());
                boxSize = nodeShape.minContainerSize(h, w);
            } else {
                boxSize = nodeShape.minContainerSize(labelSize.getHeight() + verMargin, labelSize.getWidth() + horMargin);
            }
            Asserts.illegalArgument(boxSize == null, "Node Shape can not return null box size from minContainerSize");
            boxSize.setHeight(Math.max(boxSize.getHeight(), height));
            boxSize.setWidth(Math.max(boxSize.getWidth(), width));
            nodeShape.ratio(boxSize);
            nodeDrawProp.setLabelSize(labelSize);
        }
        nodeDrawProp.setLeftBorder(0.0);
        nodeDrawProp.setRightBorder(boxSize.getWidth());
        nodeDrawProp.setUpBorder(0.0);
        nodeDrawProp.setDownBorder(boxSize.getHeight());
        if (nodeDrawProp.getLabelSize() == null) {
            nodeDrawProp.setLabelSize(labelBox);
        }
        if (ignoreLabel) {
            this.labelOffset(nodeDrawProp, nodeAttrs, labelBox, boxSize.getHeight() - labelBox.getHeight(), boxSize.getWidth() - labelBox.getWidth());
        } else {
            this.labelOffset(nodeDrawProp, nodeAttrs, labelBox, verMargin, horMargin);
        }
    }

    private void labelOffset(NodeDrawProp nodeDrawProp, NodeAttrs nodeAttrs, FlatPoint labelBox, double verMargin, double horMargin) {
        double halfHeight = (verMargin + labelBox.getHeight()) / 2.0;
        double halfWidth = (horMargin + labelBox.getWidth()) / 2.0;
        Labelloc labelloc = nodeAttrs.getLabelloc();
        Labeljust labeljust = nodeAttrs.getLabeljust();
        if (labelloc != null) {
            double offsetY = labelloc.getY(new FlatPoint(-halfWidth, -halfHeight), new FlatPoint(halfWidth, halfHeight), labelBox);
            nodeDrawProp.setLabelVerOffset(offsetY);
        }
        if (labeljust != null) {
            double offsetX = labeljust.getX(new FlatPoint(-halfWidth, -halfHeight), new FlatPoint(halfWidth, halfHeight), labelBox);
            nodeDrawProp.setLabelHorOffset(offsetX);
        }
    }

    private GraphContainer findFirstHaveTempParent(Graphviz graphviz, boolean nodeTemp, GraphContainer container) {
        GraphContainer p = container;
        while (!(p == null || nodeTemp && p.haveNodeTemp() || !nodeTemp && p.haveLineTemp())) {
            p = graphviz.father(p);
        }
        return p;
    }

    private FlatPoint sizeInit(Assemble assemble, NodeAttrs nodeAttrs) {
        if (assemble != null) {
            return assemble.size();
        }
        String label = nodeAttrs.getLabel();
        return this.labelContainer(label, nodeAttrs.getFontName(), this.getFontSize(nodeAttrs));
    }

    private double getFontSize(NodeAttrs nodeAttrs) {
        return nodeAttrs.getFontSize() != null ? nodeAttrs.getFontSize() : 0.0;
    }

    private void copyTempProperties(Object attrs, GraphContainer container, Map<String, Object> defaultVal) throws IllegalAccessException {
        Field[] fields;
        Objects.requireNonNull(defaultVal);
        if (attrs == null) {
            return;
        }
        NodeShapePost nodeShape = null;
        Field nodeShapeField = null;
        Class<?> cls = attrs.getClass();
        for (Field field : fields = cls.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Object v = field.get(attrs);
            if (v == null) {
                Object propVal = container == null ? null : (attrs instanceof NodeAttrs ? container.getNodeAttr(field.getName()) : container.getLineAttr(field.getName()));
                Object object = propVal = propVal != null ? propVal : defaultVal.get(field.getName());
                if (propVal == null) {
                    field.setAccessible(false);
                    continue;
                }
                if (Objects.equals("assemble", field.getName()) || Objects.equals("table", field.getName())) {
                    log.warn("Can not copy " + field.getName() + " attribute!");
                    field.setAccessible(false);
                    continue;
                }
                field.set(attrs, propVal);
                field.setAccessible(false);
                v = propVal;
            }
            if (!(v instanceof NodeShape)) continue;
            nodeShape = (NodeShape)v;
            nodeShapeField = field;
        }
        if (nodeShape != null && attrs instanceof NodeAttrs) {
            nodeShapeField.setAccessible(true);
            nodeShapeField.set(attrs, nodeShape.post((NodeAttrs)attrs));
            nodeShapeField.setAccessible(false);
        }
    }

    private void moveGraph(DrawGraph drawGraph, RenderEngine renderEngine, LayoutAttach attach) {
        List<ShifterStrategy> renderShifters;
        CombineShifter shifter;
        List<ShifterStrategy> layoutShifters = this.shifterStrategies(drawGraph);
        HashSet<FlatPoint> pointMark = null;
        if (CollectionUtils.isNotEmpty(layoutShifters)) {
            pointMark = new HashSet<FlatPoint>();
            shifter = new CombineShifter(pointMark, layoutShifters);
            this.executeShifter(drawGraph, shifter);
        }
        this.afterLayoutShifter(attach);
        if (pointMark != null) {
            pointMark.clear();
        }
        List<ShifterStrategy> list = renderShifters = renderEngine == null ? null : renderEngine.shifterStrategies(drawGraph);
        if (CollectionUtils.isNotEmpty(renderShifters)) {
            if (pointMark == null) {
                pointMark = new HashSet();
            }
            shifter = new CombineShifter(pointMark, renderShifters);
            this.executeShifter(drawGraph, shifter);
        }
        this.afterRenderShifter(attach);
        if (renderEngine != null && renderEngine.needShift(drawGraph)) {
            if (pointMark != null) {
                pointMark.clear();
            } else {
                pointMark = new HashSet();
            }
            renderShifters = renderEngine.shifterStrategies(drawGraph);
            if (CollectionUtils.isNotEmpty(renderShifters)) {
                shifter = new CombineShifter(pointMark, renderShifters);
                this.executeShifter(drawGraph, shifter);
            }
        }
    }

    private void executeShifter(DrawGraph drawGraph, Shifter shifter) {
        shifter.graph(drawGraph.getGraphvizDrawProp());
        drawGraph.clusters().forEach(shifter::cluster);
        drawGraph.nodes().forEach(shifter::node);
        drawGraph.lines().forEach(shifter::line);
    }

    private boolean isRecordShape(NodeShape nodeShape) {
        return nodeShape == NodeShapeEnum.RECORD || nodeShape == NodeShapeEnum.M_RECORD;
    }

    static {
        try {
            DEFAULT_NODE_ATTRS_MAP = ClassUtils.propValMap(DefaultVal.DEFAULT_NODE_ATTRS);
            DEFAULT_CELL_ATTRS_MAP = ClassUtils.propValMap(DefaultVal.DEFAULT_CELL_ATTRS);
            DEFAULT_LINE_ATTRS_MAP = ClassUtils.propValMap(DefaultVal.DEFAULT_LINE_ATTRS);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to set default properties", e);
        }
    }
}

