/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.def.FlatPoint;
import org.graphper.layout.FontSelector;
import org.graphper.layout.MeasureText;
import org.graphper.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidMeasureText
implements MeasureText,
FontSelector {
    private static final Logger log = LoggerFactory.getLogger(AndroidMeasureText.class);
    private static Class<?> RECT;
    private static Class<?> TEXT_PAIN;

    @Override
    public int order() {
        return 0;
    }

    @Override
    public boolean envSupport() {
        return RECT != null && TEXT_PAIN != null;
    }

    @Override
    public String defaultFont() {
        return "Times New Roman";
    }

    @Override
    public FlatPoint measure(String text, String fontName, double fontSize) {
        if (StringUtils.isEmpty(text)) {
            return new FlatPoint(0.0, 0.0);
        }
        try {
            Object myTextPaint = ClassUtils.newObject(TEXT_PAIN);
            ClassUtils.invoke(myTextPaint, "setAntiAlias", true);
            ClassUtils.invoke(myTextPaint, "setTextSize", Float.valueOf((float)fontSize));
            Object bounds = ClassUtils.newObject(RECT);
            ClassUtils.invoke(myTextPaint, "getTextBounds", text, 0, text.length(), bounds);
            double width = ((Integer)ClassUtils.invoke(bounds, "width")).intValue();
            double height = (double)((Integer)ClassUtils.invoke(bounds, "height")).intValue() * (double)text.split("\n").length;
            return new FlatPoint(height, width);
        }
        catch (Exception e) {
            log.error("Measure text size had occurred error: ", (Throwable)e);
            return new FlatPoint(0.0, 0.0);
        }
    }

    static {
        try {
            RECT = Class.forName("android.graphics.Rect");
            TEXT_PAIN = Class.forName("android.text.TextPaint");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

