/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.attributes.Rankdir;
import org.graphper.api.ext.Box;
import org.graphper.def.FlatPoint;
import org.graphper.draw.Rectangle;
import org.graphper.util.CollectionUtils;

public class Cell {
    protected final boolean isHor;
    protected String id;
    protected String label;
    protected double width;
    protected double height;
    protected FlatPoint offset;
    protected Cell parent;
    protected List<Cell> children;
    protected NodeShape shape = NodeShapeEnum.RECT;

    public Cell(boolean isHor) {
        this.isHor = isHor;
    }

    public boolean isHor() {
        return this.isHor;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public FlatPoint getOffset() {
        return this.offset;
    }

    public void setOffset(FlatPoint offset) {
        this.offset = offset;
    }

    public Cell getParent() {
        return this.parent;
    }

    public void setParent(Cell parent) {
        this.parent = parent;
    }

    public void setChildren(List<Cell> children) {
        this.children = children;
    }

    public NodeShape getShape() {
        return this.shape;
    }

    public void setShape(NodeShape shape) {
        this.shape = shape;
    }

    public int childrenSize() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public Cell getChild(int i) {
        if (this.children == null) {
            return null;
        }
        if (i < 0 || i >= this.children.size()) {
            return null;
        }
        return this.children.get(i);
    }

    public List<Cell> getChildren() {
        if (CollectionUtils.isEmpty(this.children)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    public boolean isLeaf() {
        return CollectionUtils.isEmpty(this.children);
    }

    public FlatPoint getCenter(Box box) {
        if (box == null || this.offset == null) {
            return new FlatPoint(this.width / 2.0, this.height / 2.0);
        }
        double upBorder = box.getUpBorder();
        double leftBorder = box.getLeftBorder();
        return new FlatPoint((leftBorder += this.offset.getX()) + this.width / 2.0, (upBorder += this.offset.getY()) + this.height / 2.0);
    }

    public Rectangle getCellBox(Box box) {
        FlatPoint cellCenter = this.getCenter(box);
        Rectangle cellRect = new Rectangle();
        cellRect.setUpBorder(cellCenter.getY() - this.getHeight() / 2.0);
        cellRect.setDownBorder(cellCenter.getY() + this.getHeight() / 2.0);
        cellRect.setLeftBorder(cellCenter.getX() - this.getWidth() / 2.0);
        cellRect.setRightBorder(cellCenter.getX() + this.getWidth() / 2.0);
        return cellRect;
    }

    public void flip(Rankdir rankdir, Box rootBox) {
        if (rankdir == null || rankdir == Rankdir.TB || rootBox == null) {
            return;
        }
        if (rankdir == Rankdir.BT) {
            if (this.offset != null) {
                this.offset.setY(rootBox.getHeight() - this.offset.getY() - this.height);
            }
        } else {
            double tmp;
            if (this.offset != null) {
                if (rankdir == Rankdir.LR) {
                    tmp = this.offset.getY();
                    this.offset.setY(this.offset.getX());
                    this.offset.setX(rootBox.getHeight() - tmp - this.height);
                }
                if (rankdir == Rankdir.RL) {
                    tmp = this.offset.getX();
                    this.offset.setX(rootBox.getHeight() - this.offset.getY() - this.height);
                    this.offset.setY(rootBox.getWidth() - tmp - this.width);
                }
            }
            tmp = this.height;
            this.height = this.width;
            this.width = tmp;
        }
        if (CollectionUtils.isEmpty(this.children)) {
            return;
        }
        for (Cell child : this.children) {
            child.flip(rankdir, rootBox);
        }
    }

    public static class RootCell
    extends Cell {
        private Map<String, Cell> idRecord;

        public RootCell(boolean isHor) {
            super(isHor);
            this.offset = new FlatPoint(0.0, 0.0);
        }

        void put(String id, Cell cell) {
            if (StringUtils.isEmpty(id) || cell == null) {
                return;
            }
            if (this.idRecord == null) {
                this.idRecord = new HashMap<String, Cell>(2);
            }
            this.idRecord.put(id, cell);
        }

        public Cell getCellById(String id) {
            if (this.idRecord == null) {
                return null;
            }
            return this.idRecord.get(id);
        }
    }
}

