/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.def.FlatPoint;
import org.graphper.layout.Cell;
import org.graphper.layout.LabelFormatException;
import org.graphper.util.CollectionUtils;
import org.graphper.util.FontUtils;

public class CellLabelCompiler {
    public static final int SPLIT = 0;
    public static final int PARENT = 1;
    public static final int TEXT = 2;
    public static final int ID = 3;
    public static final FlatPoint DEFAULT_SIZE = new FlatPoint(10.0, 10.0);
    private final String label;
    private final String fontName;
    private final double fontSize;
    private final FlatPoint margin;
    private final FlatPoint minCellSize;
    private boolean tableAlign;
    private final boolean defaultHor;
    private Cell.RootCell cell;

    private CellLabelCompiler(String label, String fontName, double fontSize, FlatPoint margin, FlatPoint minCellSize, boolean defaultHor) {
        if (label == null) {
            throw this.newFormatError();
        }
        this.label = label;
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.margin = margin;
        this.minCellSize = minCellSize;
        this.defaultHor = defaultHor;
        this.init();
    }

    public static Cell.RootCell compile(String label) throws LabelFormatException {
        return CellLabelCompiler.compile(label, false);
    }

    public static Cell.RootCell compile(String label, boolean defaultVer) throws LabelFormatException {
        return CellLabelCompiler.compile(label, null, 14.0, null, null, defaultVer);
    }

    public static Cell.RootCell compile(String label, String fontName, double fontSize, FlatPoint margin, FlatPoint minCellSize, boolean defaultVer) throws LabelFormatException {
        return new CellLabelCompiler((String)label, (String)fontName, (double)fontSize, (FlatPoint)margin, (FlatPoint)minCellSize, (boolean)defaultVer).cell;
    }

    private Cell.RootCell init() throws LabelFormatException {
        if (this.cell != null) {
            return this.cell;
        }
        List<LabelToken> tokens = this.tokenizer(this.label);
        LabelAstNode ast = this.generateAstNodes(tokens);
        this.initCell(ast);
        return this.cell;
    }

    private List<LabelToken> tokenizer(String label) {
        if (StringUtils.isEmpty(label)) {
            return Collections.singletonList(new LabelToken(2, label));
        }
        boolean preIsEscapeChar = false;
        StringBuilder labelAppend = null;
        ArrayList<LabelToken> tokens = null;
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (!preIsEscapeChar && c == '\\') {
                preIsEscapeChar = true;
                continue;
            }
            if (tokens == null) {
                labelAppend = new StringBuilder();
                tokens = new ArrayList<LabelToken>(2);
            }
            if (preIsEscapeChar) {
                preIsEscapeChar = false;
                this.append(labelAppend, c);
                continue;
            }
            if (c == '#' && this.tableAlignIsFirst(tokens, labelAppend)) {
                this.tableAlign = true;
                continue;
            }
            if (c == '|') {
                this.addLabelToken(labelAppend, tokens);
                if (this.needFillNoneLabel(tokens)) {
                    tokens.add(new LabelToken(2, null));
                }
                tokens.add(new LabelToken(0, Character.valueOf('|')));
                continue;
            }
            if (c == '{') {
                this.addLabelToken(labelAppend, tokens);
                if (this.lastIsRight(tokens)) {
                    throw this.newFormatError();
                }
                tokens.add(new LabelToken(1, Character.valueOf('{')));
                continue;
            }
            if (c == '}') {
                this.addLabelToken(labelAppend, tokens);
                if (this.lastIsSplitOrIdRight(tokens)) {
                    tokens.add(new LabelToken(2, null));
                }
                tokens.add(new LabelToken(1, Character.valueOf('}')));
                continue;
            }
            if (c == '<') {
                this.addLabelToken(labelAppend, tokens);
                tokens.add(new LabelToken(3, Character.valueOf('<')));
                continue;
            }
            if (c == '>') {
                this.addLabelToken(labelAppend, tokens);
                tokens.add(new LabelToken(3, Character.valueOf('>')));
                continue;
            }
            this.append(labelAppend, c);
        }
        if (preIsEscapeChar) {
            throw this.newFormatError();
        }
        this.addLabelToken(labelAppend, tokens);
        if (CollectionUtils.isEmpty(tokens)) {
            return Collections.singletonList(new LabelToken(2, null));
        }
        this.handleEndpoint(tokens);
        return tokens;
    }

    private void handleEndpoint(List<LabelToken> tokens) {
        LabelToken first = tokens.get(0);
        LabelToken last = tokens.get(tokens.size() - 1);
        if (first.isSplit()) {
            tokens.add(0, new LabelToken(2, null));
        }
        if (last.isSplit() || last.isIdRight()) {
            tokens.add(new LabelToken(2, null));
        }
    }

    private boolean addLabelToken(StringBuilder labelAppend, List<LabelToken> tokens) {
        if (tokens == null || labelAppend == null || labelAppend.length() == 0) {
            return false;
        }
        tokens.add(new LabelToken(2, labelAppend.toString()));
        labelAppend.delete(0, labelAppend.length());
        return true;
    }

    private LabelAstNode generateAstNodes(List<LabelToken> tokens) {
        if (CollectionUtils.isEmpty(tokens)) {
            throw this.newFormatError();
        }
        LabelAstNode ast = new LabelAstNode();
        ast.type = 1;
        ast.params = new ArrayList();
        Iterator<LabelToken> iterator = tokens.iterator();
        while (iterator.hasNext()) {
            LabelAstNode node = this.access(iterator, iterator.next());
            if (node == null) continue;
            ast.params.add(node);
        }
        return ast;
    }

    private LabelAstNode access(Iterator<LabelToken> tokenIterator, LabelToken token) {
        if (token.isLabel() || token.isSplit()) {
            LabelAstNode node = new LabelAstNode();
            node.type = token.type;
            node.params = new ArrayList(1);
            node.params.add(token.value);
            return node;
        }
        if (token.isLeftBrace()) {
            LabelAstNode node = new LabelAstNode();
            node.type = token.type;
            node.params = new ArrayList();
            while (tokenIterator.hasNext()) {
                token = tokenIterator.next();
                if (token.isRightBrace()) {
                    return node;
                }
                LabelAstNode n = this.access(tokenIterator, token);
                if (n == null) continue;
                node.params.add(n);
            }
            throw this.newFormatError();
        }
        if (token.isIdLeft()) {
            LabelAstNode node = new LabelAstNode();
            node.type = token.type;
            node.params = new ArrayList();
            while (tokenIterator.hasNext()) {
                token = tokenIterator.next();
                if (token.isIdRight()) {
                    return node;
                }
                if (!token.isLabel()) {
                    throw this.newFormatError();
                }
                LabelAstNode n = this.access(tokenIterator, token);
                if (n == null) continue;
                node.params.add(n);
            }
            throw this.newFormatError();
        }
        if (token.isIdRight()) {
            throw this.newFormatError();
        }
        return null;
    }

    private void initCell(LabelAstNode ast) {
        this.expressAccess(ast, 0, null);
        LabelAstNode pre = null;
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        this.cell = new Cell.RootCell(this.defaultHor);
        TableAlign tableSizeAlign = null;
        if (this.tableAlign) {
            tableSizeAlign = new TableAlign();
        }
        for (Object node : ast.params) {
            if (!(node instanceof LabelAstNode)) {
                throw this.newFormatError();
            }
            Cell c = this.accessNode(this.cell, pre, (LabelAstNode)node, tableSizeAlign);
            pre = (LabelAstNode)node;
            if (c == null) continue;
            maxWidth = Math.max(CellLabelCompiler.getCellWidth(tableSizeAlign, c), maxWidth);
            maxHeight = Math.max(CellLabelCompiler.getCellHeight(tableSizeAlign, c), maxHeight);
        }
        this.postSizeHandle(tableSizeAlign, this.cell, maxWidth, maxHeight);
        this.alignMinSize(tableSizeAlign);
    }

    private void alignMinSize(TableAlign tableSizeAlign) {
        double widthIncr = 0.0;
        double heightIncr = 0.0;
        if (this.minCellSize != null) {
            widthIncr = this.minCellSize.getWidth() - this.cell.getWidth();
            heightIncr = this.minCellSize.getHeight() - this.cell.getHeight();
        }
        this.alignMinSize(tableSizeAlign, this.cell, widthIncr, heightIncr, this.cell.offset);
    }

    private void alignMinSize(TableAlign tableSizeAlign, Cell cell, double widthIncr, double heightIncr, FlatPoint offset) {
        FlatPoint sizeAdded;
        if (tableSizeAlign != null && (sizeAdded = tableSizeAlign.getSizeAdded(cell)) != null) {
            cell.width += sizeAdded.getWidth();
            cell.height += sizeAdded.getHeight();
        }
        if (widthIncr > 0.0) {
            cell.width += widthIncr;
        }
        if (heightIncr > 0.0) {
            cell.height += heightIncr;
        }
        if (cell.isLeaf()) {
            return;
        }
        double childAlignSize = 0.0;
        for (Cell child : cell.getChildren()) {
            if (cell.isHor()) {
                childAlignSize += CellLabelCompiler.getCellHeight(tableSizeAlign, child);
                continue;
            }
            childAlignSize += CellLabelCompiler.getCellWidth(tableSizeAlign, child);
        }
        if (cell.isHor()) {
            childAlignSize = cell.getHeight() - childAlignSize;
            heightIncr = childAlignSize / (double)cell.childrenSize();
        } else {
            childAlignSize = cell.getWidth() - childAlignSize;
            widthIncr = childAlignSize / (double)cell.childrenSize();
        }
        double axisOffset = 0.0;
        for (Cell child : cell.getChildren()) {
            FlatPoint childOffset = cell.isHor() ? new FlatPoint(offset.getX(), offset.getY() + axisOffset) : new FlatPoint(offset.getX() + axisOffset, offset.getY());
            child.offset = childOffset;
            this.alignMinSize(tableSizeAlign, child, widthIncr, heightIncr, childOffset);
            if (child.isHor) {
                axisOffset += child.getWidth();
                continue;
            }
            axisOffset += child.getHeight();
        }
    }

    private Cell accessNode(Cell current, LabelAstNode pre, LabelAstNode node, TableAlign tableSizeAlign) {
        if (CollectionUtils.isEmpty(node.params)) {
            throw this.newFormatError();
        }
        if (node.isSplit() || node.isId()) {
            return null;
        }
        Cell c = new Cell(!current.isHor);
        if (pre != null && pre.isId() && node.isText()) {
            c.id = pre.getIdValue();
            if (StringUtils.isNotEmpty(c.id)) {
                this.cell.put(c.id, c);
            }
        }
        pre = null;
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        for (Object param : node.params) {
            if (param instanceof LabelAstNode) {
                this.accessNode(c, pre, (LabelAstNode)param, tableSizeAlign);
                pre = (LabelAstNode)param;
            } else {
                c.label = param != null ? Objects.toString(param) : null;
                this.setCellSize(c);
            }
            maxWidth = Math.max(CellLabelCompiler.getCellWidth(tableSizeAlign, c), maxWidth);
            maxHeight = Math.max(CellLabelCompiler.getCellHeight(tableSizeAlign, c), maxHeight);
        }
        this.postSizeHandle(tableSizeAlign, c, maxWidth, maxHeight);
        this.addChild(current, c, tableSizeAlign);
        return c;
    }

    private void postSizeHandle(TableAlign tableSizeAlign, Cell cell, double maxWidth, double maxHeight) {
        if (tableSizeAlign != null) {
            tableSizeAlign.clearChildCellRecord();
        }
        for (Cell child : cell.getChildren()) {
            if (tableSizeAlign != null) {
                for (int i = 0; i < child.childrenSize(); ++i) {
                    Cell cc = child.getChild(i);
                    double sideLen = cc.isHor ? CellLabelCompiler.getCellWidth(tableSizeAlign, cc) : CellLabelCompiler.getCellHeight(tableSizeAlign, cc);
                    tableSizeAlign.refreshChildCellMax(child.childrenSize(), i, sideLen);
                }
            }
            if (cell.isHor) {
                child.width = maxWidth;
                continue;
            }
            child.height = maxHeight;
        }
        if (tableSizeAlign == null) {
            return;
        }
        double width = 0.0;
        double height = 0.0;
        for (Cell child : cell.getChildren()) {
            double childWidth = 0.0;
            double childHeight = 0.0;
            for (int i = 0; i < child.childrenSize(); ++i) {
                Cell cc = child.getChild(i);
                double max = tableSizeAlign.getChildCellMax(child.childrenSize(), i);
                if (cc.isHor()) {
                    tableSizeAlign.addWidth(cc, max - cc.width);
                    childWidth += CellLabelCompiler.getCellWidth(tableSizeAlign, cc);
                    continue;
                }
                tableSizeAlign.addHeight(cc, max - cc.height);
                childHeight += CellLabelCompiler.getCellHeight(tableSizeAlign, cc);
            }
            child.height = Math.max(child.height, childHeight);
            child.width = Math.max(child.width, childWidth);
            if (child.isHor()) {
                width += CellLabelCompiler.getCellWidth(tableSizeAlign, child);
                height = Math.max(height, child.height);
                continue;
            }
            height += CellLabelCompiler.getCellHeight(tableSizeAlign, child);
            width = Math.max(width, child.width);
        }
        cell.height = Math.max(cell.height, height);
        cell.width = Math.max(cell.width, width);
    }

    private void setCellSize(Cell c) {
        FlatPoint size = StringUtils.isEmpty(c.label) ? DEFAULT_SIZE.clone() : FontUtils.measure(c.getLabel(), this.fontName, this.fontSize, 0.0);
        c.width = size.getWidth();
        c.height = size.getHeight();
        if (this.margin == null) {
            return;
        }
        c.width += this.margin.getWidth();
        c.height += this.margin.getHeight();
    }

    private void expressAccess(LabelAstNode node, int idx, List<Object> params) {
        if (!node.isExpress()) {
            return;
        }
        if (!this.preIsNullOrSplit(params, idx) || !this.nextIsNullOrSplit(params, idx)) {
            throw this.newFormatError();
        }
        if (CollectionUtils.isEmpty(node.params)) {
            this.addNullLabelAstNode(node);
            return;
        }
        int i = -1;
        Iterator iterator = node.params.iterator();
        while (iterator.hasNext()) {
            ++i;
            Object param = iterator.next();
            if (!(param instanceof LabelAstNode)) {
                throw this.newFormatError();
            }
            LabelAstNode n = (LabelAstNode)param;
            this.idAccess(n, i, node.params);
            this.labelAccess(n, i, node.params);
            this.expressAccess(n, i, node.params);
        }
    }

    private void labelAccess(LabelAstNode node, int idx, List<Object> params) {
        if (!node.isText()) {
            return;
        }
        if (node.emptyParams() || !this.nextIsNullOrSplit(params, idx) || !this.preIsNullOrSplit(params, idx) && !this.preIsIdExpress(params, idx)) {
            throw this.newFormatError();
        }
    }

    private void idAccess(LabelAstNode node, int idx, List<Object> params) {
        if (!node.isId()) {
            return;
        }
        if (this.preIsNullOrSplit(params, idx) && this.nextIsLabel(params, idx)) {
            return;
        }
        throw this.newFormatError();
    }

    private void addNullLabelAstNode(LabelAstNode node) {
        if (CollectionUtils.isNotEmpty(node.params)) {
            return;
        }
        node.params = new ArrayList(1);
        node.params.add(this.newNullLabelAstNode());
    }

    private LabelAstNode newNullLabelAstNode() {
        LabelAstNode node = new LabelAstNode();
        node.type = 2;
        node.params = new ArrayList(1);
        node.params.add(null);
        return node;
    }

    private boolean tableAlignIsFirst(List<LabelToken> tokens, StringBuilder sb) {
        if (CollectionUtils.isNotEmpty(tokens)) {
            return false;
        }
        return sb.length() == 0;
    }

    private void addChild(Cell parent, Cell child, TableAlign tableAlign) {
        if (child == null) {
            return;
        }
        if (parent.children == null) {
            parent.children = new ArrayList<Cell>(2);
        }
        child.parent = parent;
        parent.children.add(child);
        double w = CellLabelCompiler.getCellWidth(tableAlign, child);
        double h = CellLabelCompiler.getCellHeight(tableAlign, child);
        if (child.isHor) {
            parent.width += w;
            parent.height = Math.max(h, parent.height);
        } else {
            parent.height += h;
            parent.width = Math.max(w, parent.width);
        }
    }

    private boolean nextIsLabel(List<Object> params, int idx) {
        Object next = this.nextParam(params, idx);
        if (!(next instanceof LabelAstNode)) {
            return false;
        }
        return ((LabelAstNode)next).isText();
    }

    private boolean preIsIdExpress(List<Object> params, int idx) {
        Object pre = this.preParam(params, idx);
        if (!(pre instanceof LabelAstNode)) {
            return false;
        }
        return ((LabelAstNode)pre).isId();
    }

    private boolean preIsSplit(List<Object> params, int idx) {
        Object pre = this.preParam(params, idx);
        if (!(pre instanceof LabelAstNode)) {
            return false;
        }
        return ((LabelAstNode)pre).isSplit();
    }

    private boolean nextIsSplit(List<Object> params, int idx) {
        Object next = this.nextParam(params, idx);
        if (!(next instanceof LabelAstNode)) {
            return false;
        }
        return ((LabelAstNode)next).isSplit();
    }

    private boolean preIsNullOrSplit(List<Object> params, int idx) {
        return this.preIsNull(params, idx) || this.preIsSplit(params, idx);
    }

    private boolean nextIsNullOrSplit(List<Object> params, int idx) {
        return this.nextIsNull(params, idx) || this.nextIsSplit(params, idx);
    }

    private boolean preIsNull(List<Object> params, int idx) {
        return this.preParam(params, idx) == null;
    }

    private boolean nextIsNull(List<Object> params, int idx) {
        return this.nextParam(params, idx) == null;
    }

    private Object preParam(List<Object> params, int idx) {
        if (CollectionUtils.isEmpty(params) || idx <= 0 || idx >= params.size()) {
            return null;
        }
        return params.get(idx - 1);
    }

    private Object nextParam(List<Object> params, int idx) {
        if (CollectionUtils.isEmpty(params) || idx >= params.size() - 1) {
            return null;
        }
        return params.get(idx + 1);
    }

    private LabelFormatException newFormatError() {
        return new LabelFormatException("Bad label format " + this.label);
    }

    private boolean needFillNoneLabel(List<LabelToken> tokens) {
        return this.lastIsLeft(tokens) || this.lastIsSplit(tokens) || this.lastIsIdRight(tokens);
    }

    public boolean lastIsSplitOrIdRight(List<LabelToken> tokens) {
        return this.lastIsSplit(tokens) || this.lastIsIdRight(tokens);
    }

    private boolean lastIsSplit(List<LabelToken> tokens) {
        if (CollectionUtils.isEmpty(tokens)) {
            return false;
        }
        LabelToken last = tokens.get(tokens.size() - 1);
        return last.isSplit();
    }

    private boolean lastIsIdRight(List<LabelToken> tokens) {
        if (CollectionUtils.isEmpty(tokens)) {
            return false;
        }
        LabelToken last = tokens.get(tokens.size() - 1);
        return last.isIdRight();
    }

    private boolean lastIsLeft(List<LabelToken> tokens) {
        if (CollectionUtils.isEmpty(tokens)) {
            return false;
        }
        LabelToken last = tokens.get(tokens.size() - 1);
        return last.isLeftBrace();
    }

    private boolean lastIsRight(List<LabelToken> tokens) {
        if (CollectionUtils.isEmpty(tokens)) {
            return false;
        }
        LabelToken last = tokens.get(tokens.size() - 1);
        return last.isRightBrace();
    }

    private void append(StringBuilder sb, char c) {
        if (c != ' ' || sb.length() > 0 && !this.lastIsSpace(sb)) {
            sb.append(c);
        }
    }

    private int lastIdx(StringBuilder sb) {
        if (sb.length() == 0) {
            throw new IllegalArgumentException();
        }
        return sb.length() - 1;
    }

    private boolean lastIsSpace(StringBuilder sb) {
        if (sb.length() == 0) {
            return false;
        }
        return sb.charAt(this.lastIdx(sb)) == ' ';
    }

    private static double getCellWidth(TableAlign tableSizeAlign, Cell cell) {
        if (tableSizeAlign == null) {
            return cell.getWidth();
        }
        return cell.getWidth() + tableSizeAlign.widthAdded(cell);
    }

    private static double getCellHeight(TableAlign tableSizeAlign, Cell cell) {
        if (tableSizeAlign == null) {
            return cell.getHeight();
        }
        return cell.getHeight() + tableSizeAlign.heightAdded(cell);
    }

    private static class TableAlign {
        private Map<Cell, FlatPoint> sizeAddedRecord;
        private Map<Integer, List<Double>> childCellMaxRecord;

        private TableAlign() {
        }

        private double widthAdded(Cell cell) {
            FlatPoint sizeAdded = this.getSizeAdded(cell);
            return sizeAdded != null ? sizeAdded.getWidth() : 0.0;
        }

        private double heightAdded(Cell cell) {
            FlatPoint sizeAdded = this.getSizeAdded(cell);
            return sizeAdded != null ? sizeAdded.getHeight() : 0.0;
        }

        private FlatPoint getSizeAdded(Cell cell) {
            if (this.sizeAddedRecord == null) {
                return null;
            }
            return this.sizeAddedRecord.get(cell);
        }

        private void addHeight(Cell cell, double heightAdded) {
            FlatPoint added;
            if (this.sizeAddedRecord == null) {
                this.sizeAddedRecord = new HashMap<Cell, FlatPoint>(2);
            }
            if ((added = this.sizeAddedRecord.get(cell)) == null) {
                this.sizeAddedRecord.put(cell, new FlatPoint(heightAdded, 0.0));
                return;
            }
            added.setHeight(added.getHeight() + heightAdded);
        }

        private void addWidth(Cell cell, double widthAdded) {
            FlatPoint added;
            if (this.sizeAddedRecord == null) {
                this.sizeAddedRecord = new HashMap<Cell, FlatPoint>(2);
            }
            if ((added = this.sizeAddedRecord.get(cell)) == null) {
                this.sizeAddedRecord.put(cell, new FlatPoint(0.0, widthAdded));
                return;
            }
            added.setWidth(added.getWidth() + widthAdded);
        }

        private void refreshChildCellMax(int childLenKey, int idx, double val) {
            if (childLenKey <= 0 || idx >= childLenKey) {
                return;
            }
            if (this.childCellMaxRecord == null) {
                this.childCellMaxRecord = new HashMap<Integer, List<Double>>(2);
            }
            this.childCellMaxRecord.compute(childLenKey, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Double>(childLenKey);
                    for (int i = 0; i < childLenKey; ++i) {
                        v.add(0.0);
                    }
                }
                v.set(idx, Math.max((Double)v.get(idx), val));
                return v;
            });
        }

        private double getChildCellMax(int childLenKey, int idx) {
            if (this.childCellMaxRecord == null || childLenKey <= 0 || idx >= childLenKey) {
                return 0.0;
            }
            List<Double> childCell = this.childCellMaxRecord.get(childLenKey);
            if (childCell == null || childCell.size() <= idx) {
                return 0.0;
            }
            Double maxVal = childCell.get(idx);
            return maxVal != null ? maxVal : 0.0;
        }

        private void clearChildCellRecord() {
            if (this.childCellMaxRecord == null) {
                return;
            }
            this.childCellMaxRecord.clear();
        }
    }

    private static class LabelAstNode {
        private int type;
        private List<Object> params;

        private LabelAstNode() {
        }

        boolean isSplit() {
            return this.type == 0;
        }

        boolean isExpress() {
            return this.type == 1;
        }

        boolean isText() {
            return this.type == 2;
        }

        boolean isId() {
            return this.type == 3;
        }

        String getTextValue() {
            if (!this.isText() || this.emptyParams()) {
                return null;
            }
            Object first = this.params.get(0);
            return first instanceof String ? (String)first : null;
        }

        String getIdValue() {
            if (!this.isId() || this.emptyParams()) {
                return null;
            }
            Object first = this.params.get(0);
            if (!(first instanceof LabelAstNode)) {
                return null;
            }
            LabelAstNode idText = (LabelAstNode)first;
            return idText.getTextValue();
        }

        boolean emptyParams() {
            return CollectionUtils.isEmpty(this.params);
        }
    }

    private static class LabelToken {
        final int type;
        private final Object value;

        public LabelToken(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        boolean isSplit() {
            return this.type == 0 && Objects.equals(this.value, Character.valueOf('|'));
        }

        boolean isParent() {
            return this.type == 1;
        }

        boolean isLeftBrace() {
            return this.isParent() && Objects.equals(this.value, Character.valueOf('{'));
        }

        boolean isRightBrace() {
            return this.isParent() && Objects.equals(this.value, Character.valueOf('}'));
        }

        boolean isId() {
            return this.type == 3;
        }

        boolean isIdLeft() {
            return this.isId() && Objects.equals(this.value, Character.valueOf('<'));
        }

        boolean isIdRight() {
            return this.isId() && Objects.equals(this.value, Character.valueOf('>'));
        }

        boolean isLabel() {
            return this.type == 2;
        }
    }
}

