/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import java.util.List;
import java.util.Set;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ArrowDrawProp;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.layout.Shifter;
import org.graphper.layout.ShifterStrategy;
import org.graphper.layout.dot.RouterBox;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public class CombineShifter
implements Shifter {
    private final Set<FlatPoint> pointMark;
    private final List<ShifterStrategy> shifterStrategies;

    public CombineShifter(Set<FlatPoint> pointMark, List<ShifterStrategy> shifterStrategies) {
        Asserts.illegalArgument(CollectionUtils.isEmpty(shifterStrategies), "shifterStrategies is empty");
        this.pointMark = pointMark;
        this.shifterStrategies = shifterStrategies;
    }

    @Override
    public void graph(GraphvizDrawProp graphvizDrawProp) {
        Asserts.nullArgument(graphvizDrawProp, "graphvizDrawProp");
        for (ShifterStrategy shifterStrategy : this.shifterStrategies) {
            shifterStrategy.moveContainerDrawProp(graphvizDrawProp);
        }
    }

    @Override
    public void cluster(ClusterDrawProp clusterDrawProp) {
        Asserts.nullArgument(clusterDrawProp, "clusterDrawProp");
        for (ShifterStrategy shifterStrategy : this.shifterStrategies) {
            shifterStrategy.moveContainerDrawProp(clusterDrawProp);
        }
    }

    @Override
    public void node(NodeDrawProp nodeDrawProp) {
        Asserts.nullArgument(nodeDrawProp, "nodeDrawProp");
        for (ShifterStrategy shifterStrategy : this.shifterStrategies) {
            shifterStrategy.moveContainerDrawProp(nodeDrawProp);
        }
    }

    @Override
    public void line(LineDrawProp lineDrawProp) {
        Asserts.nullArgument(lineDrawProp, "lineDrawProp");
        for (FlatPoint point : lineDrawProp) {
            if (this.isMark(point)) continue;
            for (ShifterStrategy shifterStrategy : this.shifterStrategies) {
                shifterStrategy.movePoint(point);
            }
            this.markFlatPoint(point);
        }
        ArrowDrawProp arrowTail = lineDrawProp.getArrowTail();
        ArrowDrawProp arrowHead = lineDrawProp.getArrowHead();
        if (arrowTail != null) {
            this.markArrowDrawProp(arrowTail);
        }
        if (arrowHead != null) {
            this.markArrowDrawProp(arrowHead);
        }
        for (ShifterStrategy shifterStrategy : this.shifterStrategies) {
            shifterStrategy.movePoint(lineDrawProp.getLabelCenter());
        }
        List<RouterBox> routerBoxes = lineDrawProp.getBoxes();
        if (CollectionUtils.isNotEmpty(routerBoxes)) {
            for (RouterBox routerBox : routerBoxes) {
                for (ShifterStrategy shifterStrategy : this.shifterStrategies) {
                    shifterStrategy.moveBox(routerBox);
                }
            }
        }
        for (FlatPoint floatLabelCenter : lineDrawProp.getFloatLabelFlatCenters().values()) {
            for (ShifterStrategy shifterStrategy : this.shifterStrategies) {
                shifterStrategy.movePoint(floatLabelCenter);
            }
        }
    }

    private void markArrowDrawProp(ArrowDrawProp arrowTail) {
        for (ShifterStrategy shifterStrategy : this.shifterStrategies) {
            if (this.isMark(arrowTail.getAxisBegin())) continue;
            shifterStrategy.movePoint(arrowTail.getAxisBegin());
        }
        this.markFlatPoint(arrowTail.getAxisBegin());
        for (ShifterStrategy shifterStrategy : this.shifterStrategies) {
            if (this.isMark(arrowTail.getAxisEnd())) continue;
            shifterStrategy.movePoint(arrowTail.getAxisEnd());
        }
        this.markFlatPoint(arrowTail.getAxisEnd());
    }

    private void markFlatPoint(FlatPoint point) {
        if (point == null || this.pointMark == null) {
            return;
        }
        this.pointMark.add(point);
    }

    private boolean isMark(FlatPoint point) {
        if (this.pointMark == null) {
            return false;
        }
        return this.pointMark.contains(point);
    }
}

