/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import org.graphper.def.FlatPoint;
import org.graphper.draw.ContainerDrawProp;
import org.graphper.layout.AbstractShifterStrategy;
import org.graphper.layout.dot.RouterBox;

public class FlatShifterStrategy
extends AbstractShifterStrategy {
    private final double xOffset;
    private final double yOffset;

    public FlatShifterStrategy(double xOffset, double yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    @Override
    public void movePoint(FlatPoint point) {
        if (point == null) {
            return;
        }
        point.setX(point.getX() + this.xOffset);
        point.setY(point.getY() + this.yOffset);
    }

    @Override
    public void moveContainerDrawProp(ContainerDrawProp containerDrawProp) {
        if (containerDrawProp == null) {
            return;
        }
        this.moveGrid(containerDrawProp);
        this.movePoint(containerDrawProp.getLabelCenter());
        containerDrawProp.setLeftBorder(containerDrawProp.getLeftBorder() + this.xOffset);
        containerDrawProp.setRightBorder(containerDrawProp.getRightBorder() + this.xOffset);
        containerDrawProp.setUpBorder(containerDrawProp.getUpBorder() + this.yOffset);
        containerDrawProp.setDownBorder(containerDrawProp.getDownBorder() + this.yOffset);
    }

    @Override
    public void moveBox(RouterBox routerBox) {
        if (routerBox == null) {
            return;
        }
        double leftWall = routerBox.getLeftBorder();
        double rightWall = routerBox.getRightBorder();
        double upWall = routerBox.getUpBorder();
        double downWall = routerBox.getDownBorder();
        routerBox.setRightBorder(Double.MAX_VALUE);
        routerBox.setLeftBorder(leftWall + this.xOffset);
        routerBox.setRightBorder(rightWall + this.xOffset);
        routerBox.setDownBorder(Double.MAX_VALUE);
        routerBox.setUpBorder(upWall + this.yOffset);
        routerBox.setDownBorder(downWall + this.yOffset);
    }
}

