/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import org.graphper.api.attributes.Port;
import org.graphper.api.attributes.Rankdir;
import org.graphper.api.ext.Box;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ContainerDrawProp;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.Rectangle;
import org.graphper.layout.AbstractShifterStrategy;
import org.graphper.layout.Cell;
import org.graphper.layout.dot.RouterBox;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public class FlipShifterStrategy
extends AbstractShifterStrategy {
    private final DrawGraph drawGraph;

    public FlipShifterStrategy(DrawGraph drawGraph) {
        Asserts.nullArgument(drawGraph, "drawGraph");
        this.drawGraph = drawGraph;
        this.flipDrawGraphRange();
    }

    @Override
    public void movePoint(FlatPoint point) {
        FlipShifterStrategy.movePoint(this.drawGraph, point);
    }

    @Override
    public void moveContainerDrawProp(ContainerDrawProp containerDrawProp) {
        Rankdir rankdir;
        if (containerDrawProp == null || this.notNeedMove()) {
            return;
        }
        if (containerDrawProp.isNodeProp()) {
            NodeDrawProp node = (NodeDrawProp)containerDrawProp;
            if (node.isCellProp()) {
                return;
            }
            this.moveCell(node);
        }
        if (!(containerDrawProp.getLabelSize() == null || containerDrawProp.isNodeProp() || (rankdir = this.drawGraph.rankdir()) != Rankdir.LR && rankdir != Rankdir.RL)) {
            containerDrawProp.getLabelSize().flip();
        }
        this.movePoint(containerDrawProp.getLabelCenter());
        FlipShifterStrategy.moveRectangle(this.drawGraph, (Rectangle)containerDrawProp);
        this.moveGrid(containerDrawProp);
    }

    @Override
    public void moveBox(RouterBox routerBox) {
        if (routerBox == null || this.notNeedMove()) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        rectangle.setLeftBorder(routerBox.getLeftBorder());
        rectangle.setRightBorder(routerBox.getRightBorder());
        rectangle.setUpBorder(routerBox.getUpBorder());
        rectangle.setDownBorder(routerBox.getDownBorder());
        FlipShifterStrategy.moveRectangle(this.drawGraph, rectangle);
        routerBox.setRightBorder(Double.MAX_VALUE);
        routerBox.setLeftBorder(rectangle.getLeftBorder());
        routerBox.setRightBorder(rectangle.getRightBorder());
        routerBox.setDownBorder(Double.MAX_VALUE);
        routerBox.setUpBorder(rectangle.getUpBorder());
        routerBox.setDownBorder(rectangle.getDownBorder());
    }

    public static Port movePort(DrawGraph drawGraph, Port port) {
        if (port == null) {
            return null;
        }
        Rankdir rankdir = drawGraph.rankdir();
        return FlipShifterStrategy.movePort(port, rankdir);
    }

    public static Port backPort(Port port, Rankdir rankdir) {
        if (port == null || rankdir == null) {
            return port;
        }
        for (Port p : Port.values()) {
            if (FlipShifterStrategy.movePort(p, rankdir) != port) continue;
            return p;
        }
        return port;
    }

    public static Port movePort(Port port, Rankdir rankdir) {
        if (port == null || rankdir == null) {
            return port;
        }
        switch (rankdir) {
            case LR: {
                switch (port) {
                    case WEST: {
                        return Port.NORTH;
                    }
                    case NORTH_WEST: {
                        return Port.NORTH_EAST;
                    }
                    case NORTH: {
                        return Port.EAST;
                    }
                    case NORTH_EAST: {
                        return Port.SOUTH_EAST;
                    }
                    case EAST: {
                        return Port.SOUTH;
                    }
                    case SOUTH_EAST: {
                        return Port.SOUTH_WEST;
                    }
                    case SOUTH: {
                        return Port.WEST;
                    }
                    case SOUTH_WEST: {
                        return Port.NORTH_WEST;
                    }
                }
                break;
            }
            case RL: {
                switch (port) {
                    case WEST: {
                        return Port.SOUTH;
                    }
                    case NORTH_WEST: {
                        return Port.SOUTH_EAST;
                    }
                    case NORTH: {
                        return Port.EAST;
                    }
                    case NORTH_EAST: {
                        return Port.NORTH_EAST;
                    }
                    case EAST: {
                        return Port.NORTH;
                    }
                    case SOUTH_EAST: {
                        return Port.NORTH_WEST;
                    }
                    case SOUTH: {
                        return Port.WEST;
                    }
                    case SOUTH_WEST: {
                        return Port.SOUTH_WEST;
                    }
                }
                break;
            }
            case BT: {
                switch (port) {
                    case NORTH_WEST: {
                        return Port.SOUTH_WEST;
                    }
                    case NORTH: {
                        return Port.SOUTH;
                    }
                    case NORTH_EAST: {
                        return Port.SOUTH_EAST;
                    }
                    case SOUTH_EAST: {
                        return Port.NORTH_EAST;
                    }
                    case SOUTH: {
                        return Port.NORTH;
                    }
                    case SOUTH_WEST: {
                        return Port.NORTH_WEST;
                    }
                }
                return port;
            }
        }
        return port;
    }

    public static void movePoint(DrawGraph drawGraph, FlatPoint point) {
        if (point == null || drawGraph == null || FlipShifterStrategy.notNeedMove(drawGraph.rankdir())) {
            return;
        }
        Rankdir rankdir = drawGraph.rankdir();
        switch (rankdir) {
            case LR: {
                point.flip();
                FlipShifterStrategy.flipVertical(point, drawGraph.getMaxY());
                break;
            }
            case RL: {
                double t = point.getX();
                point.setX(2.0 * drawGraph.getMaxX() - point.getY());
                point.setY(t);
                FlipShifterStrategy.flipVertical(point, drawGraph.getMaxY());
                break;
            }
            case BT: {
                point.setY(2.0 * drawGraph.getMaxY() - point.getY());
                break;
            }
        }
    }

    public static void movePointOpposite(Rankdir rankdir, Box box, FlatPoint point) {
        if (point == null || box == null || FlipShifterStrategy.notNeedMove(rankdir)) {
            return;
        }
        switch (rankdir) {
            case LR: {
                FlipShifterStrategy.flipVertical(point, box.getDownBorder());
                point.flip();
                break;
            }
            case RL: {
                FlipShifterStrategy.flipVertical(point, box.getDownBorder());
                double t = point.getY();
                point.setY(2.0 * box.getRightBorder() - point.getX());
                point.setX(t);
                break;
            }
            case BT: {
                point.setY(2.0 * box.getDownBorder() - point.getY());
                break;
            }
        }
    }

    public static void moveRectangle(DrawGraph drawGraph, Rectangle rectangle) {
        Asserts.nullArgument(drawGraph, "drawGraph");
        FlipShifterStrategy.moveRectangle(drawGraph.rankdir(), drawGraph.getMaxX(), drawGraph.getMaxY(), rectangle);
    }

    public static void moveRectangle(Rankdir rankdir, Rectangle rectangle) {
        FlipShifterStrategy.moveRectangle(rankdir, null, null, rectangle);
    }

    public static void moveRectangle(Rankdir rankdir, Double maxX, Double maxY, Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        double leftBorder = rectangle.getLeftBorder();
        double rightBorder = rectangle.getRightBorder();
        double upBorder = rectangle.getUpBorder();
        double downBorder = rectangle.getDownBorder();
        maxX = maxX != null ? maxX.doubleValue() : rectangle.getRightBorder();
        maxY = maxY != null ? maxY.doubleValue() : rectangle.getDownBorder();
        switch (rankdir) {
            case LR: {
                rectangle.setLeftBorder(upBorder);
                rectangle.setRightBorder(downBorder);
                rectangle.setUpBorder(leftBorder);
                rectangle.setDownBorder(rightBorder);
                FlipShifterStrategy.flipVertical(rectangle, (double)maxY);
                break;
            }
            case RL: {
                rectangle.setLeftBorder(2.0 * maxX - downBorder);
                rectangle.setRightBorder(2.0 * maxX - upBorder);
                rectangle.setUpBorder(leftBorder);
                rectangle.setDownBorder(rightBorder);
                FlipShifterStrategy.flipVertical(rectangle, (double)maxY);
                break;
            }
            case BT: {
                FlipShifterStrategy.flipVertical(rectangle, (double)maxY);
                break;
            }
        }
    }

    private void moveCell(NodeDrawProp node) {
        Cell.RootCell cell = node.getCell();
        if (cell == null || this.drawGraph.rankdir() == Rankdir.TB) {
            return;
        }
        this.moveCell(node, cell, this.drawGraph.rankdir());
    }

    private void moveCell(NodeDrawProp rootBox, Cell cell, Rankdir rankdir) {
        FlatPoint offset = cell.getOffset();
        if (rankdir == Rankdir.BT) {
            if (offset != null) {
                offset.setY(rootBox.getHeight() - cell.getHeight() - offset.getY());
            }
        } else {
            double tmp;
            if (offset != null) {
                if (rankdir == Rankdir.LR) {
                    tmp = offset.getX();
                    offset.setX(offset.getY());
                    offset.setY(rootBox.getWidth() - tmp - cell.getWidth());
                }
                if (rankdir == Rankdir.RL) {
                    tmp = offset.getX();
                    offset.setX(rootBox.getHeight() - offset.getY() - cell.getHeight());
                    offset.setY(rootBox.getWidth() - tmp - cell.getWidth());
                }
            }
            tmp = cell.getHeight();
            cell.setHeight(cell.getWidth());
            cell.setWidth(tmp);
        }
        if (CollectionUtils.isEmpty(cell.getChildren())) {
            return;
        }
        for (Cell child : cell.getChildren()) {
            this.moveCell(rootBox, child, rankdir);
        }
    }

    private void flipDrawGraphRange() {
        if (this.notNeedMove()) {
            return;
        }
        Rankdir rankdir = this.drawGraph.rankdir();
        if (rankdir == Rankdir.BT) {
            this.flipVerticalDrawGraph(this.drawGraph);
            return;
        }
        double minX = this.drawGraph.getMinX();
        double maxX = this.drawGraph.getMaxX();
        double minY = this.drawGraph.getMinY();
        double maxY = this.drawGraph.getMaxY();
        this.drawGraph.init();
        switch (rankdir) {
            case LR: {
                this.drawGraph.updateXAxisRange(minY);
                this.drawGraph.updateXAxisRange(maxY);
                this.drawGraph.updateYAxisRange(minX);
                this.drawGraph.updateYAxisRange(maxX);
                this.flipVerticalDrawGraph(this.drawGraph);
                break;
            }
            case RL: {
                this.drawGraph.updateXAxisRange(minY);
                this.drawGraph.updateXAxisRange(2.0 * minY - maxY);
                this.drawGraph.updateYAxisRange(minX);
                this.drawGraph.updateYAxisRange(maxX);
                this.flipVerticalDrawGraph(this.drawGraph);
                break;
            }
        }
    }

    private static void flipVertical(FlatPoint point, double horAxis) {
        point.setY(2.0 * horAxis - point.getY());
    }

    private static void flipVertical(Rectangle rectangle, double maxY) {
        double leftBorder = rectangle.getLeftBorder();
        double rightBorder = rectangle.getRightBorder();
        double upBorder = rectangle.getUpBorder();
        double downBorder = rectangle.getDownBorder();
        rectangle.setLeftBorder(leftBorder);
        rectangle.setRightBorder(rightBorder);
        rectangle.setUpBorder(2.0 * maxY - downBorder);
        rectangle.setDownBorder(2.0 * maxY - upBorder);
    }

    private void flipVerticalDrawGraph(DrawGraph drawGraph) {
        double minX = drawGraph.getMinX();
        double maxX = drawGraph.getMaxX();
        double minY = drawGraph.getMinY();
        double maxY = drawGraph.getMaxY();
        drawGraph.init();
        drawGraph.updateXAxisRange(minX);
        drawGraph.updateXAxisRange(maxX);
        drawGraph.updateYAxisRange(minY);
        drawGraph.updateYAxisRange(2.0 * minY - maxY);
    }

    private boolean notNeedMove() {
        return this.drawGraph.rankdir() == Rankdir.TB;
    }

    private static boolean notNeedMove(Rankdir rankdir) {
        if (rankdir == null) {
            return true;
        }
        return rankdir == Rankdir.TB;
    }
}

