/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Grid {
    private final TreeMap<Double, GridAxis> horAxes;
    private final TreeMap<Double, GridAxis> verAxes;

    private Grid(TreeMap<Double, GridAxis> horAxes, TreeMap<Double, GridAxis> verAxes) {
        this.horAxes = horAxes;
        this.verAxes = verAxes;
    }

    public static GridBuilder builder() {
        return new GridBuilder();
    }

    public GridAxis getVerAxis(double v) {
        return this.verAxes.get(v);
    }

    public GridAxis getHorAxis(double v) {
        return this.horAxes.get(v);
    }

    public GridAxis getFirstHorAxis() {
        Iterator<Map.Entry<Double, GridAxis>> iterator = this.horAxes.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Double, GridAxis> entry = iterator.next();
            return entry.getValue();
        }
        return null;
    }

    public GridAxis getFirstVerAxis() {
        Iterator<Map.Entry<Double, GridAxis>> iterator = this.verAxes.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Double, GridAxis> entry = iterator.next();
            return entry.getValue();
        }
        return null;
    }

    public int rowNum() {
        return this.horAxes.size();
    }

    public int colNum() {
        return this.verAxes.size();
    }

    public int coordToIdx(int row, int col) {
        return row * this.colNum() + col;
    }

    public int getRowFromIdx(int idx) {
        return idx / this.colNum();
    }

    public int getColFromIdx(int idx) {
        return idx - idx / this.colNum() * this.colNum();
    }

    public static class GridBuilder {
        private final TreeMap<Double, GridAxis> horAxes = new TreeMap();
        private final TreeMap<Double, GridAxis> verAxes = new TreeMap();

        private GridBuilder() {
        }

        public GridBuilder addHorAxis(double horAxis) {
            this.horAxes.computeIfAbsent(horAxis, a -> new GridAxis());
            return this;
        }

        public GridBuilder addVerAxis(double verAxis) {
            this.verAxes.computeIfAbsent(verAxis, a -> new GridAxis());
            return this;
        }

        public Double minHorAxis() {
            return this.horAxes.firstKey();
        }

        public Double maxHorAxis() {
            return this.horAxes.lastKey();
        }

        public Double minVerAxis() {
            return this.verAxes.firstKey();
        }

        public Double maxVerAxis() {
            return this.verAxes.lastKey();
        }

        public Grid build() {
            this.axisInit(this.horAxes);
            this.axisInit(this.verAxes);
            return new Grid(this.horAxes, this.verAxes);
        }

        private void axisInit(TreeMap<Double, GridAxis> axises) {
            int i = 0;
            GridAxis pre = null;
            for (Map.Entry<Double, GridAxis> entry : axises.entrySet()) {
                if (pre != null) {
                    pre.next = entry.getValue();
                }
                entry.getValue().pre = pre;
                entry.getValue().val = entry.getKey();
                pre = entry.getValue();
                pre.idx = i++;
            }
        }
    }

    public static class GridAxis {
        private int idx;
        private double val;
        private GridAxis pre;
        private GridAxis next;
        private Set<Double> blockAxes;

        private GridAxis() {
        }

        public int getIdx() {
            return this.idx;
        }

        public double getVal() {
            return this.val;
        }

        public GridAxis pre() {
            return this.pre;
        }

        public GridAxis next() {
            return this.next;
        }

        public void addBlockAxis(double blockAxis) {
            if (this.blockAxes == null) {
                this.blockAxes = new HashSet<Double>();
            }
            this.blockAxes.add(blockAxis);
        }

        public boolean isNotBlock(double blockAxis) {
            return !this.isBlock(blockAxis);
        }

        public boolean isBlock(double blockAxis) {
            return this.blockAxes != null && this.blockAxes.contains(blockAxis);
        }
    }
}

