/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.graphper.api.Assemble;
import org.graphper.api.Html;
import org.graphper.api.Node;
import org.graphper.def.CycleDependencyException;
import org.graphper.def.FlatPoint;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;
import org.graphper.util.FontUtils;

public class HtmlConvert {
    private HtmlConvert() {
    }

    public static Assemble toAssemble(Html.Table table) {
        if (table == null) {
            return null;
        }
        Asserts.illegalArgument(table.rowNum() == 0, "Empty tr in table");
        RootTableHelper tableHelper = new RootTableHelper(table);
        HtmlConvert.tableLayout(table, tableHelper, tableHelper);
        tableHelper.releaseMark();
        return HtmlConvert.convertToAssemble(table, tableHelper);
    }

    private static void tableLayout(Html.Table table, TableHelper tableHelper, RootTableHelper rootTableHelper) {
        Asserts.illegalArgument(table.rowNum() == 0, "Empty tr in table");
        if (rootTableHelper.isMark(table)) {
            throw new CycleDependencyException("Cycle dependency table");
        }
        rootTableHelper.mark(table);
        HtmlConvert.setTdGridPosition(table, tableHelper, rootTableHelper);
        Map<Integer, TableAxis> groupRecord = HtmlConvert.groupVerAxis(tableHelper);
        HtmlConvert.setTableHeightAndMergeVerAxis(table, tableHelper, groupRecord);
        HtmlConvert.setTableWidth(table, tableHelper);
        HtmlConvert.alignSize(table, tableHelper);
        rootTableHelper.remove(table);
    }

    private static void setTdGridPosition(Html.Table table, TableHelper tableHelper, RootTableHelper rootTableHelper) {
        for (int r = 0; r < table.rowNum(); ++r) {
            Html.Tr tr = table.getTr(r);
            Asserts.illegalArgument(tr.colNum() == 0, "Empty td in tr");
            int preAxis = 0;
            int currentOccupyRangeIdx = 0;
            for (int c = 0; c < tr.colNum(); ++c) {
                OccupyRange occupyRange;
                Html.Td td = tr.getTd(c);
                int rowSpan = td.getRowSpan();
                int colSpan = td.getColSpan();
                TableHelper tableHelper2 = tableHelper;
                tableHelper2.haveGreaterThan2ColSpan = tableHelper2.haveGreaterThan2ColSpan | colSpan > 1;
                while ((occupyRange = tableHelper.getOccupyRange(r, currentOccupyRangeIdx)) != null && !occupyRange.leftRange(preAxis)) {
                    if (occupyRange.inRange(preAxis)) {
                        preAxis = occupyRange.end;
                    }
                    ++currentOccupyRangeIdx;
                }
                rowSpan = Math.min(r + rowSpan - 1, table.rowNum() - 1) - r + 1;
                TableAxis up = tableHelper.getRowAxis(r);
                TableAxis down = tableHelper.getRowAxis(r + rowSpan);
                TableAxis left = tableHelper.getColAxis(preAxis);
                TableAxis right = tableHelper.getColAxis(preAxis += colSpan);
                tableHelper.markHaveTdBetweenColAxis(left, right);
                TdBox tdBox = new TdBox(left, right, up, down);
                HtmlConvert.tdSize(table, tdBox, td, rootTableHelper);
                tableHelper.addPos(td, tdBox);
                if (rowSpan <= 1) continue;
                int maxRow = rowSpan + r - 1;
                for (int i = r + 1; i <= maxRow; ++i) {
                    tableHelper.addOccupyRange(i, tdBox.left.no, tdBox.right.no);
                }
            }
            tableHelper.clearOccupyRanges(r);
        }
    }

    private static Map<Integer, TableAxis> groupVerAxis(TableHelper tableHelper) {
        if (!tableHelper.haveGreaterThan2ColSpan) {
            return null;
        }
        HashMap<Integer, TableAxis> groupRecord = null;
        Map.Entry axis = tableHelper.lastColAxis();
        while (axis != null) {
            Map.Entry pre = tableHelper.lowerAxis((TableAxis)axis.getValue());
            if (pre != null) {
                TableAxis currentAxis = (TableAxis)axis.getValue();
                TableAxis preAxis = (TableAxis)pre.getValue();
                if (tableHelper.notHaveTdBetweenAxes(preAxis, currentAxis)) {
                    if (groupRecord == null) {
                        groupRecord = new HashMap<Integer, TableAxis>();
                        groupRecord.put(preAxis.no, currentAxis);
                        continue;
                    }
                    TableAxis parentAxis = (TableAxis)groupRecord.get(currentAxis.no);
                    if (parentAxis != null) {
                        groupRecord.put(preAxis.no, parentAxis);
                    } else {
                        groupRecord.put(preAxis.no, currentAxis);
                    }
                }
            }
            axis = pre;
        }
        return groupRecord;
    }

    private static void setTableHeightAndMergeVerAxis(Html.Table table, TableHelper tableHelper, Map<Integer, TableAxis> groupRecord) {
        for (int r = 0; r < table.rowNum(); ++r) {
            Html.Tr tr = table.getTr(r);
            for (int c = 0; c < tr.colNum(); ++c) {
                Html.Td td = tr.getTd(c);
                TdBox tdBox = tableHelper.getBox(td);
                if (tdBox == null) continue;
                if (groupRecord != null) {
                    TableAxis leftGroup = groupRecord.get(tdBox.left.no);
                    TableAxis rightGroup = groupRecord.get(tdBox.right.no);
                    if (leftGroup != null) {
                        tdBox.left = leftGroup;
                    }
                    if (rightGroup != null) {
                        tdBox.right = rightGroup;
                    }
                }
                boolean refresh = tdBox.down.refreshPos(tdBox.up.position + tdBox.size.getHeight());
                tableHelper.refreshHeight(tdBox.down.position);
                HtmlConvert.balanceRowChildTds(tableHelper, tdBox, refresh);
            }
        }
        if (groupRecord == null) {
            return;
        }
        for (Map.Entry<Integer, TableAxis> group : groupRecord.entrySet()) {
            TableAxis axis;
            Integer key = group.getKey();
            if (Objects.equals(key, (axis = group.getValue()).no)) continue;
            tableHelper.removeColAxis(key);
        }
    }

    private static void setTableWidth(Html.Table table, TableHelper tableHelper) {
        tableHelper.releaseAxesPairs();
        int[] colAccessIdx = new int[table.rowNum()];
        Map.Entry axisEntry = tableHelper.firstColAxis();
        while (axisEntry != null) {
            TableAxis axis = (TableAxis)axisEntry.getValue();
            for (int r = 0; r < table.rowNum(); ++r) {
                Html.Td td;
                TdBox tdBox;
                int rowColIdx = colAccessIdx[r];
                Html.Tr tr = table.getTr(r);
                if (rowColIdx == tr.colNum() || (tdBox = tableHelper.getBox(td = tr.getTd(rowColIdx))) == null || tdBox.left.no > axis.no) continue;
                int n = r;
                colAccessIdx[n] = colAccessIdx[n] + 1;
                boolean refresh = tdBox.right.refreshPos(tdBox.left.position + tdBox.size.getWidth());
                Map.Entry nextAxis = tableHelper.higherAxis(tdBox.right);
                if (nextAxis != null) {
                    ((TableAxis)nextAxis.getValue()).refreshPos(tdBox.right.position);
                }
                tableHelper.refreshWidth(tdBox.right.position);
                HtmlConvert.balanceColChildTds(tableHelper, tdBox, refresh);
            }
            axisEntry = tableHelper.higherAxis((TableAxis)axisEntry.getValue());
        }
        tableHelper.refreshWidth(tableHelper.getWidth() + (double)table.getCellSpacing());
        tableHelper.refreshHeight(tableHelper.getHeight() + (double)table.getCellSpacing());
    }

    private static void alignSize(Html.Table table, TableHelper tableHelper) {
        double widthIncr;
        Asserts.illegalArgument(tableHelper.horAxisNum() <= 1, "Only have one horizontal axis");
        double heightIncr = Math.max(table.getHeight() - tableHelper.getHeight(), 0.0) / (double)(tableHelper.horAxisNum() - 1);
        if (heightIncr > 0.0) {
            double nextRangeLen = 0.0;
            for (int i = 0; i < tableHelper.horAxisNum(); ++i) {
                TableAxis current = tableHelper.getRowAxis(i);
                double tmp = nextRangeLen;
                if (i < tableHelper.horAxisNum() - 1) {
                    TableAxis next = tableHelper.getRowAxis(i + 1);
                    nextRangeLen = next.position - current.position;
                }
                if (i > 0) {
                    TableAxis pre = tableHelper.getRowAxis(i - 1);
                    current.refreshPos(pre.position + tmp + heightIncr);
                }
                tableHelper.refreshHeight(current.position);
            }
            tableHelper.refreshHeight(tableHelper.getHeight() + (double)table.getCellSpacing());
        }
        if ((widthIncr = Math.max(table.getWidth() - tableHelper.getWidth(), 0.0) / (double)tableHelper.verAxisNum()) > 0.0) {
            double nextRangeLen = 0.0;
            Map.Entry current = tableHelper.firstColAxis();
            while (current != null) {
                Map.Entry pre;
                Map.Entry next = tableHelper.higherAxis((TableAxis)current.getValue());
                double tmp = nextRangeLen;
                if (next != null) {
                    nextRangeLen = ((TableAxis)next.getValue()).position - ((TableAxis)current.getValue()).position;
                }
                if ((pre = tableHelper.lowerAxis((TableAxis)current.getValue())) != null) {
                    ((TableAxis)current.getValue()).refreshPos(((TableAxis)pre.getValue()).position + tmp + widthIncr);
                }
                tableHelper.refreshWidth(((TableAxis)current.getValue()).position);
                current = next;
            }
            tableHelper.refreshWidth(tableHelper.getWidth() + (double)table.getCellSpacing());
        }
        tableHelper.releaseVerAxes();
        tableHelper.releaseHorAxes();
    }

    private static void balanceRowChildTds(TableHelper tableHelper, TdBox tdBox, boolean refresh) {
        if (!tdBox.rowSpanThanOne() || !refresh) {
            return;
        }
        double incr = tdBox.heightWithoutPixel() / (double)tdBox.rowAxisDiff();
        double position = tdBox.up.position;
        for (int i = tdBox.up.no + 1; i < tdBox.down.no; ++i) {
            TableAxis childAxis = tableHelper.getRowAxis(i);
            childAxis.refreshPos(position + (double)(i - tdBox.up.no) * incr);
        }
    }

    private static void balanceColChildTds(TableHelper tableHelper, TdBox tdBox, boolean refresh) {
        Map.Entry entry;
        Map.Entry entry2;
        if (!tdBox.colSpanThanOne() || !refresh) {
            return;
        }
        TableAxis current = tdBox.left;
        int axisNum = 0;
        while ((entry2 = tableHelper.higherAxis(current)) != null && (Integer)entry2.getKey() < tdBox.right.no) {
            ++axisNum;
            current = (TableAxis)entry2.getValue();
        }
        if (axisNum == 0) {
            return;
        }
        int i = 1;
        double incr = tdBox.widthWithoutPixel() / (double)(axisNum + 1);
        double position = tdBox.left.position;
        current = tdBox.left;
        while ((entry = tableHelper.higherAxis(current)) != null && (Integer)entry.getKey() < tdBox.right.no) {
            TableAxis childAxis = (TableAxis)entry.getValue();
            childAxis.refreshPos(position + (double)i++ * incr);
            current = childAxis;
        }
    }

    private static Assemble convertToAssemble(Html.Table table, TableHelper tableHelper) {
        double tabCellSpacing = (double)table.getCellSpacing() / 144.0;
        double width = tableHelper.getWidth() / 72.0;
        double height = tableHelper.getHeight() / 72.0;
        Assemble.AssembleBuilder assembleBuilder = Assemble.builder().width(width).height(height);
        assembleBuilder.addCell(0.0, 0.0, Node.builder().id(table.getId()).width(width).height(height).href(table.getHref()).style(table.getStyle()).color(table.getColor()).fillColor(table.getBgColor()).penWidth(table.getBorder()).build());
        for (int r = 0; r < table.rowNum(); ++r) {
            Html.Tr tr = table.getTr(r);
            for (int c = 0; c < tr.colNum(); ++c) {
                Html.Td td = tr.getTd(c);
                TdBox tdBox = tableHelper.getBox(td);
                if (tdBox == null) continue;
                double horOffset = tdBox.left.pixelPosition() + 2.0 * tabCellSpacing;
                double verOffset = tdBox.up.pixelPosition() + 2.0 * tabCellSpacing;
                width = tdBox.width();
                height = tdBox.height();
                if (!td.isFixedSize(table)) {
                    width -= tabCellSpacing * 2.0;
                    height -= tabCellSpacing * 2.0;
                }
                Node.NodeBuilder cellBuilder = Node.builder().id(td.getId()).width(width).height(height).href(td.getHref()).label(td.getText()).shape(td.getShape()).labeljust(td.getAlign(table)).labelloc(td.getValign(table)).penWidth(td.getBorder(table)).style(td.getStyle(table)).fontName(td.getFontName()).color(td.getColor()).fontColor(td.getFontColor()).fillColor(td.getBgColor()).fontSize(td.getFontSize());
                Html.Table childTable = td.getTable();
                if (childTable != null) {
                    Assemble assemble = HtmlConvert.convertToAssemble(childTable, tdBox.tableHelper);
                    cellBuilder.assemble(assemble);
                }
                assembleBuilder.addCell(horOffset, verOffset, cellBuilder.build());
            }
        }
        return assembleBuilder.build();
    }

    private static void tdSize(Html.Table table, TdBox tdBox, Html.Td td, RootTableHelper rootTableHelper) {
        FlatPoint labelSize;
        double height;
        double width;
        Html.Table childTable = td.getTable();
        if (childTable != null) {
            TableHelper tableHelper = new TableHelper(childTable);
            HtmlConvert.tableLayout(childTable, tableHelper, rootTableHelper);
            tdBox.tableHelper = tableHelper;
            width = Math.max(td.getWidth(), tableHelper.getWidth() + (double)childTable.getCellSpacing());
            height = Math.max(td.getHeight(), tableHelper.getHeight() + (double)childTable.getCellSpacing());
            labelSize = new FlatPoint(height, width);
        } else {
            width = td.getWidth();
            height = td.getHeight();
            if (td.isFixedSize(table)) {
                tdBox.size = new FlatPoint(height, width);
                return;
            }
            labelSize = FontUtils.measure(td.getText(), td.getFontName(), td.getFontSize(), 0.0);
        }
        int margin = td.getCellPadding(table) + table.getCellSpacing();
        tdBox.size = td.getShape().minContainerSize(labelSize.getHeight() + (double)margin, labelSize.getWidth() + (double)margin);
        tdBox.size.setWidth(Math.max(width, tdBox.size.getWidth()));
        tdBox.size.setHeight(Math.max(height, tdBox.size.getHeight()));
    }

    private static class OccupyRange {
        private final int start;
        private final int end;

        private OccupyRange(int start, int end) {
            Asserts.illegalArgument(end < start, "end lower than start");
            this.start = start;
            this.end = end;
        }

        private boolean leftRange(int axisNo) {
            return axisNo < this.start;
        }

        private boolean inRange(int axisNo) {
            return axisNo >= this.start && axisNo < this.end;
        }
    }

    private static class TdBox {
        private TableAxis left;
        private TableAxis right;
        private final TableAxis up;
        private final TableAxis down;
        private FlatPoint size;
        private TableHelper tableHelper;

        public TdBox(TableAxis left, TableAxis right, TableAxis up, TableAxis down) {
            this.left = left;
            this.right = right;
            this.up = up;
            this.down = down;
        }

        private double widthWithoutPixel() {
            return Math.abs(this.right.position - this.left.position);
        }

        private double heightWithoutPixel() {
            return Math.abs(this.down.position - this.up.position);
        }

        private double width() {
            return Math.abs(this.right.position - this.left.position) / 72.0;
        }

        private double height() {
            return Math.abs(this.down.position - this.up.position) / 72.0;
        }

        private boolean rowSpanThanOne() {
            return this.down.no - this.up.no > 1;
        }

        private boolean colSpanThanOne() {
            return this.right.no - this.left.no > 1;
        }

        private int rowAxisDiff() {
            return this.down.no - this.up.no;
        }
    }

    private static class TableAxis {
        private final int no;
        private double position;

        private TableAxis(int no) {
            this.no = no;
        }

        private boolean refreshPos(double pos) {
            if (pos > this.position) {
                this.position = pos;
                return true;
            }
            return false;
        }

        private double pixelPosition() {
            return this.position / 72.0;
        }

        public String toString() {
            return "TableAxis{no=" + this.no + ", position=" + this.position + '}';
        }
    }

    private static class TableHelper {
        private boolean haveGreaterThan2ColSpan;
        private final FlatPoint tableSize = new FlatPoint(0.0, 0.0);
        private Map<Html.Td, TdBox> tdBoxMap;
        private Map<Integer, List<OccupyRange>> rowOccupyRanges;
        private TableAxis[] horAxes;
        private TreeMap<Integer, TableAxis> verAxes = new TreeMap();
        private Map<Integer, Set<Integer>> pairMark = new HashMap<Integer, Set<Integer>>();

        private TableHelper(Html.Table table) {
            this.horAxes = new TableAxis[table.rowNum() + 1];
        }

        private double getWidth() {
            return this.tableSize.getWidth();
        }

        private double getHeight() {
            return this.tableSize.getHeight();
        }

        private int verAxisNum() {
            return this.verAxes.size();
        }

        private int horAxisNum() {
            return this.horAxes.length;
        }

        private void refreshWidth(double width) {
            this.tableSize.setWidth(Math.max(width, this.tableSize.getWidth()));
        }

        private void refreshHeight(double height) {
            this.tableSize.setHeight(Math.max(height, this.tableSize.getHeight()));
        }

        private TdBox getBox(Html.Td td) {
            if (this.tdBoxMap == null) {
                return null;
            }
            return this.tdBoxMap.get(td);
        }

        private void addPos(Html.Td td, TdBox tdBox) {
            if (this.tdBoxMap == null) {
                this.tdBoxMap = new HashMap<Html.Td, TdBox>();
            }
            this.tdBoxMap.put(td, tdBox);
        }

        private void addOccupyRange(int row, int start, int end) {
            int mid;
            OccupyRange or;
            List<OccupyRange> occupyRanges;
            if (this.rowOccupyRanges == null) {
                this.rowOccupyRanges = new HashMap<Integer, List<OccupyRange>>();
            }
            if (CollectionUtils.isEmpty(occupyRanges = this.rowOccupyRanges.get(row))) {
                occupyRanges = new ArrayList<OccupyRange>();
                this.rowOccupyRanges.put(row, occupyRanges);
                occupyRanges.add(new OccupyRange(start, end));
                return;
            }
            int left = 0;
            int right = occupyRanges.size() - 1;
            while (left < right && (or = occupyRanges.get(mid = (left + right) / 2)).start != start) {
                if (or.start < start) {
                    left = mid + 1;
                    continue;
                }
                right = mid;
            }
            OccupyRange leftOr = occupyRanges.get(left);
            OccupyRange rightOr = occupyRanges.get(right);
            OccupyRange occupyRange = new OccupyRange(start, end);
            if (leftOr.start >= start) {
                occupyRanges.add(left, occupyRange);
            } else if (rightOr.start <= start) {
                occupyRanges.add(right + 1, occupyRange);
            } else {
                occupyRanges.add(left + 1, occupyRange);
            }
        }

        private OccupyRange getOccupyRange(int row, int idx) {
            if (this.rowOccupyRanges == null || this.rowOccupyRanges.size() == 0) {
                return null;
            }
            List<OccupyRange> occupyRanges = this.rowOccupyRanges.get(row);
            if (CollectionUtils.isEmpty(occupyRanges)) {
                return null;
            }
            if (idx < 0 || idx >= occupyRanges.size()) {
                return null;
            }
            return occupyRanges.get(idx);
        }

        private TableAxis getColAxis(int colIdx) {
            return this.verAxes.computeIfAbsent(colIdx, x$0 -> new TableAxis((int)x$0));
        }

        private TableAxis getRowAxis(int rowIdx) {
            Asserts.illegalArgument(rowIdx < 0 || rowIdx >= this.horAxes.length, "Wrong table axis index");
            TableAxis tableAx = this.horAxes[rowIdx];
            if (tableAx == null) {
                this.horAxes[rowIdx] = tableAx = new TableAxis(rowIdx);
            }
            return tableAx;
        }

        private void markHaveTdBetweenColAxis(TableAxis leftAxis, TableAxis rightAxis) {
            this.pairMark.computeIfAbsent(leftAxis.no, l -> new HashSet(1)).add(rightAxis.no);
        }

        private Map.Entry<Integer, TableAxis> firstColAxis() {
            return this.verAxes.firstEntry();
        }

        private Map.Entry<Integer, TableAxis> lastColAxis() {
            return this.verAxes.lastEntry();
        }

        private Map.Entry<Integer, TableAxis> lowerAxis(TableAxis colAxis) {
            return this.verAxes.lowerEntry(colAxis.no);
        }

        private Map.Entry<Integer, TableAxis> higherAxis(TableAxis colAxis) {
            return this.verAxes.higherEntry(colAxis.no);
        }

        private boolean haveTdBetweenAxes(TableAxis left, TableAxis right) {
            Set<Integer> adjs = this.pairMark.get(left.no);
            return CollectionUtils.isNotEmpty(adjs) && adjs.contains(right.no);
        }

        private boolean notHaveTdBetweenAxes(TableAxis left, TableAxis right) {
            return !this.haveTdBetweenAxes(left, right);
        }

        private TableAxis removeColAxis(Integer colAxisNo) {
            return this.verAxes.remove(colAxisNo);
        }

        private void releaseHorAxes() {
            this.horAxes = null;
        }

        private void releaseVerAxes() {
            this.verAxes = null;
        }

        private void releaseAxesPairs() {
            this.pairMark = null;
        }

        private void clearOccupyRanges(int row) {
            if (this.rowOccupyRanges == null) {
                return;
            }
            this.rowOccupyRanges.remove(row);
        }
    }

    private static class RootTableHelper
    extends TableHelper {
        private Set<Html.Table> mark;

        private RootTableHelper(Html.Table table) {
            super(table);
        }

        private void mark(Html.Table table) {
            if (this.mark == null) {
                this.mark = new HashSet<Html.Table>();
            }
            this.mark.add(table);
        }

        private boolean isMark(Html.Table table) {
            if (this.mark == null) {
                return false;
            }
            return this.mark.contains(table);
        }

        private void remove(Html.Table table) {
            if (this.mark == null) {
                return;
            }
            this.mark.remove(table);
        }

        private void releaseMark() {
            this.mark = null;
        }
    }
}

