/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class Mark<T> {
    protected Set<T> marked;

    protected Mark() {
    }

    protected Mark(int initialCapacity) {
        this.marked = new HashSet<T>(initialCapacity);
    }

    protected void mark(T node) {
        Objects.requireNonNull(node);
        if (this.marked == null) {
            this.marked = new HashSet<T>();
        }
        this.marked.add(node);
    }

    protected boolean isMark(T node) {
        if (this.marked == null) {
            return false;
        }
        return this.marked.contains(node);
    }

    protected void clear() {
        if (this.marked == null) {
            return;
        }
        this.marked.clear();
    }
}

