/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import java.util.Objects;
import java.util.TreeSet;
import org.graphper.api.ext.Box;
import org.graphper.def.FlatPoint;
import org.graphper.util.Asserts;

public class OrthoVisGraph {
    private final TreeSet<GridVertex> nodes = new TreeSet();

    public Iterable<GridVertex> nodes() {
        return this.nodes;
    }

    public int nodeNum() {
        return this.nodes.size();
    }

    public void add(GridVertex vertex) {
        Asserts.nullArgument(vertex, "vertex");
        this.nodes.add(vertex);
    }

    public void addLeft(GridVertex vertex, GridVertex left) {
        Asserts.nullArgument(left, "left");
        Asserts.nullArgument(vertex, "vertex");
        Asserts.illegalArgument(vertex == left, "The left node cannot be equal to the current node");
        Asserts.illegalArgument(vertex.right == left || left.left == vertex, "Circular reference");
        this.add(left);
        this.add(vertex);
        left.right = vertex;
        vertex.left = left;
    }

    public void addRight(GridVertex vertex, GridVertex right) {
        Asserts.nullArgument(right, "right");
        Asserts.nullArgument(vertex, "vertex");
        Asserts.illegalArgument(vertex == right, "The right node cannot be equal to the current node");
        this.addLeft(right, vertex);
    }

    public void addTop(GridVertex vertex, GridVertex top) {
        Asserts.nullArgument(top, "top");
        Asserts.nullArgument(vertex, "vertex");
        Asserts.illegalArgument(vertex == top, "The top node cannot be equal to the current node");
        Asserts.illegalArgument(vertex.bottom == top || top.top == vertex, "Circular reference");
        this.add(top);
        this.add(vertex);
        top.bottom = vertex;
        vertex.top = top;
    }

    public void addBottom(GridVertex vertex, GridVertex bottom) {
        Asserts.nullArgument(bottom, "bottom");
        Asserts.nullArgument(vertex, "vertex");
        Asserts.illegalArgument(vertex == bottom, "The bottom node cannot be equal to the current node");
        this.addTop(bottom, vertex);
    }

    public static class Segment {
        private FlatPoint start;
        private FlatPoint end;

        public FlatPoint getStart() {
            return this.start;
        }

        public FlatPoint getEnd() {
            return this.end;
        }

        public void setStart(FlatPoint start) {
            Asserts.nullArgument(start, "start");
            Asserts.illegalArgument(Objects.equals(start, this.end), "start equals to end");
            this.start = start;
        }

        public void setEnd(FlatPoint end) {
            Asserts.nullArgument(end, "end");
            Asserts.illegalArgument(Objects.equals(this.start, end), "end equals to start");
            this.end = end;
        }
    }

    public static class GridVertex
    implements Box,
    Comparable<GridVertex> {
        private boolean nodeInternal;
        private GridVertex left;
        private GridVertex right;
        private GridVertex top;
        private GridVertex bottom;
        private final FlatPoint leftUp;
        private final FlatPoint rightDown;

        public GridVertex(FlatPoint leftUp, FlatPoint rightDown) {
            Asserts.nullArgument(leftUp, "leftUp");
            Asserts.nullArgument(rightDown, "rightDown");
            this.leftUp = leftUp;
            this.rightDown = rightDown;
        }

        @Override
        public double getLeftBorder() {
            return this.leftUp.getX();
        }

        @Override
        public double getRightBorder() {
            return this.rightDown.getX();
        }

        @Override
        public double getUpBorder() {
            return this.leftUp.getY();
        }

        @Override
        public double getDownBorder() {
            return this.rightDown.getY();
        }

        @Override
        public double getX() {
            return (this.leftUp.getX() + this.rightDown.getX()) / 2.0;
        }

        @Override
        public double getY() {
            return (this.leftUp.getY() + this.rightDown.getY()) / 2.0;
        }

        @Override
        public FlatPoint getLeftUp() {
            return this.leftUp;
        }

        @Override
        public FlatPoint getRightDown() {
            return this.rightDown;
        }

        public boolean isNodeInternal() {
            return this.nodeInternal;
        }

        public void markInternalNode() {
            this.nodeInternal = true;
        }

        public GridVertex getLeft() {
            return this.left;
        }

        public GridVertex getRight() {
            return this.right;
        }

        public GridVertex getTop() {
            return this.top;
        }

        public GridVertex getBottom() {
            return this.bottom;
        }

        @Override
        public int compareTo(GridVertex o) {
            if (o == null) {
                return 1;
            }
            int r = Double.compare(this.getX(), o.getX());
            if (r != 0) {
                return r;
            }
            return Double.compare(this.getY(), o.getY());
        }
    }
}

