/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout;

import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.def.FlatPoint;
import org.graphper.layout.MeasureText;

public class RoughMeasureText
implements MeasureText {
    @Override
    public int order() {
        return 2;
    }

    @Override
    public boolean envSupport() {
        return true;
    }

    @Override
    public FlatPoint measure(String text, String fontName, double fontSize) {
        if (StringUtils.isEmpty(text) || fontSize <= 0.0) {
            return new FlatPoint(0.0, 0.0);
        }
        String[] lines = text.split("\n");
        int ll = lines.length;
        double height = (double)ll * fontSize;
        double width = 0.0;
        for (String line : lines) {
            char[] chars;
            double w = 0.0;
            for (char c : chars = line.toCharArray()) {
                if (StringUtils.isChineseChar(c)) {
                    w += fontSize;
                    continue;
                }
                w += fontSize / 2.0;
            }
            if (!(w > width)) continue;
            width = w;
        }
        return new FlatPoint(height, width);
    }
}

