/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.graphper.api.Cluster;
import org.graphper.api.GraphContainer;
import org.graphper.api.Graphviz;
import org.graphper.api.attributes.Labelloc;
import org.graphper.def.EdgeDedigraph;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.ContainerDrawProp;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotAttachment;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.DotLayoutEngine;
import org.graphper.layout.dot.FeasibleTree;
import org.graphper.layout.dot.NetworkSimplex;
import org.graphper.layout.dot.PortHelper;
import org.graphper.layout.dot.RankContent;
import org.graphper.util.CollectionUtils;

abstract class AbstractCoordinate {
    protected final int nslimit;
    protected final boolean needFlip;
    protected final RankContent rankContent;
    protected final DotAttachment dotAttachment;
    protected final EdgeDedigraph<DNode, DLine> proxyDigraph;
    protected Map<GraphContainer, ContainerBorder> containerRankRange;

    AbstractCoordinate(int nslimit, RankContent rankContent, DotAttachment dotAttachment, EdgeDedigraph<DNode, DLine> proxyDigraph) {
        Objects.requireNonNull(rankContent);
        Objects.requireNonNull(proxyDigraph);
        this.nslimit = nslimit;
        this.rankContent = rankContent;
        this.proxyDigraph = proxyDigraph;
        this.dotAttachment = dotAttachment;
        this.needFlip = dotAttachment.getDrawGraph().needFlip();
    }

    protected void accessNodes() {
        this.containerRankRange = this.dotAttachment.haveClusters() ? new HashMap<GraphContainer, ContainerBorder>() : new HashMap(1);
        ContainerBorder containerBorder = new ContainerBorder();
        containerBorder.min = this.rankContent.minRank();
        containerBorder.max = this.rankContent.maxRank();
        this.containerRankRange.put(this.dotAttachment.getGraphviz(), containerBorder);
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            for (int j = 0; j < rankNode.size(); ++j) {
                DNode node = rankNode.get(j);
                node.initNodeSizeExpander(this.dotAttachment.getDrawGraph());
                DNode next = this.rankContent.rankNextNode(node);
                if (next != null) {
                    next.initNodeSizeExpander(this.dotAttachment.getDrawGraph());
                }
                this.nodeConsumer(node);
                if (!node.getContainer().isCluster()) continue;
                this.updateClusterRange(node);
            }
        }
        this.clusterVerticalMargin(this.dotAttachment.getGraphviz());
        this.updateRankSep(true);
    }

    protected void positive() {
        DrawGraph drawGraph = this.dotAttachment.getDrawGraph();
        double rankY = 0.0;
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double rankMaxHeight = -1.7976931348623157E308;
        ArrayList<DNode> flatNodes = null;
        if (this.dotAttachment.haveClusters()) {
            double maxTopHeight = 0.0;
            for (ClusterDrawProp cluster : drawGraph.clusters()) {
                maxTopHeight = Math.max(this.getVerTopMargin(cluster.getCluster()) + 4.0, maxTopHeight);
            }
            rankY += maxTopHeight;
        }
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            for (int j = 0; j < rankNode.size(); ++j) {
                DLine flatLabelLine;
                DNode node = rankNode.get(j);
                node.switchNormalModel();
                node.setX(node.getAuxRank());
                minX = Math.min(node.getX() - node.leftWidth(), minX);
                maxX = Math.max(node.getX() + node.rightWidth(), maxX);
                rankMaxHeight = Math.max((double)((int)node.topHeight()) + node.bottomHeight(), rankMaxHeight);
                if (node.haveSelfLine()) {
                    for (DLine selfLine : node.getSelfLines()) {
                        if (!selfLine.haveLabel()) continue;
                        FlatPoint labelSize = selfLine.getLabelSize();
                        rankMaxHeight = Math.max((double)((int)labelSize.getHeight()), rankMaxHeight);
                    }
                }
                if ((flatLabelLine = node.getFlatLabelLine()) == null || !flatLabelLine.isSameRank()) continue;
                if (flatNodes == null) {
                    flatNodes = new ArrayList<DNode>();
                }
                flatNodes.add(node);
            }
            rankNode.setStartY(rankY);
            rankNode.setEndY(rankY + rankMaxHeight);
            rankY = rankNode.getEndY() + rankNode.getRankSep();
            rankMaxHeight = -1.7976931348623157E308;
        }
        if (CollectionUtils.isNotEmpty(flatNodes)) {
            for (DNode flatNode : flatNodes) {
                DNode preNode = this.rankContent.rankPreNode(flatNode);
                DNode nextNode = this.rankContent.rankNextNode(flatNode);
                if (preNode == null || nextNode == null) continue;
                flatNode.setX((preNode.getX() + preNode.rightWidth() + nextNode.getX() - nextNode.leftWidth()) / 2.0);
            }
        }
        this.flipUpdateRankSep();
        this.containerSizeInit();
    }

    protected ContainerDrawProp getContainerDrawProp(GraphContainer container) {
        ContainerDrawProp containerDrawProp;
        if (container.isGraphviz()) {
            containerDrawProp = this.dotAttachment.getDrawGraph().getGraphvizDrawProp();
        } else if (container.isCluster()) {
            containerDrawProp = this.dotAttachment.getDrawGraph().getClusterDrawProp((Cluster)container);
        } else {
            throw new IllegalArgumentException("An illegal container type occurred when calculating the top and bottom heights of the container");
        }
        return containerDrawProp;
    }

    protected RankContent networkSimplex(DotDigraph auxGraph, boolean needRankContent) {
        FeasibleTree feasibleTree = new FeasibleTree(auxGraph);
        NetworkSimplex networkSimplex = new NetworkSimplex(feasibleTree, this.nslimit, false, needRankContent, Double.MAX_VALUE, null);
        return networkSimplex.getRankContent();
    }

    protected int crossLineLimit(DLine line) {
        if (line.isVirtual() || line.isSameRank()) {
            return 0;
        }
        DNode from = ((DNode)line.from()).getRankIgnoreModel() < ((DNode)line.to()).getRankIgnoreModel() ? (DNode)line.from() : (DNode)line.to();
        DNode to = line.other(from);
        FlatPoint fromPoint = null;
        PortHelper.PortPoint toPoint = null;
        if (!from.isVirtual()) {
            fromPoint = PortHelper.getPortPoint(line.getLine(), from, this.dotAttachment.getDrawGraph());
        }
        if (!to.isVirtual()) {
            toPoint = PortHelper.getPortPoint(line.getLine(), to, this.dotAttachment.getDrawGraph());
        }
        return (int)((fromPoint == null ? 0.0 : fromPoint.getX()) - (toPoint == null ? 0.0 : toPoint.getX()));
    }

    protected int flipGetMargin(GraphContainer container, boolean left, boolean isFlip) {
        if (container == null) {
            return 0;
        }
        ContainerDrawProp containerDrawProp = this.getContainerDrawProp(container);
        FlatPoint labelSize = containerDrawProp.getLabelSize();
        Labelloc labelloc = null;
        if (container.isGraphviz()) {
            labelloc = ((Graphviz)container).graphAttrs().getLabelloc();
        } else if (container.isCluster()) {
            labelloc = ((Cluster)container).clusterAttrs().getLabelloc();
        }
        if (labelSize == null || labelloc == Labelloc.CENTER) {
            return (int)containerDrawProp.getVerMargin();
        }
        if (labelloc == Labelloc.BOTTOM == left) {
            return (int)containerDrawProp.getVerMargin() + (isFlip ? (int)labelSize.getWidth() : (int)labelSize.getHeight());
        }
        return (int)containerDrawProp.getVerMargin();
    }

    protected void nodeConsumer(DNode node) {
    }

    protected abstract double containerLeftBorder(GraphContainer var1);

    protected abstract double containerRightBorder(GraphContainer var1);

    private void updateRankSep(boolean needIgnoreFlip) {
        if (this.containerRankRange == null || needIgnoreFlip && this.needFlip) {
            return;
        }
        HashMap<RankContent.RankNode, RankTopBottom> rankUpDownHeight = new HashMap<RankContent.RankNode, RankTopBottom>();
        for (Map.Entry<GraphContainer, ContainerBorder> entry : this.containerRankRange.entrySet()) {
            RankTopBottom rtb;
            ContainerBorder rankRange = entry.getValue();
            RankContent.RankNode firstPreRank = this.rankContent.get(rankRange.min - 1);
            RankContent.RankNode lastRank = this.rankContent.get(rankRange.max);
            if (firstPreRank != null) {
                rtb = rankUpDownHeight.computeIfAbsent(firstPreRank, r -> new RankTopBottom());
                rtb.top = Math.max(rtb.top, rankRange.verTopMargin + 10.0);
            }
            rtb = rankUpDownHeight.computeIfAbsent(lastRank, r -> new RankTopBottom());
            rtb.bottom = Math.max(rtb.bottom, rankRange.verBottomMargin + 10.0);
        }
        for (Map.Entry<GraphContainer, ContainerBorder> entry : rankUpDownHeight.entrySet()) {
            RankContent.RankNode rankNode = (RankContent.RankNode)((Object)entry.getKey());
            RankTopBottom rankTopBottom = (RankTopBottom)((Object)entry.getValue());
            rankNode.setRankSep(Math.max(rankNode.getRankSep(), rankTopBottom.top + rankTopBottom.bottom));
        }
    }

    private double getVerTopMargin(GraphContainer graphContainer) {
        ContainerBorder containerBorder = this.getContainerBorder(graphContainer);
        if (containerBorder == null) {
            return 0.0;
        }
        return containerBorder.verTopMargin;
    }

    private double getVerBottomMargin(GraphContainer graphContainer) {
        ContainerBorder clusterBorder = this.getContainerBorder(graphContainer);
        if (clusterBorder == null) {
            return 0.0;
        }
        return clusterBorder.verBottomMargin;
    }

    private ContainerBorder clusterVerticalMargin(GraphContainer graphContainer) {
        double maxTopHeight = 0.0;
        double maxBottomHeight = 0.0;
        ContainerDrawProp containerDrawProp = this.getContainerDrawProp(graphContainer);
        ContainerBorder containerBorder = this.containerRankRange.computeIfAbsent(graphContainer, c -> new ContainerBorder());
        for (Cluster cluster : DotAttachment.clusters(graphContainer)) {
            ContainerBorder childClusterBorder = this.clusterVerticalMargin(cluster);
            if (containerBorder.min == childClusterBorder.min) {
                maxTopHeight = Math.max(childClusterBorder.verTopMargin, maxTopHeight);
            }
            if (containerBorder.max != childClusterBorder.max) continue;
            maxBottomHeight = Math.max(childClusterBorder.verBottomMargin, maxBottomHeight);
        }
        if (this.needFlip) {
            FlatPoint labelSize = containerDrawProp.getLabelSize();
            if (labelSize != null) {
                labelSize.flip();
            }
        } else {
            containerBorder.verTopMargin = maxTopHeight + containerDrawProp.topLowestHeight();
            containerBorder.verBottomMargin = maxBottomHeight + containerDrawProp.bottomLowestHeight();
        }
        return containerBorder;
    }

    private void updateClusterRange(DNode n) {
        if (!n.getContainer().isCluster()) {
            return;
        }
        int rank = n.getRankIgnoreModel();
        Graphviz graphviz = this.dotAttachment.getGraphviz();
        GraphContainer container = n.getContainer();
        while (container != null && container.isCluster()) {
            ContainerBorder clusterBorder = this.containerRankRange.computeIfAbsent(container, c -> new ContainerBorder());
            clusterBorder.min = Math.min(clusterBorder.min, rank);
            clusterBorder.max = Math.max(clusterBorder.max, rank);
            container = graphviz.effectiveFather(container);
        }
    }

    private void flipUpdateRankSep() {
        if (!this.needFlip) {
            return;
        }
        TreeMap<Integer, Integer> rankOffset = new TreeMap<Integer, Integer>(Integer::compareTo);
        this.flipUpdateRankSep(this.dotAttachment.getGraphviz(), rankOffset);
        this.updateRankSep(false);
        double rankY = 0.0;
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            double height = rankNode.getEndY() - rankNode.getStartY();
            rankNode.setStartY(rankY);
            rankNode.setEndY(rankY + height);
            rankY = rankNode.getEndY() + rankNode.getRankSep();
        }
    }

    private void flipUpdateRankSep(GraphContainer container, TreeMap<Integer, Integer> rankAfterOffset) {
        if (!this.needFlip) {
            return;
        }
        ContainerBorder containerBorder = this.getContainerBorder(container);
        if (containerBorder == null) {
            return;
        }
        double maxTopHeight = 0.0;
        double maxBottomHeight = 0.0;
        for (Cluster cluster : DotAttachment.clusters(container)) {
            this.flipUpdateRankSep(cluster, rankAfterOffset);
            ContainerBorder child = this.getContainerBorder(cluster);
            if (child == null) continue;
            if (containerBorder.min == child.min) {
                maxTopHeight = Math.max(child.verTopMargin, maxTopHeight);
            }
            if (containerBorder.max != child.max) continue;
            maxBottomHeight = Math.max(child.verBottomMargin, maxBottomHeight);
        }
        ContainerDrawProp containerDrawProp = this.getContainerDrawProp(container);
        containerBorder.verTopMargin = maxTopHeight + containerDrawProp.getHorMargin();
        containerBorder.verBottomMargin = maxBottomHeight + containerDrawProp.getHorMargin();
        FlatPoint labelSize = containerDrawProp.getLabelSize();
        if (labelSize == null) {
            return;
        }
        double startRankOffset = 0.0;
        double endRankOffset = 0.0;
        for (Map.Entry<Integer, Integer> entry : rankAfterOffset.entrySet()) {
            Integer key = entry.getKey();
            if (key <= containerBorder.min) {
                startRankOffset += (double)entry.getValue().intValue();
            }
            if (key > containerBorder.max) break;
            endRankOffset += (double)entry.getValue().intValue();
        }
        RankContent.RankNode start = this.rankContent.get(containerBorder.min);
        RankContent.RankNode end = this.rankContent.get(containerBorder.max);
        double height = containerBorder.verTopMargin + containerBorder.verBottomMargin + end.getEndY() - start.getStartY() + endRankOffset - startRankOffset;
        double diff = labelSize.getHeight() - height;
        if (diff <= 0.0) {
            return;
        }
        ContainerBorder containerBorder2 = containerBorder;
        containerBorder2.verTopMargin = containerBorder2.verTopMargin + diff / 2.0;
        containerBorder2 = containerBorder;
        containerBorder2.verBottomMargin = containerBorder2.verBottomMargin + diff / 2.0;
        RankContent.RankNode startPre = this.rankContent.get(containerBorder.min - 1);
        double preRankSep = startPre != null ? start.getStartY() - startPre.getEndY() : 0.0;
        diff = containerBorder.verTopMargin - preRankSep;
        if (diff > 0.0) {
            Integer minRankOffset = rankAfterOffset.get(containerBorder.min);
            minRankOffset = minRankOffset != null ? Integer.valueOf(minRankOffset + ((int)diff + 5)) : Integer.valueOf((int)diff + 5);
            rankAfterOffset.put(containerBorder.min, minRankOffset);
        }
        if ((diff = containerBorder.verBottomMargin - end.getRankSep()) > 0.0 && containerBorder.max != this.rankContent.maxRank()) {
            Integer maxRankOffset = rankAfterOffset.get(containerBorder.max + 1);
            maxRankOffset = maxRankOffset != null ? Integer.valueOf(maxRankOffset + ((int)diff + 5)) : Integer.valueOf((int)diff + 5);
            rankAfterOffset.put(containerBorder.max, maxRankOffset);
        }
    }

    private void containerSizeInit() {
        DrawGraph drawGraph = this.dotAttachment.getDrawGraph();
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            for (int j = 0; j < rankNode.size(); ++j) {
                DNode node = rankNode.get(j);
                RankContent.RankNode rank = this.rankContent.get(node.getRank());
                double preRankY = rank.getStartY();
                double nextRankY = rank.getEndY() + rankNode.getRankSep();
                double offset = (nextRankY - preRankY - rankNode.getRankSep()) / 2.0 - node.getHeight() / 2.0;
                node.setY(preRankY + node.realTopHeight() + offset);
                this.containerAdjust(node);
                if (!node.isVirtual()) {
                    this.updateNodeContainer(node, drawGraph.getNodeDrawProp(node.getNode()));
                }
                drawGraph.updateXAxisRange(node.getX() - node.leftWidth());
                drawGraph.updateXAxisRange(node.getX() + node.rightWidth());
                drawGraph.updateYAxisRange(node.getY() - node.topHeight());
                drawGraph.updateYAxisRange(node.getY() + node.bottomHeight());
            }
        }
        this.refreshGraphBorder(drawGraph);
    }

    private void containerAdjust(DNode node) {
        if (!node.getContainer().isCluster()) {
            return;
        }
        Graphviz graphviz = this.dotAttachment.getGraphviz();
        DrawGraph drawGraph = this.dotAttachment.getDrawGraph();
        GraphContainer container = node.getContainer();
        while (container != null && container.isCluster()) {
            ClusterDrawProp clusterDrawProp = drawGraph.getClusterDrawProp((Cluster)container);
            if (clusterDrawProp == null) {
                container = graphviz.effectiveFather(container);
                continue;
            }
            double verTopMargin = this.getVerTopMargin(clusterDrawProp.getCluster());
            double verBottomMargin = this.getVerBottomMargin(clusterDrawProp.getCluster());
            this.updateClusterHorBorder((Cluster)container, clusterDrawProp);
            this.updateClusterVerBorder(node, clusterDrawProp, verTopMargin, verBottomMargin);
            container = graphviz.effectiveFather(container);
            drawGraph.updateXAxisRange(clusterDrawProp.getLeftBorder());
            drawGraph.updateXAxisRange(clusterDrawProp.getRightBorder());
            drawGraph.updateYAxisRange(clusterDrawProp.getUpBorder());
            drawGraph.updateYAxisRange(clusterDrawProp.getDownBorder());
        }
    }

    private void updateClusterVerBorder(DNode node, ClusterDrawProp clusterDrawProp, double verTopMargin, double verBottomMargin) {
        double top = node.getY() - node.topHeight();
        double bottom = node.getY() + node.bottomHeight();
        if (node.haveSelfLine()) {
            for (DLine selfLine : node.getSelfLines()) {
                if (!selfLine.haveLabel()) continue;
                FlatPoint labelSize = selfLine.getLabelSize();
                top = Math.min(top, node.getY() - labelSize.getHeight() / 2.0);
                bottom = Math.max(bottom, node.getY() + labelSize.getHeight() / 2.0);
            }
        }
        clusterDrawProp.setUpBorder(Math.min(clusterDrawProp.getUpBorder(), top - verTopMargin - 2.0));
        clusterDrawProp.setDownBorder(Math.max(clusterDrawProp.getDownBorder(), bottom + verBottomMargin + 2.0));
    }

    private void updateClusterHorBorder(Cluster cluster, ClusterDrawProp clusterDrawProp) {
        double leftBorder = this.containerLeftBorder(cluster);
        double rightBorder = this.containerRightBorder(cluster);
        clusterDrawProp.setLeftBorder(leftBorder - 2.0);
        clusterDrawProp.setRightBorder(rightBorder + 2.0);
    }

    private ContainerBorder getContainerBorder(GraphContainer graphContainer) {
        if (this.containerRankRange == null) {
            return null;
        }
        return this.containerRankRange.get(graphContainer);
    }

    private void updateNodeContainer(DNode node, NodeDrawProp nodeDrawProp) {
        if (nodeDrawProp == null) {
            return;
        }
        nodeDrawProp.setLeftBorder(node.getLeftBorder());
        nodeDrawProp.setRightBorder(node.getRightBorder());
        nodeDrawProp.setUpBorder(node.getUpBorder());
        nodeDrawProp.setDownBorder(node.getDownBorder());
        DotLayoutEngine.nodeLabelSet(nodeDrawProp, this.dotAttachment.getDrawGraph(), false);
    }

    private void refreshGraphBorder(DrawGraph drawGraph) {
        GraphvizDrawProp graphvizDrawProp = drawGraph.getGraphvizDrawProp();
        double verTopMargin = this.getVerTopMargin(graphvizDrawProp.getGraphviz());
        double verBottomMargin = this.getVerBottomMargin(graphvizDrawProp.getGraphviz());
        drawGraph.updateYAxisRange(drawGraph.getMinY() - verTopMargin);
        drawGraph.updateYAxisRange(drawGraph.getMaxY() + verBottomMargin);
        FlatPoint labelSize = graphvizDrawProp.getLabelSize();
        if (labelSize != null) {
            if (this.needFlip) {
                Labelloc labelloc = drawGraph.getGraphviz().graphAttrs().getLabelloc();
                if (labelloc == Labelloc.TOP) {
                    drawGraph.updateXAxisRange(drawGraph.getMaxX() + labelSize.getWidth());
                } else {
                    drawGraph.updateXAxisRange(drawGraph.getMinX() - labelSize.getWidth());
                }
            } else {
                double width = labelSize.getWidth() - drawGraph.width();
                if (width > 0.0) {
                    drawGraph.updateXAxisRange(drawGraph.getMinX() - width / 2.0);
                    drawGraph.updateXAxisRange(drawGraph.getMaxX() + width / 2.0);
                }
            }
        }
        if (this.needFlip) {
            drawGraph.updateXAxisRange(drawGraph.getMinX() - graphvizDrawProp.getVerMargin());
            drawGraph.updateXAxisRange(drawGraph.getMaxX() + graphvizDrawProp.getVerMargin());
            drawGraph.updateYAxisRange(drawGraph.getMinY() - graphvizDrawProp.getHorMargin());
            drawGraph.updateYAxisRange(drawGraph.getMaxY() + graphvizDrawProp.getHorMargin());
        } else {
            drawGraph.updateXAxisRange(drawGraph.getMinX() - graphvizDrawProp.getHorMargin());
            drawGraph.updateXAxisRange(drawGraph.getMaxX() + graphvizDrawProp.getHorMargin());
            drawGraph.updateYAxisRange(drawGraph.getMinY() - graphvizDrawProp.getVerMargin());
            drawGraph.updateYAxisRange(drawGraph.getMaxY() + graphvizDrawProp.getVerMargin());
        }
        graphvizDrawProp.setLeftBorder(drawGraph.getMinX());
        graphvizDrawProp.setRightBorder(drawGraph.getMaxX());
        graphvizDrawProp.setUpBorder(drawGraph.getMinY());
        graphvizDrawProp.setDownBorder(drawGraph.getMaxY());
    }

    private static class RankTopBottom {
        private double top;
        private double bottom;

        private RankTopBottom() {
        }
    }

    protected static class ContainerBorder {
        protected int min = Integer.MAX_VALUE;
        protected int max = Integer.MIN_VALUE;
        protected int newMin;
        private double verTopMargin;
        private double verBottomMargin;

        protected ContainerBorder() {
        }

        int width() {
            return this.max - this.min;
        }
    }
}

