/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.graphper.api.Line;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.attributes.Port;
import org.graphper.api.attributes.Splines;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePosition;
import org.graphper.def.Curves;
import org.graphper.def.EdgeDedigraph;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.draw.DefaultShapePosition;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.LineDrawProp;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.DotLineRouter;
import org.graphper.layout.dot.LineClip;
import org.graphper.layout.dot.PortHelper;
import org.graphper.layout.dot.RankContent;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDotLineRouter
extends LineClip
implements DotLineRouter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDotLineRouter.class);
    protected static final double LABEL_NODE_SIDE_MIN_DISTANCE = 10.0;
    protected static final double CLIP_DIST_ERROR = 0.1;
    protected RankContent rankContent;
    protected EdgeDedigraph<DNode, DLine> digraphProxy;

    @Override
    public void route() {
        Object attach = this.attach();
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            for (DNode node : rankNode) {
                if (this.nodeConsumer(node, attach)) continue;
                for (DLine line : this.digraphProxy.outAdjacent(node)) {
                    if (line.isVirtual() || line.isHide()) continue;
                    if (line.isParallelMerge() && (!line.isSameRank() || line.isSameRank() && this.isAdj((DNode)line.from(), (DNode)line.to()))) {
                        this.parallelLineHandle(line);
                        continue;
                    }
                    this.lineConsumer(line, attach);
                }
                this.selfLoopHandle(node);
            }
        }
    }

    protected Object attach() {
        return null;
    }

    protected boolean nodeConsumer(DNode node, Object attach) {
        return false;
    }

    protected void lineConsumer(DLine line, Object attach) {
    }

    protected boolean isSplineNone() {
        return this.drawGraph.getGraphviz().graphAttrs().getSplines() == Splines.NONE;
    }

    protected List<FlatPoint> multiBezierCurveToPoints(Curves.MultiBezierCurve curves) {
        ArrayList<FlatPoint> splines = new ArrayList<FlatPoint>(curves.size() * 3 + 1);
        for (int i = 0; i < curves.size(); ++i) {
            Curves.ThirdOrderBezierCurve curve = (Curves.ThirdOrderBezierCurve)curves.get(i);
            if (i == 0) {
                splines.add(curve.getV1());
            }
            splines.add(curve.getV2());
            splines.add(curve.getV3());
            splines.add(curve.getV4());
        }
        return splines;
    }

    protected List<FlatPoint> thirdOrderBezierCurveToPoints(Curves.ThirdOrderBezierCurve curve) {
        ArrayList<FlatPoint> splines = new ArrayList<FlatPoint>(4);
        splines.add(curve.getV1());
        splines.add(curve.getV2());
        splines.add(curve.getV3());
        splines.add(curve.getV4());
        return splines;
    }

    public static FlatPoint straightLineClipShape(ShapePosition shapePosition, FlatPoint inPoint, FlatPoint outPoint) {
        Asserts.nullArgument(shapePosition, "shapePosition");
        return AbstractDotLineRouter.straightLineClipShape(shapePosition, shapePosition.nodeShape(), inPoint, outPoint);
    }

    public static FlatPoint straightLineClipShape(Box box, NodeShape nodeShape, FlatPoint inPoint, FlatPoint outPoint) {
        FlatPoint midPoint;
        Asserts.nullArgument(inPoint, "inPoint");
        Asserts.nullArgument(outPoint, "outPoint");
        Asserts.nullArgument(box, "shapePosition");
        Asserts.nullArgument(nodeShape, "shapePosition.nodeShape()");
        Asserts.illegalArgument(!nodeShape.in(box, inPoint), "The specified internal node is not inside the node");
        Asserts.illegalArgument(nodeShape.in(box, outPoint), "The specified external node is inside the node");
        FlatPoint in = inPoint;
        FlatPoint out = outPoint;
        do {
            if (nodeShape.in(box, midPoint = new FlatPoint((in.getX() + out.getX()) / 2.0, (in.getY() + out.getY()) / 2.0))) {
                in = midPoint;
                continue;
            }
            out = midPoint;
        } while (FlatPoint.twoFlatPointDistance(in, out) > 0.1);
        return midPoint;
    }

    public static Curves.ThirdOrderBezierCurve besselCurveClipShape(ShapePosition shapePosition, Curves.ThirdOrderBezierCurve bezierCurve) {
        Asserts.nullArgument(shapePosition, "shapePosition");
        Asserts.nullArgument(shapePosition.nodeShape(), "shapePosition.nodeShape()");
        Asserts.nullArgument(bezierCurve, "bezierCurve");
        if (shapePosition.getHeight() <= 0.0 || shapePosition.getWidth() <= 0.0) {
            return bezierCurve;
        }
        FlatPoint v1 = bezierCurve.getV1();
        FlatPoint v2 = bezierCurve.getV2();
        FlatPoint v3 = bezierCurve.getV3();
        FlatPoint v4 = bezierCurve.getV4();
        NodeShape nodeShape = shapePosition.nodeShape();
        boolean v1In = nodeShape.in(shapePosition, v1);
        boolean v4In = nodeShape.in(shapePosition, v4);
        if (v1In && v4In) {
            return null;
        }
        if (!v1In && !v4In) {
            return bezierCurve;
        }
        double in = v1In ? 0.0 : 1.0;
        double out = v4In ? 0.0 : 1.0;
        FlatPoint[] points = new FlatPoint[]{v1, v2, v3, v4};
        do {
            FlatPoint midPoint;
            if (nodeShape.in(shapePosition, midPoint = Curves.besselEquationCalc((in + out) / 2.0, points))) {
                in = (in + out) / 2.0;
                continue;
            }
            out = (in + out) / 2.0;
        } while (FlatPoint.twoFlatPointDistance(Curves.besselEquationCalc(in, points), Curves.besselEquationCalc(out, points)) > 0.1);
        return Curves.divideThirdBesselCurve(in, v4In, bezierCurve);
    }

    protected void selfLoopHandle(DNode node) {
        if (node == null || node.isVirtual() || CollectionUtils.isEmpty(node.getSelfLines()) || this.isSplineNone()) {
            return;
        }
        boolean portAxisSelfLineMode = this.drawGraph.usePortAxisExpander();
        FlatPoint center = new FlatPoint(node.getX(), node.getY());
        for (DLine selfLine : node.getSelfLines()) {
            LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(selfLine.getLine());
            if (CollectionUtils.isEmpty(lineDrawProp) || lineDrawProp.size() < 2) continue;
            for (FlatPoint point : lineDrawProp) {
                point.setX(node.getX() + point.getX());
                point.setY(node.getY() + point.getY());
            }
            if (lineDrawProp.getLabelCenter() != null) {
                FlatPoint labelCenter = lineDrawProp.getLabelCenter();
                labelCenter.setX(node.getX() + labelCenter.getX());
                labelCenter.setY(node.getY() + labelCenter.getY());
            }
            if (portAxisSelfLineMode) {
                if (lineDrawProp.size() == 2) {
                    this.twoSelfLineDraw(selfLine);
                } else {
                    this.largeTwoSelfLineDraw(center, selfLine);
                }
            } else {
                this.newSelfLineDrawMode(selfLine);
            }
            if (!CollectionUtils.isNotEmpty(lineDrawProp)) continue;
            lineDrawProp.setStart((FlatPoint)lineDrawProp.get(0));
            lineDrawProp.setEnd((FlatPoint)lineDrawProp.get(lineDrawProp.size() - 1));
        }
    }

    protected void handleSameEndpointParallelLines(List<DLine> parallelLines) {
        this.symmetryParallelLine(parallelLines);
    }

    protected void parallelLineHandle(DLine line) {
        if (line == null || !line.isParallelMerge() || this.isSplineNone()) {
            return;
        }
        Map<Integer, List<DLine>> parallelLineRecordMap = this.groupParallelLineByEndpoint(line);
        for (Map.Entry<Integer, List<DLine>> entry : parallelLineRecordMap.entrySet()) {
            List<DLine> parallelLines = entry.getValue();
            this.handleSameEndpointParallelLines(parallelLines);
        }
    }

    protected void symmetryParallelLine(List<DLine> parallelLines) {
        if (CollectionUtils.isEmpty(parallelLines)) {
            return;
        }
        DLine line = parallelLines.get(0);
        DNode from = (DNode)line.from();
        DNode to = (DNode)line.to();
        FlatPoint fromPoint = new FlatPoint(from.getX(), from.getY());
        FlatPoint toPoint = new FlatPoint(to.getX(), to.getY());
        double distUnit = (this.drawGraph.getGraphviz().graphAttrs().getNodeSep() + this.drawGraph.getGraphviz().graphAttrs().getRankSep() + FlatPoint.twoFlatPointDistance(fromPoint, toPoint)) / 20.0;
        for (int i = 0; i < parallelLines.size(); ++i) {
            this.parallelEdges(parallelLines.get(i), parallelLines.size(), distUnit, i + 1);
        }
    }

    protected void lineSegmentConsumer(DLine line, Consumer<DLine> consumer) {
        DNode to = (DNode)line.to();
        while (to.isVirtual()) {
            Iterator<DLine> iterator;
            if (consumer != null) {
                consumer.accept(line);
            }
            if (!(iterator = this.digraphProxy.outAdjacent(to).iterator()).hasNext()) continue;
            DLine dLine = iterator.next();
            to = (DNode)dLine.to();
            line = dLine;
        }
        if (consumer != null && !to.isVirtual()) {
            consumer.accept(line);
        }
    }

    protected boolean isAdj(DNode n, DNode w) {
        DNode current;
        if (Math.abs(w.getRankIndex() - n.getRankIndex()) <= 1) {
            return true;
        }
        DNode largeRankIndexNode = n.getRankIndex() > w.getRankIndex() ? n : w;
        DNode dNode = current = n == largeRankIndexNode ? w : n;
        while ((current = this.rankContent.rankNextNode(current)) != null && current != largeRankIndexNode && current.isVirtual()) {
        }
        return current == largeRankIndexNode;
    }

    protected Map<Integer, List<DLine>> groupParallelLineByEndpoint(DLine line) {
        HashMap<Integer, List<DLine>> parallelLineRecordMap = new HashMap<Integer, List<DLine>>(1);
        for (int i = 0; i < line.getParallelNums(); ++i) {
            DLine edge = line.parallelLine(i);
            LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(edge.getLine());
            DNode from = (DNode)edge.from();
            DNode to = (DNode)edge.to();
            Port fromPort = PortHelper.getLineEndPointPort(from.getNode(), edge.getLine(), this.drawGraph);
            Port toPort = PortHelper.getLineEndPointPort(to.getNode(), edge.getLine(), this.drawGraph);
            String headCell = lineDrawProp.lineAttrs().getHeadCell();
            String tailCell = lineDrawProp.lineAttrs().getTailCell();
            String sign = this.signature(fromPort, tailCell) + this.signature(toPort, headCell);
            sign = sign + this.signature(toPort, tailCell) + this.signature(fromPort, headCell);
            parallelLineRecordMap.computeIfAbsent(sign.hashCode(), h -> new ArrayList(2)).add(edge);
        }
        return parallelLineRecordMap;
    }

    private String signature(Port port, String cellId) {
        String sign = port != null ? port.name() : "";
        return sign + cellId;
    }

    public static ShapePosition newArrowShapePosition(FlatPoint point, double arrowSize) {
        Asserts.nullArgument(point, "point");
        return new DefaultShapePosition(point.getX(), point.getY(), arrowSize * 2.0, arrowSize * 2.0, NodeShapeEnum.CIRCLE);
    }

    public static <E extends FlatPoint> E getPoint(List<E> path, int i) {
        if (i < 0 || i >= path.size()) {
            return null;
        }
        return (E)((FlatPoint)path.get(i));
    }

    public static <E extends FlatPoint> E getFirst(List<E> path) {
        return (E)(CollectionUtils.isEmpty(path) ? null : (FlatPoint)path.get(0));
    }

    public static <E extends FlatPoint> E getLast(List<E> path) {
        return (E)(CollectionUtils.isEmpty(path) ? null : (FlatPoint)path.get(path.size() - 1));
    }

    public static <E extends FlatPoint> InOutPointPair findInOutPair(int unit, List<E> path, boolean firstStart, ShapePosition shapePosition) {
        Asserts.nullArgument(shapePosition, "shapePosition");
        Asserts.nullArgument(shapePosition.nodeShape(), "shapePosition.nodeShape()");
        Integer idx = null;
        Integer count = null;
        NodeShape nodeShape = shapePosition.nodeShape();
        E point = AbstractDotLineRouter.getFirst(path);
        if (firstStart && point != null && nodeShape.in(shapePosition, (FlatPoint)point)) {
            idx = 0;
            count = unit;
        } else {
            point = AbstractDotLineRouter.getLast(path);
            if (point != null && nodeShape.in(shapePosition, (FlatPoint)point)) {
                idx = path.size() - 1;
                count = -unit;
            }
        }
        if (idx == null) {
            return null;
        }
        FlatPoint pre = null;
        do {
            boolean pointIn;
            boolean preIn;
            if (pre != null && (preIn = nodeShape.in(shapePosition, pre)) != (pointIn = nodeShape.in(shapePosition, (FlatPoint)point))) {
                return new InOutPointPair(idx - count, count > 0, preIn ? pre : (FlatPoint)point, pointIn ? pre : (FlatPoint)point);
            }
            idx = idx + count;
            pre = (FlatPoint)point;
        } while ((point = AbstractDotLineRouter.getPoint(path, idx)) != null);
        return null;
    }

    private void largeTwoSelfLineDraw(FlatPoint center, DLine selfLine) {
        Asserts.illegalArgument(selfLine == null || selfLine.isVirtual(), "error self loop no");
        LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(selfLine.getLine());
        FlatPoint mid = (FlatPoint)lineDrawProp.get(lineDrawProp.size() / 2);
        FlatPoint start = (FlatPoint)lineDrawProp.get(0);
        FlatPoint end = (FlatPoint)lineDrawProp.get(lineDrawProp.size() - 1);
        Curves.MultiBezierCurve curves = Curves.fitCurves(Arrays.asList(start, mid, end), Vectors.add(Vectors.sub(start, center), Vectors.sub(mid, center)), Vectors.add(Vectors.sub(end, center), Vectors.sub(mid, center)), 0.0);
        lineDrawProp.clear();
        lineDrawProp.markIsBesselCurve();
        lineDrawProp.addAll((Collection<? extends FlatPoint>)this.multiBezierCurveToPoints(curves));
    }

    private void twoSelfLineDraw(DLine selfLine) {
        Asserts.illegalArgument(selfLine == null || selfLine.isVirtual(), "error self loop no");
        LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(selfLine.getLine());
        if (CollectionUtils.isEmpty(lineDrawProp) || lineDrawProp.size() != 2) {
            return;
        }
        FlatPoint start = (FlatPoint)lineDrawProp.get(0);
        FlatPoint end = (FlatPoint)lineDrawProp.get(lineDrawProp.size() - 1);
        FlatPoint axis = Vectors.sub(end, start);
        FlatPoint vertical = new FlatPoint(axis.getY(), -axis.getX());
        FlatPoint verticalOpposite = vertical.reserve();
        lineDrawProp.clear();
        double dist = axis.dist() / 4.0;
        lineDrawProp.add(start);
        lineDrawProp.add(Vectors.add(start, Vectors.scale(vertical, dist)));
        lineDrawProp.add(Vectors.add(end, Vectors.scale(vertical, dist)));
        lineDrawProp.add(end);
        lineDrawProp.add(Vectors.add(end, Vectors.scale(verticalOpposite, dist)));
        lineDrawProp.add(Vectors.add(start, Vectors.scale(verticalOpposite, dist)));
        lineDrawProp.add(start);
        lineDrawProp.markIsBesselCurve();
    }

    private void newSelfLineDrawMode(DLine selfLine) {
        Asserts.illegalArgument(selfLine == null || selfLine.isVirtual(), "error self loop no");
        LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(selfLine.getLine());
        if (CollectionUtils.isEmpty(lineDrawProp) || lineDrawProp.size() != 2 && lineDrawProp.size() != 3) {
            return;
        }
        FlatPoint start = (FlatPoint)lineDrawProp.get(0);
        FlatPoint mid = (FlatPoint)lineDrawProp.get(1);
        FlatPoint end = lineDrawProp.size() == 2 ? start.clone() : (FlatPoint)lineDrawProp.get(2);
        double minX = Math.min(start.getX(), end.getX());
        double maxX = Math.max(start.getX(), end.getX());
        double minY = Math.min(start.getY(), end.getY());
        double maxY = Math.max(start.getY(), end.getY());
        lineDrawProp.clear();
        if (mid.getX() >= minX && mid.getX() <= maxX && mid.getY() >= minY && mid.getY() <= maxY) {
            log.warn("Can not draw self line: mid point in Endpoint box");
            return;
        }
        lineDrawProp.add(start);
        if (mid.getX() < minX) {
            double startDist = (start.getX() - mid.getX()) / 4.0;
            double endDist = (end.getX() - mid.getX()) / 4.0;
            if (start.getY() < end.getY()) {
                lineDrawProp.add(new FlatPoint(start.getX() - startDist, start.getY() - startDist));
                lineDrawProp.add(new FlatPoint(mid.getX(), start.getY() - startDist));
                lineDrawProp.add(mid);
                lineDrawProp.add(new FlatPoint(mid.getX(), end.getY() + endDist));
                lineDrawProp.add(new FlatPoint(end.getX() - endDist, end.getY() + endDist));
            } else {
                lineDrawProp.add(new FlatPoint(start.getX() - startDist, start.getY() + startDist));
                lineDrawProp.add(new FlatPoint(mid.getX(), start.getY() + startDist));
                lineDrawProp.add(mid);
                lineDrawProp.add(new FlatPoint(mid.getX(), end.getY() - endDist));
                lineDrawProp.add(new FlatPoint(end.getX() - endDist, end.getY() - endDist));
            }
        } else if (mid.getX() > maxX) {
            double startDist = (mid.getX() - start.getX()) / 4.0;
            double endDist = (mid.getX() - end.getX()) / 4.0;
            if (start.getY() < end.getY()) {
                lineDrawProp.add(new FlatPoint(start.getX() + startDist, start.getY() - startDist));
                lineDrawProp.add(new FlatPoint(mid.getX(), start.getY() - startDist));
                lineDrawProp.add(mid);
                lineDrawProp.add(new FlatPoint(mid.getX(), end.getY() + endDist));
                lineDrawProp.add(new FlatPoint(end.getX() + endDist, end.getY() + endDist));
            } else {
                lineDrawProp.add(new FlatPoint(start.getX() + startDist, start.getY() + startDist));
                lineDrawProp.add(new FlatPoint(mid.getX(), start.getY() + startDist));
                lineDrawProp.add(mid);
                lineDrawProp.add(new FlatPoint(mid.getX(), end.getY() - endDist));
                lineDrawProp.add(new FlatPoint(end.getX() + endDist, end.getY() - endDist));
            }
        } else if (mid.getY() < maxY) {
            double startDist = (start.getY() - mid.getY()) / 4.0;
            double endDist = (end.getY() - mid.getY()) / 4.0;
            if (start.getX() < end.getX()) {
                lineDrawProp.add(new FlatPoint(start.getX() - startDist, start.getY() - startDist));
                lineDrawProp.add(new FlatPoint(start.getX() - startDist, mid.getY()));
                lineDrawProp.add(mid);
                lineDrawProp.add(new FlatPoint(end.getX() + endDist, mid.getY()));
                lineDrawProp.add(new FlatPoint(end.getX() + endDist, end.getY() - endDist));
            } else {
                lineDrawProp.add(new FlatPoint(start.getX() + startDist, start.getY() - startDist));
                lineDrawProp.add(new FlatPoint(start.getX() + startDist, mid.getY()));
                lineDrawProp.add(mid);
                lineDrawProp.add(new FlatPoint(end.getX() - endDist, mid.getY()));
                lineDrawProp.add(new FlatPoint(end.getX() - endDist, end.getY() - endDist));
            }
        } else {
            double startDist = (mid.getY() - start.getY()) / 4.0;
            double endDist = (mid.getY() - end.getY()) / 4.0;
            if (start.getX() < end.getX()) {
                lineDrawProp.add(new FlatPoint(start.getX() - startDist, start.getY() + startDist));
                lineDrawProp.add(new FlatPoint(start.getX() - startDist, mid.getY()));
                lineDrawProp.add(mid);
                lineDrawProp.add(new FlatPoint(end.getX() + endDist, mid.getY()));
                lineDrawProp.add(new FlatPoint(end.getX() + endDist, end.getY() + endDist));
            } else {
                lineDrawProp.add(new FlatPoint(start.getX() + startDist, start.getY() + startDist));
                lineDrawProp.add(new FlatPoint(start.getX() + startDist, mid.getY()));
                lineDrawProp.add(mid);
                lineDrawProp.add(new FlatPoint(end.getX() - endDist, mid.getY()));
                lineDrawProp.add(new FlatPoint(end.getX() - endDist, end.getY() + endDist));
            }
        }
        lineDrawProp.add(end);
        if (lineDrawProp.size() == 2) {
            lineDrawProp.clear();
            return;
        }
        lineDrawProp.markIsBesselCurve();
    }

    private void parallelEdges(DLine parallelLine, int size, double distUnit, int no) {
        DNode from = (DNode)parallelLine.from();
        DNode to = (DNode)parallelLine.to();
        PortHelper.PortPoint fromPoint = PortHelper.getPortPoint(parallelLine.getLine(), from, this.drawGraph);
        PortHelper.PortPoint toPoint = PortHelper.getPortPoint(parallelLine.getLine(), to, this.drawGraph);
        double hypotenuseLen = this.hypotenuseLen(distUnit, no, size);
        Line iLine = parallelLine.getLine();
        Asserts.illegalArgument(iLine == null, "error parallel edge no");
        FlatPoint v2Center = Vectors.add(Vectors.multiple(Vectors.sub(fromPoint, toPoint), 0.75), toPoint);
        FlatPoint v3Center = Vectors.add(Vectors.multiple(Vectors.sub(fromPoint, toPoint), 0.25), toPoint);
        Curves.ThirdOrderBezierCurve curve = new Curves.ThirdOrderBezierCurve(fromPoint, this.newParallelControlPoint(parallelLine, size, no, hypotenuseLen, fromPoint, toPoint, v2Center), this.newParallelControlPoint(parallelLine, size, no, hypotenuseLen, fromPoint, toPoint, v3Center), toPoint);
        LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(parallelLine.getLine());
        lineDrawProp.clear();
        lineDrawProp.addAll((Collection<? extends FlatPoint>)this.thirdOrderBezierCurveToPoints(curve));
        lineDrawProp.markIsBesselCurve();
        lineDrawProp.setIsHeadStart(from.getNode());
        lineDrawProp.fakeInit();
    }

    private FlatPoint newParallelControlPoint(DLine line, int size, int no, double hypotenuseLen, FlatPoint f, FlatPoint t, FlatPoint v3Center) {
        return new FlatPoint(v3Center.getX() + this.xDist(f.getX(), f.getY(), t.getX(), t.getY(), hypotenuseLen, no, size / 2), v3Center.getY() + this.yDist(f.getX(), f.getY(), t.getX(), t.getY(), hypotenuseLen, no, size / 2, ((DNode)line.from()).getRank() == ((DNode)line.to()).getRank()));
    }

    private double hypotenuseLen(double unit, int segmentNum, int parallelEdgesNum) {
        if ((parallelEdgesNum & 1) == 1) {
            return Math.abs(unit * (double)(parallelEdgesNum - 1) / 2.0 - (double)(segmentNum - 1) * unit);
        }
        if (segmentNum <= parallelEdgesNum >> 1) {
            return unit * (double)segmentNum - unit / 2.0;
        }
        return Math.abs(unit * (double)segmentNum - (double)(parallelEdgesNum >> 1) * unit - unit / 2.0);
    }

    private double xDist(double startX, double startY, double endX, double endY, double hypotenuseLen, int segmentNum, int mid) {
        if (startY == endY) {
            return 0.0;
        }
        if (startX == endX) {
            return segmentNum <= mid ? -hypotenuseLen : hypotenuseLen;
        }
        double slop = (endY - startY) / (endX - startX);
        double xd = Math.sqrt(Math.pow(hypotenuseLen, 2.0) / (1.0 + 1.0 / Math.pow(slop, 2.0)));
        return segmentNum <= mid ? -xd : xd;
    }

    private double yDist(double startX, double startY, double endX, double endY, double hypotenuseLen, int segmentNum, int mid, boolean isSameRank) {
        if (startX == endX) {
            return 0.0;
        }
        if (startY == endY) {
            return segmentNum <= mid ? -hypotenuseLen : hypotenuseLen;
        }
        double slop = (endY - startY) / (endX - startX);
        double yd = Math.sqrt(Math.pow(hypotenuseLen, 2.0) / (1.0 + Math.pow(slop, 2.0)));
        if (isSameRank) {
            return segmentNum <= mid ? -yd : yd;
        }
        return segmentNum <= mid == slop < 0.0 ? -yd : yd;
    }

    static class InOutPointPair {
        private final int idx;
        private final boolean deleteBefore;
        private final FlatPoint in;
        private final FlatPoint out;

        public InOutPointPair(int idx, boolean deleteBefore, FlatPoint in, FlatPoint out) {
            this.idx = idx;
            this.deleteBefore = deleteBefore;
            this.in = in;
            this.out = out;
        }

        public int getIdx() {
            return this.idx;
        }

        public boolean isDeleteBefore() {
            return this.deleteBefore;
        }

        public FlatPoint getIn() {
            return this.in;
        }

        public FlatPoint getOut() {
            return this.out;
        }
    }

    public static abstract class AbstractDotLineRouterFactory<T extends AbstractDotLineRouter>
    implements DotLineRouter.DotLineRouterFactory<T> {
        @Override
        public T newInstance(DrawGraph drawGraph, DotDigraph dotDigraph, RankContent rankContent, EdgeDedigraph<DNode, DLine> digraphProxy) {
            Asserts.nullArgument(drawGraph, "drawGraph");
            Asserts.nullArgument(dotDigraph, "dotDigraph");
            Asserts.nullArgument(rankContent, "rankContent");
            Asserts.nullArgument(digraphProxy, "digraphProxy");
            T t = this.newInstance();
            Asserts.nullArgument(t, "DotLineRouter");
            ((AbstractDotLineRouter)t).drawGraph = drawGraph;
            ((AbstractDotLineRouter)t).dotDigraph = dotDigraph;
            ((AbstractDotLineRouter)t).rankContent = rankContent;
            ((AbstractDotLineRouter)t).digraphProxy = digraphProxy;
            return t;
        }

        protected abstract T newInstance();
    }
}

