/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.graphper.layout.Mark;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotDigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Acyclic
extends Mark<DNode> {
    private static final Logger log = LoggerFactory.getLogger(Acyclic.class);
    private final DotDigraph digraph;
    private Set<DNode> accessStack;

    Acyclic(DotDigraph digraph) {
        this.digraph = digraph;
        this.acyclic();
    }

    private void acyclic() {
        DLine line;
        while ((line = this.reverseLine()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Cycle line: {}", (Object)line);
            }
            if (Objects.equals(line.from(), line.to())) {
                this.digraph.removeEdge(line);
                if (line.isVirtual()) continue;
                ((DNode)line.from()).addSelfLine(line);
                continue;
            }
            this.digraph.reverseEdge(line);
        }
    }

    private DLine reverseLine() {
        if (this.accessStack == null) {
            this.accessStack = new HashSet<DNode>(this.digraph.vertexNum());
        } else {
            this.accessStack.clear();
        }
        this.clear();
        for (DNode v : this.digraph) {
            DLine line;
            if (this.isMark(v) || (line = this.dfs(v)) == null) continue;
            return line;
        }
        return null;
    }

    private DLine dfs(DNode v) {
        this.mark(v);
        this.accessStack.add(v);
        for (DLine line : this.digraph.adjacent(v)) {
            DLine l;
            DNode w = line.other(v);
            if (this.accessStack.contains(w)) {
                return line;
            }
            if (this.isMark(w) || (l = this.dfs(w)) == null) continue;
            return l;
        }
        this.accessStack.remove(v);
        return null;
    }
}

