/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.graphper.api.GraphContainer;
import org.graphper.layout.dot.CrossRank;
import org.graphper.layout.dot.DNode;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

class BasicCrossRank
implements CrossRank,
Cloneable {
    private int minRank = Integer.MAX_VALUE;
    private int maxRank = Integer.MIN_VALUE;
    protected Map<Integer, List<DNode>> rankNode = new HashMap<Integer, List<DNode>>();
    protected Map<DNode, Integer> nodeRankIndex = new HashMap<DNode, Integer>();
    protected final GraphContainer container;

    BasicCrossRank(GraphContainer container) {
        this.container = container;
    }

    @Override
    public int getRankIndex(DNode node) {
        Integer idx = this.nodeRankIndex.get(node);
        if (idx == null) {
            throw new NoSuchElementException();
        }
        return idx;
    }

    @Override
    public Integer safeGetRankIndex(DNode node) {
        return this.nodeRankIndex.get(node);
    }

    @Override
    public DNode getNode(int rank, int rankIdx) {
        List<DNode> nodes = this.rankNode.get(rank);
        if (CollectionUtils.isEmpty(nodes) || rankIdx < 0 || rankIdx >= nodes.size()) {
            return null;
        }
        return nodes.get(rankIdx);
    }

    @Override
    public void addNode(DNode node) {
        Asserts.nullArgument(node, "node");
        List<DNode> nodes = this.rankNode.get(node.getRank());
        if (nodes == null) {
            nodes = new ArrayList<DNode>(2);
            this.rankNode.put(node.getRank(), nodes);
            this.minRank = Math.min(this.minRank, node.getRank());
            this.maxRank = Math.max(this.maxRank, node.getRank());
        }
        this.nodeRankIndex.put(node, nodes.size());
        nodes.add(node);
    }

    @Override
    public int rankSize(int rank) {
        List<DNode> nodes = this.rankNode.get(rank);
        if (CollectionUtils.isEmpty(nodes)) {
            return 0;
        }
        return nodes.size();
    }

    @Override
    public int minRank() {
        return this.minRank;
    }

    @Override
    public int maxRank() {
        return this.maxRank;
    }

    @Override
    public void exchange(DNode v, DNode w) {
        Objects.requireNonNull(v);
        Objects.requireNonNull(w);
        if (v.getRank() != w.getRank()) {
            throw new IllegalArgumentException("Inconsistent hierarchy of vertices,only exchange vertices of the same hierarchy");
        }
        if (v == w) {
            return;
        }
        List<DNode> nodes = this.rankNode.get(v.getRank());
        if (CollectionUtils.isEmpty(nodes)) {
            throw new IndexOutOfBoundsException("rank index out of bounds");
        }
        int vi = this.getRankIndex(v);
        int wi = this.getRankIndex(w);
        nodes.set(vi, w);
        nodes.set(wi, v);
        this.nodeRankIndex.put(v, wi);
        this.nodeRankIndex.put(w, vi);
    }

    @Override
    public void sort(Comparator<DNode> comparator) {
        for (int i = this.minRank(); i <= this.maxRank(); ++i) {
            this.sort(i, comparator);
        }
    }

    @Override
    public void sort(int rank, Comparator<DNode> comparator) {
        List<DNode> nodes = this.rankNode.get(rank);
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        nodes.sort(comparator);
        for (int j = 0; j < nodes.size(); ++j) {
            this.nodeRankIndex.put(nodes.get(j), j);
        }
    }

    @Override
    public GraphContainer container() {
        return this.container;
    }

    protected BasicCrossRank clone() {
        BasicCrossRank basicCrossRank;
        try {
            basicCrossRank = (BasicCrossRank)super.clone();
            basicCrossRank.nodeRankIndex = new HashMap<DNode, Integer>(this.nodeRankIndex);
            basicCrossRank.rankNode = new HashMap<Integer, List<DNode>>(this.rankNode.size());
            for (Map.Entry<Integer, List<DNode>> entry : this.rankNode.entrySet()) {
                basicCrossRank.rankNode.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
        }
        catch (CloneNotSupportedException e) {
            return new BasicCrossRank(this.container);
        }
        return basicCrossRank;
    }
}

