/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.attributes.Port;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePosition;
import org.graphper.def.Curves;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.draw.DefaultShapePosition;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.layout.Cell;
import org.graphper.layout.FlatShifterStrategy;
import org.graphper.layout.dot.AbstractDotLineRouter;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.PortHelper;
import org.graphper.layout.dot.RankContent;
import org.graphper.layout.dot.RouterBox;
import org.graphper.util.CollectionUtils;
import org.graphper.util.ValueUtils;

abstract class BoxGuideLineRouter
extends AbstractDotLineRouter {
    private static final int PORT_ADAPT_LEN = 10;
    private static final int HALF_PORT_ADAPT_LEN = 5;

    BoxGuideLineRouter() {
    }

    @Override
    protected Object attach() {
        return new ArrayList();
    }

    @Override
    protected boolean nodeConsumer(DNode node, Object attach) {
        if (node.isVirtual()) {
            if (node.isLabelNode()) {
                this.lineLabelSet(node);
            } else if (node.isFlatLabelNode()) {
                this.flatLineLabelSet(node);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void lineConsumer(DLine line, Object attach) {
        List lineRouterBoxes = (List)attach;
        LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(line.getLine());
        if (CollectionUtils.isNotEmpty(lineDrawProp)) {
            return;
        }
        if (line.isSameRank()) {
            for (int i = 1; i <= line.getParallelNums(); ++i) {
                DLine edge = line.parallelLine(i - 1);
                this.addFlatEdgeBoxes(line, lineRouterBoxes, i);
                this.lineCompute(edge.getLine(), this.drawGraph.getLineDrawProp(edge.getLine()), lineRouterBoxes, (DNode)line.from(), (DNode)line.to());
                lineRouterBoxes.clear();
            }
        } else {
            DNode[] ports = new DNode[2];
            this.lineSegmentConsumer(line, l -> this.addBoxes((DLine)l, lineRouterBoxes, ports));
            if (ports[0] != null && ports[1] != null) {
                this.lineCompute(line.getLine(), lineDrawProp, lineRouterBoxes, ports[0], ports[1]);
                lineRouterBoxes.clear();
            }
        }
    }

    protected void lineDrawPropConnect(LineDrawProp lineDrawProp, List<FlatPoint> target, boolean before) {
        if (Objects.isNull(lineDrawProp) || CollectionUtils.isEmpty(target)) {
            return;
        }
        if (before) {
            if (CollectionUtils.isNotEmpty(lineDrawProp)) {
                target.remove(target.size() - 1);
            }
            for (int i = target.size() - 1; i >= 0; --i) {
                lineDrawProp.add(0, target.get(i));
            }
        } else {
            if (CollectionUtils.isNotEmpty(lineDrawProp)) {
                target.remove(0);
            }
            lineDrawProp.addAll((Collection<? extends FlatPoint>)target);
        }
    }

    @Override
    protected void handleSameEndpointParallelLines(List<DLine> parallelLines) {
        if (CollectionUtils.isEmpty(parallelLines)) {
            return;
        }
        DLine line = parallelLines.get(0);
        DNode from = (DNode)line.from();
        DNode to = (DNode)line.to();
        Port fromPort = PortHelper.getLineEndPointPort(from.getNode(), line.getLine(), this.drawGraph);
        Port toPort = PortHelper.getLineEndPointPort(to.getNode(), line.getLine(), this.drawGraph);
        if (fromPort == null && toPort == null || parallelLines.size() > 1) {
            this.symmetryParallelLine(parallelLines);
            return;
        }
        if (!Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("parallel.lines.case.distinction"))) {
            if (parallelLines.size() > 1) {
                this.symmetryParallelLine(parallelLines);
            }
            this.lineConsumer(parallelLines.get(0), new ArrayList());
            return;
        }
        FlatPoint fromPoint = PortHelper.getPortPoint(from, fromPort);
        FlatPoint toPoint = PortHelper.getPortPoint(to, toPort);
        double distUnit = (this.drawGraph.getGraphviz().graphAttrs().getNodeSep() + this.drawGraph.getGraphviz().graphAttrs().getRankSep() + FlatPoint.twoFlatPointDistance(fromPoint, toPoint)) / 20.0;
        List routerBoxes = (List)this.attach();
        if (line.isSameRank()) {
            RankContent.RankNode rankNode = this.rankContent.get(from.getRank());
            RankContent.RankNode pre = rankNode.pre();
            RankContent.RankNode next = rankNode.pre();
            double minY = pre != null ? pre.getEndY() : 2.0 * rankNode.getStartY() - rankNode.getEndY();
            double maxY = next != null ? next.getEndY() : 2.0 * rankNode.getEndY() - rankNode.getStartY();
            DefaultShapePosition sp = new DefaultShapePosition((fromPoint.getX() + toPoint.getX()) / 2.0, (fromPoint.getY() + toPoint.getY()) / 2.0, Math.max(from.getHeight(), to.getHeight()), Math.max(from.getWidth(), to.getWidth()), NodeShapeEnum.RECT);
            minY = Math.min(sp.getY() - sp.getHeight() * (double)parallelLines.size(), minY);
            maxY = Math.max(sp.getY() + sp.getHeight() * (double)parallelLines.size(), maxY);
            this.sameRankParallelLineDraw(sp, true, rankNode, minY, maxY, parallelLines);
        } else {
            RouterBox fromBox = this.newTwoNodeRangeBox(from);
            RouterBox toBox = this.newTwoNodeRangeBox(to);
            if (fromBox.getWidth() < distUnit * (double)parallelLines.size()) {
                fromBox.setLeftBorder((fromBox.getLeftBorder() + fromBox.getRightBorder()) / 2.0 - distUnit * (double)parallelLines.size() / 2.0);
                fromBox.setRightBorder((fromBox.getLeftBorder() + fromBox.getRightBorder()) / 2.0 + distUnit * (double)parallelLines.size() / 2.0);
            }
            if (toBox.getWidth() < distUnit * (double)parallelLines.size()) {
                toBox.setLeftBorder((toBox.getLeftBorder() + toBox.getRightBorder()) / 2.0 - distUnit * (double)parallelLines.size() / 2.0);
                toBox.setRightBorder((toBox.getLeftBorder() + toBox.getRightBorder()) / 2.0 + distUnit * (double)parallelLines.size() / 2.0);
            }
            double verHeight = Math.abs(fromBox.getDownBorder() - toBox.getUpBorder());
            double startY = fromBox.getDownBorder() + verHeight / 8.0;
            double endY = fromBox.getDownBorder() + verHeight * 7.0 / 8.0;
            double wall = (fromPoint.getX() + toPoint.getX()) / 2.0 - (double)(parallelLines.size() / 2) * distUnit - distUnit / 2.0;
            if (fromPort == Port.WEST) {
                wall -= 5.0;
            } else if (fromPort == Port.EAST) {
                wall += 5.0;
            }
            if (toPort == Port.WEST) {
                wall -= 5.0;
            } else if (toPort == Port.EAST) {
                wall += 5.0;
            }
            for (int i = 0; i < parallelLines.size(); ++i) {
                DLine parallelLine = parallelLines.get(i);
                Line edge = parallelLine.getLine();
                routerBoxes.add(fromBox);
                routerBoxes.add(new RouterBox(wall, wall + distUnit, startY, endY));
                routerBoxes.add(toBox);
                this.lineCompute(edge, this.drawGraph.getLineDrawProp(edge), routerBoxes, from, to);
                routerBoxes.clear();
                if (parallelLines.size() % 2 == 0 && i == parallelLines.size() / 2 - 1) {
                    wall += 2.0 * distUnit;
                    continue;
                }
                wall += distUnit;
            }
        }
    }

    protected abstract boolean curveLine();

    protected abstract void throughPointHandle(ThroughParam var1);

    private void sameRankParallelLineDraw(ShapePosition shapePosition, boolean isSameRank, RankContent.RankNode rank, double minY, double maxY, List<DLine> parallelLines) {
        if (CollectionUtils.isEmpty(parallelLines)) {
            return;
        }
        Double upBaseLine = null;
        Double downBaseLine = null;
        Double labelY = null;
        double itemsMinY = Double.MAX_VALUE;
        double itemsMaxY = -1.7976931348623157E308;
        Map<Line, LineDrawProp> lineDrawPropMap = this.drawGraph.getLineDrawPropMap();
        ArrayList<FlatParallelLineParam> flatParallelLineParams = new ArrayList<FlatParallelLineParam>(parallelLines.size());
        for (int j = 0; j < parallelLines.size(); ++j) {
            RouterBox routerBox;
            DLine line = parallelLines.get(j);
            DNode from = (DNode)line.from();
            DNode to = (DNode)line.to();
            from = from.getX() > to.getX() ? to : from;
            to = line.other(from);
            double leftMin = from.getX() - from.leftWidth();
            double leftMax = from.getX() + from.rightWidth() + from.getNodeSep() / 3.0;
            DNode pn = this.rankContent.rankPreNode(to);
            double rightMin = to.getX() - to.leftWidth() - (pn != null ? pn.getNodeSep() / 3.0 : 0.0);
            double rightMax = to.getX() + to.rightWidth();
            RouterBox left = new RouterBox(leftMin, leftMax, minY, maxY, from);
            RouterBox right = new RouterBox(rightMin, rightMax, minY, maxY, to);
            ArrayList<RouterBox> lineRouterBoxes = new ArrayList<RouterBox>();
            lineRouterBoxes.add(left);
            lineRouterBoxes.add(right);
            LineDrawProp lineDrawProp = lineDrawPropMap.get(line.getLine());
            if (!lineDrawProp.isEmpty()) {
                lineDrawProp.clear();
            }
            FlatPoint labelSize = line.getLabelSize();
            boolean alternateDraw = isSameRank;
            Boolean upDirect = null;
            if (alternateDraw) {
                Port fromPort = PortHelper.getLineEndPointPort(from.getNode(), line.getLine(), this.drawGraph);
                Port toPort = PortHelper.getLineEndPointPort(to.getNode(), line.getLine(), this.drawGraph);
                FlatPoint fromPoint = PortHelper.getPortPoint(from, fromPort);
                FlatPoint toPoint = PortHelper.getPortPoint(to, toPort);
                upDirect = fromPoint.getY() - shapePosition.getY() + toPoint.getY() - to.getY() <= 0.0;
                boolean bl = fromPort == null || toPort == null || fromPort == Port.EAST && toPort == Port.WEST || fromPoint.getY() - from.getY() < 0.0 != toPoint.getY() - to.getY() < 0.0 ? true : (alternateDraw = false);
            }
            if (alternateDraw) {
                if (j % 2 == 0) {
                    if (upBaseLine == null) {
                        upBaseLine = shapePosition.getY();
                    }
                    routerBox = new RouterBox(leftMax, rightMin, upBaseLine - (labelSize != null ? labelSize.getX() : 10.0), upBaseLine);
                    upBaseLine = routerBox.getUpBorder();
                    if (labelSize != null) {
                        labelY = routerBox.getDownBorder() - labelSize.getX() / 2.0;
                    }
                } else {
                    if (downBaseLine == null) {
                        downBaseLine = shapePosition.getY();
                    }
                    downBaseLine = downBaseLine + (labelSize != null ? labelSize.getX() : 10.0);
                    routerBox = new RouterBox(leftMax, rightMin, downBaseLine, downBaseLine + (labelSize != null ? labelSize.getX() : 10.0));
                    if (labelSize != null) {
                        labelY = routerBox.getUpBorder() - labelSize.getX() / 2.0;
                    }
                }
            } else {
                if (j % 2 == 0) {
                    if (upBaseLine == null) {
                        upBaseLine = upDirect == null ? Double.valueOf(shapePosition.getY()) : (Objects.equals(upDirect, Boolean.TRUE) ? Double.valueOf(shapePosition.getY() - shapePosition.getHeight() - 10.0 - 10.0) : Double.valueOf(from.getY() + shapePosition.getHeight() + 10.0 + 10.0));
                    }
                    routerBox = new RouterBox(leftMax, rightMin, upBaseLine - (labelSize != null ? labelSize.getX() : 10.0), upBaseLine);
                    upBaseLine = upBaseLine - (labelSize != null ? labelSize.getX() : 10.0);
                } else {
                    if (downBaseLine == null) {
                        downBaseLine = upDirect == null ? Double.valueOf(shapePosition.getY()) : (Objects.equals(upDirect, Boolean.TRUE) ? Double.valueOf(shapePosition.getY() - shapePosition.getHeight() - 10.0 - 10.0) : Double.valueOf(from.getY() + shapePosition.getHeight() + 10.0 + 10.0));
                    }
                    double p = downBaseLine;
                    downBaseLine = downBaseLine + (labelSize != null ? labelSize.getX() : 10.0);
                    routerBox = new RouterBox(leftMax, rightMin, p, downBaseLine);
                }
                if (labelSize != null) {
                    labelY = routerBox.getDownBorder() - labelSize.getX() / 2.0;
                }
            }
            if (j % 2 == 0) {
                itemsMinY = Math.min(itemsMinY, routerBox.getDownBorder());
                itemsMaxY = Math.max(itemsMaxY, routerBox.getDownBorder());
            } else {
                itemsMinY = Math.min(itemsMinY, routerBox.getUpBorder());
                itemsMaxY = Math.max(itemsMaxY, routerBox.getUpBorder());
            }
            if (labelSize != null && labelY != null) {
                itemsMinY = Math.min(itemsMinY, labelY - labelSize.getHeight() / 2.0);
                itemsMaxY = Math.max(itemsMaxY, labelY + labelSize.getHeight() / 2.0);
            }
            lineRouterBoxes.add(lineRouterBoxes.size() - 1, routerBox);
            if (labelY != null) {
                lineDrawProp.setLabelCenter(new FlatPoint(shapePosition.getX(), labelY));
                labelY = null;
            }
            lineDrawProp.clear();
            flatParallelLineParams.add(new FlatParallelLineParam(from, to, lineDrawProp, lineRouterBoxes));
        }
        for (FlatParallelLineParam parallelLineParam : flatParallelLineParams) {
            LineAttrs lineAttrs = parallelLineParam.line.lineAttrs();
            if (!this.havePort(lineAttrs) && (itemsMinY < rank.getStartY() || itemsMaxY > rank.getEndY())) {
                double offset = rank.getStartY() - itemsMinY;
                FlatShifterStrategy shifter = new FlatShifterStrategy(0.0, offset);
                for (RouterBox routerBox : parallelLineParam.routerBoxes) {
                    shifter.moveBox(routerBox);
                }
                shifter.movePoint(parallelLineParam.line.getLabelCenter());
            }
            this.drawGraph.updateYAxisRange(itemsMinY);
            this.drawGraph.updateYAxisRange(itemsMaxY);
            this.lineCompute(parallelLineParam.line.getLine(), parallelLineParam.line, parallelLineParam.routerBoxes, parallelLineParam.from, parallelLineParam.to);
        }
    }

    private boolean havePort(LineAttrs lineAttrs) {
        return lineAttrs.getTailPort() != null || lineAttrs.getHeadPort() != null;
    }

    private void lineLabelSet(DNode node) {
        Line line = node.getLabelLine();
        LineDrawProp lineDrawProp = this.drawGraph.getLineDrawProp(line);
        if (lineDrawProp == null) {
            return;
        }
        lineDrawProp.setLabelCenter(new FlatPoint(node.getX() + node.getWidth() / 2.0, node.getY()));
    }

    private void flatLineLabelSet(DNode node) {
        DLine flatLabelLine = node.getFlatLabelLine();
        Map<Line, LineDrawProp> lineDrawPropMap = this.drawGraph.getLineDrawPropMap();
        if (lineDrawPropMap == null) {
            return;
        }
        RankContent.RankNode rankNode = this.rankContent.get(node.getRank());
        RankContent.RankNode pre = rankNode.pre();
        RankContent.RankNode next = rankNode.next();
        double minY = pre != null ? pre.getEndY() : 2.0 * rankNode.getStartY() - rankNode.getEndY();
        double maxY = next != null ? next.getEndY() : 2.0 * rankNode.getEndY() - rankNode.getStartY();
        minY = Math.min(node.getY() - node.getHeight() * (double)flatLabelLine.getParallelNums(), minY);
        maxY = Math.max(node.getY() + node.getHeight() * (double)flatLabelLine.getParallelNums(), maxY);
        Map<Integer, List<DLine>> parallelLineRecordMap = this.groupParallelLineByEndpoint(flatLabelLine);
        for (Map.Entry<Integer, List<DLine>> entry : parallelLineRecordMap.entrySet()) {
            DNode from = (DNode)flatLabelLine.from();
            this.sameRankParallelLineDraw(node, node.getRank() == from.getRank(), rankNode, minY, maxY, entry.getValue());
        }
    }

    private void addBoxes(DLine line, List<RouterBox> lineRouterBoxes, DNode[] ports) {
        DNode from = (DNode)line.from();
        DNode to = (DNode)line.to();
        if (!from.isVirtual()) {
            ports[0] = from;
            lineRouterBoxes.add(this.newTwoNodeRangeBox(from));
        }
        if (!to.isVirtual()) {
            ports[1] = to;
        }
        RankContent.RankNode rankNode = this.rankContent.get(from.getRank());
        this.addRankBox(rankNode, lineRouterBoxes);
        lineRouterBoxes.add(this.newTwoNodeRangeBox(to));
    }

    private void addFlatEdgeBoxes(DLine line, List<RouterBox> lineRouterBoxes, int no) {
        if (this.isAdj((DNode)line.from(), (DNode)line.to())) {
            lineRouterBoxes.add(this.newTwoNodeRangeBox((DNode)line.from()));
            lineRouterBoxes.add(this.newTwoNodeRangeBox((DNode)line.to()));
            return;
        }
        RankContent.RankNode rankNode = this.rankContent.get(((DNode)line.from()).getRank());
        RankContent.RankNode pre = this.preNotOnlyLabelRankNode(rankNode);
        RankContent.RankNode next = rankNode.next();
        this.flatLineBoxes(line, lineRouterBoxes, rankNode, pre, next, no);
    }

    private void flatLineBoxes(DLine line, List<RouterBox> lineRouterBoxes, RankContent.RankNode rankNode, RankContent.RankNode pre, RankContent.RankNode next, int lineNo) {
        double minY = pre != null ? pre.getEndY() : 2.0 * rankNode.getStartY() - rankNode.getEndY();
        double maxY = next != null ? next.getStartY() : 2.0 * rankNode.getEndY() - rankNode.getStartY();
        double maxHeight = pre != null ? rankNode.getStartY() - pre.getEndY() : rankNode.getRankSep();
        double nodeSep = this.drawGraph.getGraphviz().graphAttrs().getNodeSep();
        DNode start = ((DNode)line.from()).getRankIndex() < ((DNode)line.to()).getRankIndex() ? (DNode)line.from() : (DNode)line.to();
        DNode end = line.other(start);
        lineRouterBoxes.add(new RouterBox(start.getX() - start.leftWidth(), start.getX() + start.rightWidth() + nodeSep, minY, maxY, start));
        lineRouterBoxes.add(new RouterBox(start.getX() + start.rightWidth() + nodeSep, end.getX() - end.leftWidth() - nodeSep, rankNode.getStartY() - maxHeight, rankNode.getStartY() - maxHeight + maxHeight * (double)lineNo / (double)(line.getParallelNums() + 1)));
        lineRouterBoxes.add(new RouterBox(end.getX() - end.leftWidth() - nodeSep, end.getX() + end.rightWidth(), minY, maxY, end));
    }

    private RankContent.RankNode preNotOnlyLabelRankNode(RankContent.RankNode rankNode) {
        RankContent.RankNode pre;
        do {
            rankNode = pre = rankNode.pre();
        } while (pre != null && pre.noNormalNode());
        return pre;
    }

    private void lineCompute(Line line, LineDrawProp lineDrawProp, List<RouterBox> lineRouterBoxes, DNode from, DNode to) {
        if (CollectionUtils.isEmpty(lineRouterBoxes) || CollectionUtils.isNotEmpty(lineDrawProp)) {
            return;
        }
        List<RouterBox> originRouterBoxes = this.splitPortBox(from.getRank() != to.getRank(), lineDrawProp, lineRouterBoxes);
        ArrayList<ThroughPoint> throughPoints = null;
        RouterBox pre = null;
        Integer preIdx = null;
        for (int i = 0; i < lineRouterBoxes.size(); ++i) {
            RouterBox routerBox = lineRouterBoxes.get(i);
            DNode node = routerBox.getNode();
            if (node == null) continue;
            if (pre == null) {
                lineDrawProp.setIsHeadStart(node.getNode());
            }
            if (pre != null) {
                DNode preNode = pre.getNode();
                ThroughPoint start = this.getLineEndPoint(preNode, line, preIdx);
                ThroughPoint end = this.getLineEndPoint(node, line, i);
                if (throughPoints == null) {
                    throughPoints = new ArrayList();
                }
                throughPoints.add(start);
                if (end.getY() > start.getY()) {
                    double x;
                    if (preIdx == 0) {
                        x = Vectors.linerFuncGetX(start, end, pre.getDownBorder());
                        if (x > pre.getLeftBorder() && x < start.getX()) {
                            pre.setLeftBorder(x - 10.0);
                        } else if (x < pre.getRightBorder() && x > start.getX()) {
                            pre.setRightBorder(x + 10.0);
                        }
                    } else if (i == lineRouterBoxes.size() - 1) {
                        x = Vectors.linerFuncGetX(start, end, routerBox.getUpBorder());
                        if (x > routerBox.getLeftBorder() && x < end.getX()) {
                            routerBox.setLeftBorder(x - 10.0);
                        } else if (x < routerBox.getRightBorder() && x > end.getX()) {
                            routerBox.setRightBorder(x + 10.0);
                        }
                    }
                }
                this.throughPointCompute(throughPoints, lineRouterBoxes, preIdx, i, throughPoints.size(), start, end, from.getRank() != to.getRank());
            }
            pre = routerBox;
            preIdx = i;
        }
        RouterBox routerBox = lineRouterBoxes.get(lineRouterBoxes.size() - 1);
        DNode node = routerBox.getNode();
        if (node != null) {
            ThroughPoint end = this.getLineEndPoint(node, line, lineRouterBoxes.size() - 1);
            if (throughPoints == null) {
                throughPoints = new ArrayList<ThroughPoint>();
            }
            throughPoints.add(end);
        }
        if (Objects.equals(lineDrawProp.lineAttrs().getShowboxes(), Boolean.TRUE)) {
            lineDrawProp.setBoxes(new ArrayList<RouterBox>(lineRouterBoxes));
        }
        if (CollectionUtils.isNotEmpty(throughPoints)) {
            ThroughParam throughParam = new ThroughParam();
            throughParam.line = line;
            throughParam.lineRouterBoxes = lineRouterBoxes;
            throughParam.lineDrawProp = lineDrawProp;
            throughParam.from = from;
            throughParam.to = to;
            throughParam.throughPoints = throughPoints;
            boolean bl = throughParam.isHorizontal = from.getRank() == to.getRank();
            if (CollectionUtils.isNotEmpty(originRouterBoxes)) {
                int startIdx = 0;
                int endIdx = throughPoints.size() - 1;
                for (RouterBox originRouterBox : originRouterBoxes) {
                    Curves.MultiBezierCurve curves;
                    int i;
                    if (originRouterBox.getNode() == from) {
                        for (i = 0; i < throughPoints.size() && originRouterBox.in((FlatPoint)throughPoints.get(i)); ++i) {
                        }
                        if (i <= 1) continue;
                        if (this.curveLine()) {
                            FlatPoint rightTangent = null;
                            if (i < throughPoints.size()) {
                                rightTangent = Vectors.sub((FlatPoint)throughPoints.get(i - 1), (FlatPoint)throughPoints.get(i));
                            }
                            curves = Curves.fitCurves(throughPoints.subList(0, i), null, rightTangent, 0.0);
                            throughParam.fromPortPoints = this.multiBezierCurveToPoints(curves);
                        } else {
                            throughParam.fromPortPoints = new ArrayList<FlatPoint>(i);
                            throughParam.fromPortPoints.addAll(throughPoints.subList(0, i));
                        }
                        startIdx = i - 1;
                        continue;
                    }
                    for (i = throughPoints.size() - 1; i >= 0 && originRouterBox.in((FlatPoint)throughPoints.get(i)); --i) {
                    }
                    if (i >= throughPoints.size() - 2) continue;
                    if (this.curveLine()) {
                        FlatPoint leftTangent = null;
                        if (i >= 0) {
                            leftTangent = Vectors.sub((FlatPoint)throughPoints.get(i + 1), (FlatPoint)throughPoints.get(i));
                        }
                        curves = Curves.fitCurves(throughPoints.subList(i + 1, throughPoints.size()), leftTangent, null, 0.0);
                        throughParam.toPortPoints = this.multiBezierCurveToPoints(curves);
                    } else {
                        i = Math.max(i, 0);
                        throughParam.toPortPoints = new ArrayList<FlatPoint>(i);
                        throughParam.toPortPoints.addAll(throughPoints.subList(i, throughPoints.size()));
                    }
                    endIdx = i + 1;
                }
                if (startIdx != 0 || endIdx != throughPoints.size() - 1) {
                    throughParam.throughPoints = throughPoints.subList(startIdx, endIdx + 1);
                }
            }
            this.throughPointHandle(throughParam);
        }
    }

    private int throughPointCompute(List<ThroughPoint> throughPoints, List<RouterBox> lineRouterBoxes, int boxStartIndex, int boxEndIndex, int insertIndex, FlatPoint start, FlatPoint end, boolean vertical) {
        if (vertical && start.getY() == end.getY() || !vertical && start.getX() == end.getX()) {
            return 0;
        }
        Integer splitIndex = null;
        double fastDistance = -1.7976931348623157E308;
        Double fastX = null;
        Double fastY = null;
        for (int i = boxStartIndex; i <= boxEndIndex; ++i) {
            double wall;
            double dis;
            boolean p2In;
            boolean p1In;
            double p2;
            double p1;
            RouterBox routerBox = lineRouterBoxes.get(i);
            if (vertical) {
                p1 = Vectors.linerFuncGetX(start.getX(), start.getY(), end.getX(), end.getY(), routerBox.getUpBorder());
                p2 = Vectors.linerFuncGetX(start.getX(), start.getY(), end.getX(), end.getY(), routerBox.getDownBorder());
                p1In = routerBox.inXRange(p1 - 1.0) || routerBox.inXRange(p1 + 1.0) || routerBox.getUpBorder() < start.getY();
                p2In = routerBox.inXRange(p2 - 1.0) || routerBox.inXRange(p2 + 1.0) || routerBox.getDownBorder() > end.getY();
            } else {
                p1 = Vectors.linerFuncGetY(start.getX(), start.getY(), end.getX(), end.getY(), routerBox.getLeftBorder());
                p2 = Vectors.linerFuncGetY(start.getX(), start.getY(), end.getX(), end.getY(), routerBox.getRightBorder());
                p1In = routerBox.inYRange(p1 - 1.0) || routerBox.inYRange(p1 + 1.0) || routerBox.getLeftBorder() < start.getX();
                boolean bl = p2In = routerBox.inYRange(p2 - 1.0) || routerBox.inYRange(p2 + 1.0) || routerBox.getRightBorder() > end.getX();
            }
            if (p1In && p2In) continue;
            if (!p1In && fastDistance < (dis = Math.abs((wall = vertical ? routerBox.closerVerWall(p1) : routerBox.closerHorWall(p1)) - p1))) {
                fastDistance = dis;
                splitIndex = Math.max(i - 1, boxStartIndex);
                if (vertical) {
                    fastX = wall;
                    fastY = routerBox.getUpBorder();
                } else {
                    fastX = routerBox.getLeftBorder();
                    fastY = wall;
                }
            }
            if (p2In || !(fastDistance < (dis = Math.abs((wall = vertical ? routerBox.closerVerWall(p2) : routerBox.closerHorWall(p2)) - p2)))) continue;
            fastDistance = dis;
            splitIndex = i;
            if (vertical) {
                fastX = wall;
                fastY = routerBox.getDownBorder();
                continue;
            }
            fastX = routerBox.getRightBorder();
            fastY = wall;
        }
        if (splitIndex == null) {
            return 0;
        }
        ThroughPoint splitPoint = new ThroughPoint(fastX, fastY, splitIndex);
        throughPoints.add(insertIndex, splitPoint);
        int a = this.throughPointCompute(throughPoints, lineRouterBoxes, boxStartIndex, splitIndex, insertIndex, start, splitPoint, vertical);
        int b = this.throughPointCompute(throughPoints, lineRouterBoxes, splitIndex + 1, boxEndIndex, insertIndex + a + 1, splitPoint, end, vertical);
        return a + b + 1;
    }

    private RouterBox newTwoNodeRangeBox(DNode node) {
        double rightWall;
        double leftWall;
        DNode pre = this.adjIgnoreHaveCrossVirtualNode(node, this.rankContent::rankPreNode);
        DNode next = this.adjIgnoreHaveCrossVirtualNode(node, this.rankContent::rankNextNode);
        RankContent.RankNode rankNode = this.rankContent.get(node.getRank());
        double d = leftWall = pre != null ? pre.getX() + pre.rightWidth() + pre.getNodeSep() / 2.0 : this.drawGraph.getMinX();
        if (node.isLabelNode()) {
            rightWall = node.getX() - node.leftWidth() + 10.0;
        } else {
            rightWall = next != null ? next.getX() - next.leftWidth() - node.getNodeSep() / 2.0 : leftWall + this.drawGraph.width();
            rightWall = Math.max(rightWall, node.getX() + node.rightWidth());
        }
        leftWall = Math.min(leftWall, node.getX() - node.leftWidth());
        return new RouterBox(leftWall - 2.0, rightWall + 2.0, rankNode.getStartY() - 2.0, rankNode.getEndY() + 2.0, node);
    }

    private void addRankBox(RankContent.RankNode rankNode, List<RouterBox> routerBoxes) {
        RankContent.RankNode next = rankNode.next();
        if (next == null) {
            return;
        }
        routerBoxes.add(new RouterBox(this.drawGraph.getMinX(), this.drawGraph.getMaxX(), rankNode.getEndY(), next.getStartY()));
    }

    private DNode adjIgnoreHaveCrossVirtualNode(DNode current, UnaryOperator<DNode> adjFunc) {
        DLine dLine;
        DNode next = (DNode)adjFunc.apply(current);
        if (next == null || !next.isVirtual() || next.isLabelNode()) {
            return next;
        }
        DLine l1 = null;
        DLine l2 = null;
        Iterator iterator = this.digraphProxy.inAdjacent(current).iterator();
        while (iterator.hasNext()) {
            l1 = dLine = (DLine)iterator.next();
        }
        iterator = this.digraphProxy.inAdjacent(next).iterator();
        while (iterator.hasNext()) {
            l2 = dLine = (DLine)iterator.next();
        }
        if (this.lineIsCross(l1, l2)) {
            return (DNode)adjFunc.apply(next);
        }
        iterator = this.digraphProxy.outAdjacent(current).iterator();
        while (iterator.hasNext()) {
            l1 = dLine = (DLine)iterator.next();
        }
        iterator = this.digraphProxy.outAdjacent(next).iterator();
        while (iterator.hasNext()) {
            l2 = dLine = (DLine)iterator.next();
        }
        if (this.lineIsCross(l1, l2)) {
            return (DNode)adjFunc.apply(next);
        }
        return next;
    }

    private List<RouterBox> splitPortBox(boolean vertical, LineDrawProp lineProp, List<RouterBox> routerBoxes) {
        RouterBox routerBox;
        if (CollectionUtils.isEmpty(routerBoxes) || routerBoxes.size() < 2) {
            return Collections.emptyList();
        }
        boolean firstSplit = false;
        boolean lastSplit = false;
        RouterBox firstRouterBox = routerBoxes.get(0);
        RouterBox lastRouterBox = routerBoxes.get(routerBoxes.size() - 1);
        List<RouterBox> splitRouterBoxes = this.splitPortBox(firstRouterBox, lineProp, vertical, true);
        if (CollectionUtils.isNotEmpty(splitRouterBoxes)) {
            routerBoxes.remove(0);
            for (int i = splitRouterBoxes.size() - 1; i >= 0; --i) {
                routerBoxes.add(0, splitRouterBoxes.get(i));
            }
            firstSplit = true;
        }
        if (CollectionUtils.isNotEmpty(splitRouterBoxes = this.splitPortBox(lastRouterBox, lineProp, vertical, false))) {
            routerBoxes.remove(routerBoxes.size() - 1);
            routerBoxes.addAll(splitRouterBoxes);
            lastSplit = true;
        }
        if (CollectionUtils.isEmpty(routerBoxes)) {
            return Collections.emptyList();
        }
        do {
            if ((routerBox = routerBoxes.get(0)).getNode() != null) continue;
            routerBoxes.remove(0);
        } while (routerBox.getNode() == null);
        do {
            if ((routerBox = routerBoxes.get(routerBoxes.size() - 1)).getNode() != null) continue;
            routerBoxes.remove(routerBoxes.size() - 1);
        } while (routerBox.getNode() == null);
        if (firstSplit && lastSplit) {
            return Arrays.asList(firstRouterBox, lastRouterBox);
        }
        if (firstSplit) {
            return Collections.singletonList(firstRouterBox);
        }
        if (lastSplit) {
            return Collections.singletonList(lastRouterBox);
        }
        return Collections.emptyList();
    }

    private List<RouterBox> splitPortBox(RouterBox routerBox, LineDrawProp lineProp, boolean vertical, boolean lowPos) {
        DNode node = routerBox.getNode();
        if (node == null) {
            return Collections.emptyList();
        }
        Port port = PortHelper.getLineEndPointPort(node.getNode(), lineProp.getLine(), this.drawGraph);
        if (port == null) {
            return Collections.emptyList();
        }
        PortHelper.PortPoint point = PortHelper.getPortPointWithoutClip(lineProp.getLine(), node, this.drawGraph);
        if (!routerBox.in(point)) {
            return Collections.emptyList();
        }
        if (!this.pointLocateAtBorder(point, node)) {
            Box cellBox = node;
            NodeDrawProp nodeProp = this.drawGraph.getNodeDrawProp(node.getNode());
            Cell cell = nodeProp.getCell();
            String cellId = PortHelper.getCellId(lineProp.getLine(), node, lineProp);
            if (cell != null && (cell = ((Cell.RootCell)cell).getCellById(cellId)) != null) {
                cellBox = cell.getCellBox(node);
            }
            return this.verticalCellBoxSplit(vertical, point, node, cellBox, routerBox);
        }
        RouterBox routerBox1 = null;
        RouterBox routerBox2 = null;
        if (vertical) {
            if (lowPos) {
                if (!ValueUtils.approximate(point.getY(), node.getDownBorder(), 1.0)) {
                    routerBox1 = new RouterBox(routerBox.getLeftBorder(), routerBox.getRightBorder(), routerBox.getUpBorder(), point.getY(), node);
                    if (point.getX() < node.getX()) {
                        double left = node.getLeftBorder();
                        routerBox2 = new RouterBox(routerBox.getLeftBorder(), left - Math.min(10.0, left - routerBox.getLeftBorder()), point.getY(), routerBox.getDownBorder());
                    } else {
                        double right = node.getRightBorder();
                        routerBox2 = new RouterBox(right + Math.min(10.0, routerBox.getRightBorder() - right), routerBox.getRightBorder(), point.getY(), routerBox.getDownBorder());
                    }
                }
            } else if (!ValueUtils.approximate(point.getY(), node.getUpBorder(), 1.0)) {
                if (point.getX() < node.getX()) {
                    double left = node.getX() - node.realLeftWidth();
                    routerBox1 = new RouterBox(routerBox.getLeftBorder(), left - Math.min(10.0, left - routerBox.getLeftBorder()), routerBox.getUpBorder(), point.getY());
                } else {
                    double right = node.getX() + node.realRightWidth();
                    routerBox1 = new RouterBox(right + Math.min(10.0, routerBox.getRightBorder() - right), routerBox.getRightBorder(), routerBox.getUpBorder(), point.getY());
                }
                routerBox2 = new RouterBox(routerBox.getLeftBorder(), routerBox.getRightBorder(), point.getY(), routerBox.getDownBorder(), node);
            }
        } else if (point.getY() <= node.getY()) {
            double top = node.getUpBorder();
            if (point.getX() < node.getX()) {
                routerBox1 = new RouterBox(routerBox.getLeftBorder(), point.getX(), routerBox.getUpBorder(), routerBox.getDownBorder(), node);
                routerBox2 = new RouterBox(point.getX(), routerBox.getRightBorder(), routerBox.getUpBorder(), top - Math.min(10.0, top - routerBox.getUpBorder()));
            } else {
                routerBox1 = new RouterBox(routerBox.getLeftBorder(), point.getX(), routerBox.getUpBorder(), top - Math.min(10.0, top - routerBox.getUpBorder()));
                routerBox2 = new RouterBox(point.getX(), routerBox.getRightBorder(), routerBox.getUpBorder(), routerBox.getDownBorder(), node);
            }
        } else {
            double bottom = node.getDownBorder();
            if (point.getX() < node.getX()) {
                routerBox1 = new RouterBox(routerBox.getLeftBorder(), point.getX(), point.getY(), routerBox.getDownBorder(), node);
                routerBox2 = new RouterBox(point.getX(), routerBox.getRightBorder(), bottom + Math.min(10.0, routerBox.getDownBorder() - bottom), routerBox.getDownBorder());
            } else {
                routerBox1 = new RouterBox(routerBox.getLeftBorder(), point.getX(), bottom + Math.min(10.0, routerBox.getDownBorder() - bottom), routerBox.getDownBorder());
                routerBox2 = new RouterBox(point.getX(), routerBox.getRightBorder(), point.getY(), routerBox.getDownBorder(), node);
            }
        }
        if (routerBox1 == null || routerBox2 == null) {
            return Collections.emptyList();
        }
        routerBox1.minGuarantee(5.0, 5.0);
        routerBox2.minGuarantee(5.0, 5.0);
        return Arrays.asList(routerBox1, routerBox2);
    }

    private List<RouterBox> verticalCellBoxSplit(boolean vertical, FlatPoint point, DNode node, Box cellBox, RouterBox routerBox) {
        RouterBox routerBox1 = null;
        RouterBox routerBox2 = null;
        if (point.getY() < cellBox.getY()) {
            if (vertical) {
                routerBox1 = new RouterBox(routerBox.getLeftBorder(), routerBox.getRightBorder(), routerBox.getUpBorder(), point.getY(), node);
                if (point.getX() < cellBox.getX()) {
                    double left = cellBox.getLeftBorder();
                    routerBox2 = new RouterBox(routerBox.getLeftBorder(), left - Math.min(10.0, left - routerBox.getLeftBorder()), point.getY(), routerBox.getDownBorder());
                } else {
                    double right = cellBox.getRightBorder();
                    routerBox2 = new RouterBox(right + Math.min(10.0, routerBox.getRightBorder() - right), routerBox.getRightBorder(), point.getY(), routerBox.getDownBorder());
                }
            }
        } else if (vertical) {
            if (point.getX() < cellBox.getX()) {
                double left = cellBox.getX() - node.realLeftWidth();
                routerBox1 = new RouterBox(routerBox.getLeftBorder(), left - Math.min(10.0, left - routerBox.getLeftBorder()), routerBox.getUpBorder(), point.getY());
            } else {
                double right = cellBox.getX() + node.realRightWidth();
                routerBox1 = new RouterBox(right + Math.min(10.0, routerBox.getRightBorder() - right), routerBox.getRightBorder(), routerBox.getUpBorder(), point.getY());
            }
            routerBox2 = new RouterBox(routerBox.getLeftBorder(), routerBox.getRightBorder(), point.getY(), routerBox.getDownBorder(), node);
        }
        if (routerBox1 == null || routerBox2 == null) {
            return Collections.emptyList();
        }
        routerBox1.minGuarantee(5.0, 5.0);
        routerBox2.minGuarantee(5.0, 5.0);
        return Arrays.asList(routerBox1, routerBox2);
    }

    private boolean pointLocateAtBorder(FlatPoint point, DNode node) {
        return ValueUtils.approximate(point.getX(), node.getLeftBorder(), 1.0) || ValueUtils.approximate(point.getX(), node.getRightBorder(), 1.0) || ValueUtils.approximate(point.getY(), node.getUpBorder(), 1.0) || ValueUtils.approximate(point.getY(), node.getDownBorder(), 1.0);
    }

    private ThroughPoint getLineEndPoint(DNode n, Line line, int boxIdx) {
        if (n.isVirtual()) {
            return new ThroughPoint(n.getX(), n.getY(), boxIdx);
        }
        PortHelper.PortPoint point = PortHelper.getPortPoint(line, n, this.drawGraph);
        return new ThroughPoint(point.getX(), point.getY(), boxIdx);
    }

    private boolean lineIsCross(DLine l1, DLine l2) {
        if (l1 == null || l2 == null || ((DNode)l1.from()).getX() == ((DNode)l2.from()).getX() || ((DNode)l1.to()).getX() == ((DNode)l2.to()).getX()) {
            return false;
        }
        return ((DNode)l1.from()).getX() < ((DNode)l2.from()).getX() != ((DNode)l1.to()).getX() < ((DNode)l2.to()).getX();
    }

    private static class FlatParallelLineParam {
        private final DNode from;
        private final DNode to;
        private final LineDrawProp line;
        private final List<RouterBox> routerBoxes;

        public FlatParallelLineParam(DNode from, DNode to, LineDrawProp line, List<RouterBox> routerBoxes) {
            this.from = from;
            this.to = to;
            this.line = line;
            this.routerBoxes = routerBoxes;
        }
    }

    protected static class ThroughParam {
        public Line line;
        public DNode from;
        public DNode to;
        public LineDrawProp lineDrawProp;
        public List<ThroughPoint> throughPoints;
        public List<RouterBox> lineRouterBoxes;
        public boolean isHorizontal;
        public List<FlatPoint> fromPortPoints;
        public List<FlatPoint> toPortPoints;

        protected ThroughParam() {
        }
    }

    protected static class ThroughPoint
    extends FlatPoint {
        private static final long serialVersionUID = -7915192924199950140L;
        private final int boxIndex;

        public ThroughPoint(FlatPoint flatPoint) {
            this(flatPoint.getX(), flatPoint.getY(), -1);
        }

        public ThroughPoint(double x, double y, int boxIndex) {
            super(x, y);
            this.boxIndex = boxIndex;
        }

        public int getBoxIndex() {
            return this.boxIndex;
        }
    }
}

