/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.graphper.api.Cluster;
import org.graphper.api.GraphAttrs;
import org.graphper.api.GraphContainer;
import org.graphper.api.Graphviz;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.draw.DrawGraph;
import org.graphper.layout.dot.Acyclic;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotAttachment;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.FeasibleTree;
import org.graphper.layout.dot.NetworkSimplex;
import org.graphper.layout.dot.RankContent;
import org.graphper.layout.dot.SubgraphMerge;

class ContainerCollapse {
    private final DotAttachment dotAttachment;
    private final GraphContainer graphContainer;
    private final RankContent rankContent;

    ContainerCollapse(DotAttachment dotAttachment, GraphContainer graphContainer) {
        this.dotAttachment = dotAttachment;
        this.graphContainer = graphContainer;
        this.rankContent = this.dotRank();
    }

    RankContent getRankContent() {
        return this.rankContent;
    }

    private RankContent dotRank() {
        DotDigraph digraph;
        SubRankInfo subRankInfo = null;
        if (!this.dotAttachment.haveClusters() && !this.dotAttachment.haveSubgraphs() && this.graphContainer == this.dotAttachment.getGraphviz()) {
            digraph = this.dotAttachment.getDotDigraph();
        } else {
            digraph = new DotDigraph(this.graphContainer.directNodes().size() + this.graphContainer.clusters().size() + this.graphContainer.subgraphs().size());
            subRankInfo = this.collapseSet(digraph);
        }
        new Acyclic(digraph);
        GraphAttrs graphAttrs = this.dotAttachment.getDrawGraph().getGraphviz().graphAttrs();
        FeasibleTree feasibleTree = new FeasibleTree(digraph);
        SubgraphMerge subgraphMerge = subRankInfo != null ? subRankInfo.subgraphMerge : null;
        NetworkSimplex networkSimplex = new NetworkSimplex(feasibleTree, graphAttrs.getNslimit1(), graphAttrs.getRankSep(), nodes -> this.borderNodeHandle((DNode[])nodes, subgraphMerge));
        return this.restoreRankContent(networkSimplex.getRankContent(), subRankInfo);
    }

    private void borderNodeHandle(DNode[] nodes, SubgraphMerge subgraphMerge) {
        if (subgraphMerge == null || subgraphMerge.isEmpty() || !subgraphMerge.haveBorderNode()) {
            return;
        }
        Integer sourceIdx = null;
        Integer minIdx = null;
        Integer maxIdx = null;
        Integer sinkIdx = null;
        block6: for (int i = 0; i < nodes.length; ++i) {
            SubgraphMerge.MergeNode mergeNode;
            DNode n = nodes[i];
            if (n.isVirtual() || (mergeNode = subgraphMerge.getMergeNode(n)) == null || mergeNode.getNode() != n || !mergeNode.isBorder()) continue;
            switch (mergeNode.getRank()) {
                case SOURCE: {
                    sourceIdx = i;
                    continue block6;
                }
                case MIN: {
                    minIdx = i;
                    continue block6;
                }
                case MAX: {
                    maxIdx = i;
                    continue block6;
                }
                case SINK: {
                    sinkIdx = i;
                    continue block6;
                }
            }
        }
        this.moveRank(nodes, sourceIdx, minIdx, maxIdx, sinkIdx);
    }

    private void moveRank(DNode[] nodes, Integer sourceIdx, Integer minIdx, Integer maxIdx, Integer sinkIdx) {
        int maxRank;
        int minRank;
        if (sourceIdx != null) {
            minRank = nodes[0].getRank();
            this.insert(nodes, sourceIdx, 0);
            DNode minNormalNode = this.findRankNormalNode(nodes, nodes[0], 0, minRank, 1);
            if (minNormalNode != null) {
                --minRank;
            }
            nodes[0].setRank(minRank);
        } else if (minIdx != null) {
            minRank = nodes[0].getRank();
            this.insert(nodes, minIdx, 0);
            nodes[0].setRank(minRank);
        }
        if (sinkIdx != null) {
            maxRank = nodes[nodes.length - 1].getRank();
            this.insert(nodes, sinkIdx, nodes.length - 1);
            DNode maxNormalNode = this.findRankNormalNode(nodes, nodes[nodes.length - 1], nodes.length - 1, maxRank, -1);
            if (maxNormalNode != null) {
                ++maxRank;
            }
            nodes[nodes.length - 1].setRank(maxRank);
        } else if (maxIdx != null) {
            maxRank = nodes[nodes.length - 1].getRank();
            this.insert(nodes, maxIdx, nodes.length - 1);
            nodes[nodes.length - 1].setRank(maxRank);
        }
    }

    private DNode findRankNormalNode(DNode[] nodes, DNode skipNode, int startIdx, int rank, int delta) {
        for (int i = startIdx; i < nodes.length && i >= 0; i += delta) {
            if (nodes[i] == skipNode) continue;
            if (nodes[i].getRank() != rank) break;
            if (nodes[i].isVirtual()) continue;
            return nodes[i];
        }
        return null;
    }

    private void insert(DNode[] nodes, int sourceIdx, int targetIdx) {
        if (sourceIdx == targetIdx) {
            return;
        }
        DNode t = nodes[sourceIdx];
        if (Math.abs(targetIdx - sourceIdx) == 1) {
            nodes[sourceIdx] = nodes[targetIdx];
            nodes[targetIdx] = t;
            return;
        }
        if (sourceIdx > targetIdx) {
            System.arraycopy(nodes, targetIdx, nodes, targetIdx + 1, sourceIdx - targetIdx);
            nodes[targetIdx] = t;
        } else {
            System.arraycopy(nodes, sourceIdx + 1, nodes, sourceIdx, targetIdx - sourceIdx);
            nodes[targetIdx] = t;
        }
    }

    private SubRankInfo collapseSet(DotDigraph digraph) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>(0);
        SubgraphMerge subgraphMerge = SubgraphMerge.newSubgraphMerge(this.graphContainer, this.dotAttachment, c -> clusters.addAll(c.clusters()));
        return new SubRankInfo(clusters, subgraphMerge, this.rankContentHandle(digraph, clusters, subgraphMerge));
    }

    private RankContent restoreRankContent(RankContent rankContent, SubRankInfo subRankInfo) {
        if (subRankInfo == null) {
            return rankContent;
        }
        List clusters = subRankInfo.clusters != null ? subRankInfo.clusters : Collections.emptyList();
        for (Cluster cluster : clusters) {
            RankTemp rankTemp = (RankTemp)subRankInfo.clusterMerge.get(cluster);
            if (rankTemp == null) continue;
            int r = rankTemp.mergeNode.getRank() - rankTemp.minRank;
            HashSet<DNode> nodes = null;
            for (DNode dNode : this.dotAttachment.nodes(cluster)) {
                GraphContainer c = this.findCurrentContainerDirectContain(dNode);
                if (c != cluster || dNode == rankTemp.mergeNode || nodes != null && nodes.contains(dNode)) continue;
                dNode.setRank(dNode.getRank() + r);
                if (nodes == null) {
                    nodes = new HashSet<DNode>(cluster.nodeNum());
                }
                nodes.add(dNode);
            }
        }
        for (DNode node : subRankInfo.subgraphMerge.nodes()) {
            SubgraphMerge.MergeNode mergeNode = subRankInfo.subgraphMerge.getMergeNode(node);
            if (mergeNode == null) continue;
            node.setRank(mergeNode.getNode().getRank());
        }
        return rankContent;
    }

    private Map<GraphContainer, RankTemp> rankContentHandle(DotDigraph digraph, List<Cluster> clusters, SubgraphMerge subgraphMerge) {
        HashMap<Cluster, RankTemp> clusterMerge = null;
        for (Cluster cluster : clusters) {
            if (cluster.isEmpty()) continue;
            if (clusterMerge == null) {
                clusterMerge = new HashMap<Cluster, RankTemp>(this.graphContainer.clusters().size());
            }
            ContainerCollapse collapse = new ContainerCollapse(this.dotAttachment, cluster);
            RankContent rc = collapse.getRankContent();
            clusterMerge.put(cluster, this.findMinRank(rc));
        }
        this.addAuxDigraphNode(digraph, subgraphMerge, clusterMerge);
        this.addAuxDigraphLine(digraph, subgraphMerge, clusterMerge);
        return clusterMerge;
    }

    private void addAuxDigraphNode(DotDigraph digraph, SubgraphMerge subgraphMerge, Map<GraphContainer, RankTemp> clusterMerge) {
        for (DNode dNode : this.dotAttachment.nodes(this.graphContainer)) {
            SubgraphMerge.MergeNode mergeNode;
            DNode clusterMergeNode;
            GraphContainer c = this.findCurrentContainerDirectContain(dNode);
            if (c == null) continue;
            RankTemp rankTemp = clusterMerge != null ? clusterMerge.get(c) : null;
            DNode dNode2 = clusterMergeNode = rankTemp != null ? rankTemp.mergeNode : null;
            if (clusterMergeNode != null) {
                digraph.add(clusterMergeNode);
                continue;
            }
            if (dNode.getContainer() != this.graphContainer || (mergeNode = subgraphMerge.getMergeNode(dNode)) != null && mergeNode.getNode() != dNode) continue;
            digraph.add(dNode);
        }
    }

    private void addAuxDigraphLine(DotDigraph digraph, SubgraphMerge subgraphMerge, Map<GraphContainer, RankTemp> clusterMerge) {
        DrawGraph drawGraph = this.dotAttachment.getDrawGraph();
        for (Line line : this.dotAttachment.lines(this.graphContainer)) {
            DNode tm;
            SubgraphMerge.MergeNode toSubMergeNode;
            DNode to;
            DNode from = this.dotAttachment.get(line.tail());
            if (this.needIgnore(from, to = this.dotAttachment.get(line.head()))) continue;
            LineAttrs lineAttrs = drawGraph.lineAttrs(line);
            double weight = lineAttrs.getWeight() != null ? lineAttrs.getWeight() : 1.0;
            int minlen = lineAttrs.getMinlen() != null ? lineAttrs.getMinlen() : 1;
            SubgraphMerge.MergeNode fromSubMergeNode = subgraphMerge.getMergeNode(from);
            if (this.needReverse(fromSubMergeNode, toSubMergeNode = subgraphMerge.getMergeNode(to))) {
                Object tmp = from;
                from = to;
                to = tmp;
                tmp = fromSubMergeNode;
                fromSubMergeNode = toSubMergeNode;
                toSubMergeNode = (SubgraphMerge.MergeNode)tmp;
            }
            from = fromSubMergeNode != null ? fromSubMergeNode.getNode() : from;
            DNode dNode = to = toSubMergeNode != null ? toSubMergeNode.getNode() : to;
            if (clusterMerge == null) {
                digraph.addEdge(new DLine(from, to, null, null, weight, minlen));
                continue;
            }
            RankTemp fromRankTemp = clusterMerge.get(this.findCurrentContainerDirectContain(from));
            RankTemp toRankTemp = clusterMerge.get(this.findCurrentContainerDirectContain(to));
            DNode fm = fromRankTemp != null ? fromRankTemp.mergeNode : null;
            DNode dNode2 = tm = toRankTemp != null ? toRankTemp.mergeNode : null;
            if (this.isDirect(fm, tm)) {
                digraph.addEdge(new DLine(from, to, null, null, weight, minlen));
                continue;
            }
            this.addAuxClusterLine(digraph, from, to, fm, tm, weight, minlen);
        }
    }

    private void addAuxClusterLine(DotDigraph digraph, DNode from, DNode to, DNode fm, DNode tm, double weight, int minlen) {
        int r;
        DNode aux = new DNode(null, 0.0, 0.0, 0.0);
        if (tm == null) {
            digraph.addEdge(new DLine(aux, fm, null, null, weight * 10.0, 0));
            digraph.addEdge(new DLine(aux, to, null, null, weight, minlen + from.getRank() - fm.getRank()));
            return;
        }
        if (this.inDiffChildCluster(fm, tm)) {
            r = minlen + (from.getRank() - fm.getRank()) - (to.getRank() - tm.getRank());
        } else {
            r = minlen - (to.getRank() - tm.getRank());
            fm = from;
        }
        if (r > 0) {
            digraph.addEdge(new DLine(aux, fm, null, null, weight * 10.0, 0));
            digraph.addEdge(new DLine(aux, tm, null, null, weight, r));
        } else {
            digraph.addEdge(new DLine(aux, fm, null, null, weight * 10.0, -r));
            digraph.addEdge(new DLine(aux, tm, null, null, weight, 0));
        }
    }

    private boolean needReverse(SubgraphMerge.MergeNode fromMergeNode, SubgraphMerge.MergeNode toMergeNode) {
        return fromMergeNode != null && fromMergeNode.shouldNoOutDegree() || toMergeNode != null && toMergeNode.shouldNoInDegree();
    }

    private RankTemp findMinRank(RankContent rankContent) {
        RankContent.RankNode rankNode = rankContent.get(rankContent.minRank);
        while (rankNode != null) {
            for (DNode dNode : rankNode) {
                if (dNode.isVirtual()) continue;
                return new RankTemp(dNode, rankNode.rankIndex());
            }
            rankNode = rankNode.next;
        }
        throw new IllegalArgumentException("RankContent can not find right min rank node");
    }

    private GraphContainer findCurrentContainerDirectContain(DNode node) {
        Graphviz graphviz = this.dotAttachment.getDrawGraph().getGraphviz();
        GraphContainer c = node.getContainer();
        if (c == this.graphContainer) {
            return c;
        }
        GraphContainer father = graphviz.effectiveFather(c);
        while (father != null && father != this.graphContainer) {
            c = father;
            father = graphviz.effectiveFather(c);
        }
        return c;
    }

    private boolean isDirect(DNode fm, DNode tm) {
        return fm == null && tm == null;
    }

    private boolean needIgnore(DNode fm, DNode tm) {
        if (fm == null || tm == null || fm.getContainer() == this.graphContainer || tm.getContainer() == this.graphContainer) {
            return false;
        }
        GraphContainer cp = DotAttachment.commonParent(this.dotAttachment.getGraphviz(), fm, tm);
        return cp != this.graphContainer;
    }

    private boolean inDiffChildCluster(DNode fm, DNode tm) {
        return fm != null && tm != null && fm != tm;
    }

    private static class RankTemp {
        private final DNode mergeNode;
        private final int minRank;

        RankTemp(DNode mergeNode, int minRank) {
            this.mergeNode = mergeNode;
            this.minRank = minRank;
        }
    }

    private static class SubRankInfo {
        private final List<Cluster> clusters;
        private final SubgraphMerge subgraphMerge;
        private final Map<GraphContainer, RankTemp> clusterMerge;

        public SubRankInfo(List<Cluster> clusters, SubgraphMerge subgraphMerge, Map<GraphContainer, RankTemp> clusterMerge) {
            this.clusters = clusters;
            this.subgraphMerge = subgraphMerge;
            this.clusterMerge = clusterMerge;
        }
    }
}

