/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.HashMap;
import java.util.Map;
import org.graphper.api.Cluster;
import org.graphper.api.GraphContainer;
import org.graphper.api.Graphviz;
import org.graphper.def.EdgeDedigraph;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.DrawGraph;
import org.graphper.layout.dot.AbstractCoordinate;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotAttachment;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.RankContent;
import org.graphper.util.Asserts;

class Coordinate
extends AbstractCoordinate {
    private ClusterNode clusterNode;
    private DotDigraph auxDotDigraph;

    public Coordinate(int nslimit, RankContent rankContent, DotAttachment dotAttachment, EdgeDedigraph<DNode, DLine> proxyDigraph) {
        super(nslimit, rankContent, dotAttachment, proxyDigraph);
        this.auxGraphNetworkSimplex();
        this.positive();
        this.clear();
    }

    @Override
    protected double containerLeftBorder(GraphContainer container) {
        DNode node = this.clusterNode.getNode(container);
        return (double)node.getAuxRank() - node.leftWidth();
    }

    @Override
    protected double containerRightBorder(GraphContainer container) {
        DNode node = this.clusterNode.getNode(container);
        return (double)node.getAuxRank() + node.rightWidth();
    }

    @Override
    protected void nodeConsumer(DNode node) {
        node.switchAuxModel();
        this.crossRankAuxEdge(this.auxDotDigraph, node);
        this.sameRankAuxEdge(this.auxDotDigraph, node);
        this.auxDotDigraph.add(node);
    }

    private DotDigraph createAuxGraph() {
        if (this.dotAttachment.haveClusters()) {
            Graphviz graphviz = this.dotAttachment.getGraphviz();
            this.auxDotDigraph = new ClusterDotDigraph(graphviz.directNodes().size());
        } else {
            this.auxDotDigraph = new DotDigraph(this.proxyDigraph.vertexNum());
        }
        return this.auxDotDigraph;
    }

    private void crossRankAuxEdge(DotDigraph auxDotDigraph, DNode node) {
        DNode[] nodes = new DNode[]{null, null};
        for (DLine dLine : this.proxyDigraph.outAdjacent(node)) {
            DLine e2;
            DLine e1;
            ((DNode)dLine.from()).switchNormalModel();
            ((DNode)dLine.to()).switchNormalModel();
            if (((DNode)dLine.from()).getRank() == ((DNode)dLine.to()).getRank()) {
                DNode from = ((DNode)dLine.from()).getRankIndex() < ((DNode)dLine.to()).getRankIndex() ? (DNode)dLine.from() : (DNode)dLine.to();
                DNode to = dLine.other(from);
                if (from.getContainer() == to.getContainer()) {
                    this.sameRankLine(auxDotDigraph, (int)(from.getNodeSep() * (double)dLine.limit()), false, from, to, 1.0);
                    continue;
                }
                this.clusterSameRank(auxDotDigraph, from, to, 1.0);
                continue;
            }
            double weight = dLine.weight();
            DNode other = dLine.other(node);
            this.clusterNodeReplace(node, other, nodes);
            nodes[0].switchAuxModel();
            nodes[1].switchAuxModel();
            if (nodes[0] == node && nodes[1] != other) {
                weight = -1.0;
            }
            DNode auxNode = new DNode(null, 1.0, 1.0, ((DNode)dLine.from()).getNodeSep());
            auxNode.setContainer(nodes[0].getContainer());
            auxNode.switchAuxModel();
            if (nodes[0].isVirtual() && nodes[1].isVirtual()) {
                weight *= 4.0;
            }
            if (!dLine.isVirtual()) {
                int limit = this.crossLineLimit(dLine);
                if (limit < 0) {
                    e1 = new DLine(auxNode, node, null, null, weight, -limit);
                    e2 = new DLine(auxNode, other, null, null, weight, 0);
                } else {
                    e1 = new DLine(auxNode, node, null, null, weight, 0);
                    e2 = new DLine(auxNode, other, null, null, weight, limit);
                }
                if (limit != 0) {
                    node.markNotAdjustMid();
                    other.markNotAdjustMid();
                }
            } else {
                e1 = new DLine(auxNode, node, null, null, weight, 0);
                e2 = new DLine(auxNode, other, null, null, weight, 0);
            }
            auxDotDigraph.addEdge(e1);
            auxDotDigraph.addEdge(e2);
        }
    }

    private void sameRankAuxEdge(DotDigraph auxDotDigraph, DNode node) {
        node.switchNormalModel();
        DNode other = this.rankContent.rankNextNode(node);
        node.switchAuxModel();
        if (other == null) {
            return;
        }
        node.switchNormalModel();
        other.switchNormalModel();
        if (other.getRank() != node.getRank()) {
            return;
        }
        if (node.getContainer() == other.getContainer()) {
            this.sameRankLine(auxDotDigraph, (int)node.getNodeSep(), false, node, other, 0.0);
            return;
        }
        this.clusterSameRank(auxDotDigraph, node, other, 0.0);
    }

    private void clusterSameRank(DotDigraph auxDotDigraph, DNode node, DNode other, double weight) {
        node.switchAuxModel();
        other.switchAuxModel();
        GraphContainer commonParent = this.dotAttachment.commonParent(node, other);
        int limit = (int)node.getNodeSep();
        if (other.isVirtual() && node.getContainer() != other.getContainer()) {
            limit = 0;
        }
        if (commonParent == node.getContainer()) {
            GraphContainer container = this.dotAttachment.clusterDirectContainer(commonParent, other);
            DNode n = this.clusterNode().getNodeOrCreate(node, commonParent, container);
            this.sameRankLine(auxDotDigraph, limit, true, node, n, weight);
        } else if (commonParent == other.getContainer()) {
            GraphContainer container = this.dotAttachment.clusterDirectContainer(commonParent, node);
            DNode n = this.clusterNode().getNodeOrCreate(other, commonParent, container);
            this.sameRankLine(auxDotDigraph, limit, true, n, other, weight);
        } else {
            GraphContainer c1 = this.dotAttachment.clusterDirectContainer(commonParent, node);
            GraphContainer c2 = this.dotAttachment.clusterDirectContainer(commonParent, other);
            this.sameRankLine(auxDotDigraph, limit, true, this.clusterNode().getNodeOrCreate(node, commonParent, c1), this.clusterNode().getNodeOrCreate(other, commonParent, c2), weight);
        }
    }

    private void clusterNodeReplace(DNode node, DNode other, DNode[] nodes) {
        node.switchAuxModel();
        other.switchAuxModel();
        nodes[0] = node;
        nodes[1] = other;
        if (node.getContainer() == other.getContainer()) {
            return;
        }
        GraphContainer commonParent = this.dotAttachment.commonParent(node, other);
        if (commonParent == node.getContainer()) {
            GraphContainer container = this.dotAttachment.clusterDirectContainer(commonParent, other);
            nodes[1] = this.clusterNode().getNodeOrCreate(node, commonParent, container);
        } else if (commonParent == other.getContainer()) {
            GraphContainer container = this.dotAttachment.clusterDirectContainer(commonParent, node);
            nodes[0] = this.clusterNode().getNodeOrCreate(other, commonParent, container);
        } else {
            GraphContainer c1 = this.dotAttachment.clusterDirectContainer(commonParent, node);
            GraphContainer c2 = this.dotAttachment.clusterDirectContainer(commonParent, other);
            nodes[0] = this.clusterNode().getNodeOrCreate(node, commonParent, c1);
            nodes[1] = this.clusterNode().getNodeOrCreate(other, commonParent, c2);
        }
        nodes[0].switchAuxModel();
        nodes[1].switchAuxModel();
    }

    private void sameRankLine(DotDigraph auxDotDigraph, int minLen, boolean realTimeLimit, DNode node, DNode other, double weight) {
        node.switchAuxModel();
        other.switchAuxModel();
        int limit = minLen;
        if (!realTimeLimit) {
            limit = (int)(node.rightWidth() + 1.0) + minLen + (int)(other.leftWidth() + 1.0);
        }
        DLine line = new DLine(node, other, weight, limit, realTimeLimit);
        auxDotDigraph.addEdge(line);
    }

    private void auxGraphNetworkSimplex() {
        this.createAuxGraph();
        this.accessNodes();
        if (this.auxDotDigraph instanceof ClusterDotDigraph) {
            ClusterDotDigraph clusterDotDigraph = (ClusterDotDigraph)this.auxDotDigraph;
            HashMap<GraphContainer, AbstractCoordinate.ContainerBorder> clusterBorderMap = new HashMap<GraphContainer, AbstractCoordinate.ContainerBorder>();
            this.clusterNetworkSimplex(this.dotAttachment.getGraphviz(), clusterDotDigraph, clusterBorderMap);
            this.calcClusterOffset(0, this.dotAttachment.getGraphviz(), clusterBorderMap);
            this.mergeCluster(clusterBorderMap);
        } else {
            this.networkSimplex(this.auxDotDigraph, false);
        }
    }

    private AbstractCoordinate.ContainerBorder clusterNetworkSimplex(GraphContainer container, ClusterDotDigraph clusterDotDigraph, Map<GraphContainer, AbstractCoordinate.ContainerBorder> clusterBorderMap) {
        DotDigraph dotDigraph = clusterDotDigraph.getDotDigraph(container);
        for (Cluster cluster : DotAttachment.clusters(container)) {
            AbstractCoordinate.ContainerBorder clusterHorRange = this.clusterNetworkSimplex(cluster, clusterDotDigraph, clusterBorderMap);
            DNode cn = this.clusterNode.getNode(cluster);
            cn.setWidth(clusterHorRange.width());
        }
        RankContent rc = this.networkSimplex(dotDigraph, true);
        AbstractCoordinate.ContainerBorder clusterBorder = new AbstractCoordinate.ContainerBorder();
        clusterBorderMap.put(container, clusterBorder);
        DNode min = this.findMaxWidthNode(rc.get(rc.minRank()));
        DNode max = this.findMaxWidthNode(rc.get(rc.maxRank()));
        clusterBorder.min = min.getAuxRank() - (int)min.leftWidth();
        clusterBorder.max = max.getAuxRank() + (int)max.rightWidth();
        if (container.isCluster()) {
            if (this.needFlip) {
                clusterBorder.min -= this.flipGetMargin(container, true, true);
                clusterBorder.max += this.flipGetMargin(container, false, true);
            } else {
                double horMargin = this.getHorMargin((Cluster)container, clusterBorder);
                clusterBorder.min = (int)((double)clusterBorder.min - horMargin);
                clusterBorder.max = (int)((double)clusterBorder.max + horMargin);
            }
        }
        return clusterBorder;
    }

    private double getHorMargin(Cluster container, AbstractCoordinate.ContainerBorder clusterBorder) {
        DrawGraph drawGraph = this.dotAttachment.getDrawGraph();
        ClusterDrawProp clusterDrawProp = drawGraph.getClusterDrawProp(container);
        FlatPoint labelSize = clusterDrawProp.getLabelSize();
        if (labelSize == null) {
            return clusterDrawProp.getHorMargin();
        }
        int width = clusterBorder.width();
        return Math.max(clusterDrawProp.getHorMargin(), (labelSize.getWidth() - (double)width) / 2.0);
    }

    private DNode findMaxWidthNode(RankContent.RankNode rankNode) {
        DNode max = rankNode.get(0);
        for (int i = 1; i < rankNode.size(); ++i) {
            DNode node = rankNode.get(i);
            if (!(node.getWidth() > max.getWidth())) continue;
            max = node;
        }
        return max;
    }

    private void calcClusterOffset(int offset, GraphContainer container, Map<GraphContainer, AbstractCoordinate.ContainerBorder> clusterBorderMap) {
        for (Cluster c : DotAttachment.clusters(container)) {
            DNode childNode = this.clusterNode.getNode(c);
            AbstractCoordinate.ContainerBorder childWidth = clusterBorderMap.get(c);
            int left = childNode.getAuxRank() - (int)childNode.leftWidth() + offset;
            int clusterOffset = childNode.getAuxRank() - (int)childNode.leftWidth() - childWidth.min;
            childWidth.newMin = left;
            childNode.setAuxRank(left + (int)childNode.leftWidth());
            this.calcClusterOffset(clusterOffset, c, clusterBorderMap);
        }
    }

    private void mergeCluster(Map<GraphContainer, AbstractCoordinate.ContainerBorder> clusterBorderMap) {
        if (this.clusterNode == null) {
            return;
        }
        for (int i = this.rankContent.minRank(); i <= this.rankContent.maxRank(); ++i) {
            RankContent.RankNode rankNode = this.rankContent.get(i);
            for (int j = 0; j < rankNode.size(); ++j) {
                DNode node = rankNode.get(j);
                if (node.getContainer().isGraphviz()) continue;
                AbstractCoordinate.ContainerBorder clusterBorder = clusterBorderMap.get(node.getContainer());
                node.setAuxRank(node.getAuxRank() + clusterBorder.newMin - clusterBorder.min);
            }
        }
    }

    private DNode getClusterNodeIfPresent(GraphContainer container, DNode node) {
        if (node == null || node.isVirtual() || this.clusterNode == null || !node.getContainer().isCluster() || node.getContainer() == container || !this.dotAttachment.notContain(node.getContainer(), container)) {
            return node;
        }
        return this.clusterNode.getNode(node.getContainer());
    }

    private ClusterNode clusterNode() {
        if (this.clusterNode == null) {
            this.clusterNode = new ClusterNode();
        }
        return this.clusterNode;
    }

    private void clear() {
        this.clusterNode = null;
        this.auxDotDigraph = null;
    }

    private static class ClusterDotDigraph
    extends DotDigraph {
        private static final long serialVersionUID = -7097358089045601860L;
        private Map<Cluster, DotDigraph> clusterGraph;

        ClusterDotDigraph(int capacity) {
            super(capacity > 0 ? capacity : 1);
        }

        @Override
        public boolean add(DNode node) {
            if (!node.getContainer().isCluster()) {
                return super.add(node);
            }
            return this.childGraph(node.getContainer()).add(node);
        }

        @Override
        public void addEdge(DLine edge) {
            DNode from = (DNode)edge.from();
            if (!from.getContainer().isCluster()) {
                super.addEdge(edge);
            } else {
                this.childGraph(from.getContainer()).addEdge(edge);
            }
        }

        DotDigraph getDotDigraph(GraphContainer container) {
            if (this.clusterGraph == null) {
                return null;
            }
            if (container.isGraphviz()) {
                return this;
            }
            return this.clusterGraph.get(container);
        }

        private DotDigraph childGraph(GraphContainer container) {
            if (this.clusterGraph == null) {
                this.clusterGraph = new HashMap<Cluster, DotDigraph>();
            }
            return this.clusterGraph.computeIfAbsent((Cluster)container, c -> new DotDigraph(container.directNodes().size()));
        }
    }

    private class ClusterNode {
        private Map<Cluster, DNode> clusterDNodeMap;

        private ClusterNode() {
        }

        DNode getNodeOrCreate(DNode n, GraphContainer father, GraphContainer container) {
            if (!container.isCluster()) {
                return n;
            }
            return this.clusterLimitMap().computeIfAbsent((Cluster)container, c -> {
                DNode node = new DNode(null, 0.0, 1.0, 0.0);
                node.setContainer(father);
                node.switchAuxModel();
                return node;
            });
        }

        DNode getNode(GraphContainer container) {
            if (this.clusterDNodeMap == null || !container.isCluster()) {
                throw new IllegalArgumentException("Can not get any cluster node");
            }
            DNode node = this.clusterDNodeMap.get(container);
            Asserts.illegalArgument(node == null, "Find null cluster node");
            return node;
        }

        private Map<Cluster, DNode> clusterLimitMap() {
            if (this.clusterDNodeMap == null) {
                this.clusterDNodeMap = new HashMap<Cluster, DNode>();
            }
            return this.clusterDNodeMap;
        }
    }
}

