/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.layout.dot;

import java.util.HashMap;
import java.util.Map;
import org.graphper.api.Cluster;
import org.graphper.api.GraphContainer;
import org.graphper.def.EdgeDedigraph;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ContainerDrawProp;
import org.graphper.layout.dot.AbstractCoordinate;
import org.graphper.layout.dot.DLine;
import org.graphper.layout.dot.DNode;
import org.graphper.layout.dot.DotAttachment;
import org.graphper.layout.dot.DotDigraph;
import org.graphper.layout.dot.RankContent;

class CoordinateV2
extends AbstractCoordinate {
    private DotDigraph auxDotDigraph;
    private Map<GraphContainer, ContainerContent> containerContentMap;

    public CoordinateV2(int nslimit, RankContent rankContent, DotAttachment dotAttachment, EdgeDedigraph<DNode, DLine> proxyDigraph) {
        super(nslimit, rankContent, dotAttachment, proxyDigraph);
        this.networkSimplex(this.createAuxGraph(), false);
        this.positive();
        this.clear();
    }

    @Override
    protected double containerLeftBorder(GraphContainer container) {
        return this.getContainerContent(container).leftNode.getAuxRank();
    }

    @Override
    protected double containerRightBorder(GraphContainer container) {
        return this.getContainerContent(container).rightNode.getAuxRank();
    }

    @Override
    protected void nodeConsumer(DNode node) {
        node.switchAuxModel();
        this.crossRankAuxEdge(node);
        this.sameRankAuxEdge(node);
        this.containerBorderEdge(node);
        this.auxDotDigraph.add(node);
    }

    private DotDigraph createAuxGraph() {
        this.auxDotDigraph = new DotDigraph(this.proxyDigraph.vertexNum());
        this.addClusterBorderEdge(this.auxDotDigraph, this.dotAttachment.getGraphviz());
        this.accessNodes();
        return this.auxDotDigraph;
    }

    private ContainerContent addClusterBorderEdge(DotDigraph auxDotDigraph, GraphContainer container) {
        if (!this.dotAttachment.haveClusters()) {
            return null;
        }
        if (this.containerContentMap == null) {
            this.containerContentMap = new HashMap<GraphContainer, ContainerContent>();
        }
        ContainerContent containerContent = this.containerContentMap.computeIfAbsent(container, x$0 -> new ContainerContent((GraphContainer)x$0));
        auxDotDigraph.addEdge(new DLine(containerContent.leftNode, containerContent.rightNode, null, null, 128.0, containerContent.minlen()));
        for (Cluster cluster : DotAttachment.clusters(container)) {
            ContainerContent childCC = this.addClusterBorderEdge(auxDotDigraph, cluster);
            if (childCC == null) continue;
            auxDotDigraph.addEdge(new DLine(containerContent.leftNode, childCC.leftNode, null, null, 0.0, containerContent.leftMargin));
            auxDotDigraph.addEdge(new DLine(childCC.rightNode, containerContent.rightNode, null, null, 0.0, containerContent.rightMargin));
        }
        return containerContent;
    }

    private void crossRankAuxEdge(DNode node) {
        for (DLine dLine : this.proxyDigraph.outAdjacent(node)) {
            DLine e2;
            DLine e1;
            for (int i = 0; i < dLine.getParallelNums(); ++i) {
                DLine l = dLine.parallelLine(i);
                this.dotAttachment.addGeneratePort(l);
            }
            DNode other = dLine.other(node);
            node.switchNormalModel();
            other.switchNormalModel();
            if (((DNode)dLine.from()).getRank() == ((DNode)dLine.to()).getRank()) {
                DNode from = ((DNode)dLine.from()).getRankIndex() < ((DNode)dLine.to()).getRankIndex() ? (DNode)dLine.from() : (DNode)dLine.to();
                DNode to = dLine.other(from);
                this.sameRankLine((int)(from.getNodeSep() * (double)dLine.limit()), from, to, 1.0);
                continue;
            }
            double weight = dLine.weight();
            node.switchAuxModel();
            other.switchAuxModel();
            DNode auxNode = new DNode(null, 1.0, 1.0, ((DNode)dLine.from()).getNodeSep());
            auxNode.setContainer(node.getContainer());
            auxNode.switchAuxModel();
            if (node.isLabelNode() || other.isLabelNode()) {
                weight *= 4.0;
            } else if (node.isVirtual()) {
                weight = other.isVirtual() ? (weight *= 4.0) : (weight *= 2.0);
            }
            if (!dLine.isVirtual()) {
                int limit = this.crossLineLimit(dLine);
                if (limit < 0) {
                    e1 = new DLine(auxNode, node, null, null, weight, -limit);
                    e2 = new DLine(auxNode, other, null, null, weight, 0);
                } else {
                    e1 = new DLine(auxNode, node, null, null, weight, 0);
                    e2 = new DLine(auxNode, other, null, null, weight, limit);
                }
                if (limit != 0) {
                    node.markNotAdjustMid();
                    other.markNotAdjustMid();
                }
            } else {
                e1 = new DLine(auxNode, node, null, null, weight, 0);
                e2 = new DLine(auxNode, other, null, null, weight, 0);
            }
            this.auxDotDigraph.addEdge(e1);
            this.auxDotDigraph.addEdge(e2);
        }
    }

    private void sameRankAuxEdge(DNode node) {
        node.switchNormalModel();
        DNode other = this.rankContent.rankNextNode(node);
        node.switchAuxModel();
        if (other == null) {
            return;
        }
        node.switchNormalModel();
        other.switchNormalModel();
        if (other.getRank() != node.getRank()) {
            return;
        }
        this.sameRankLine((int)node.getNodeSep(), node, other, 0.0);
        this.adjClusterEdge(node, other);
    }

    private void sameRankLine(int minLen, DNode node, DNode other, double weight) {
        node.switchAuxModel();
        other.switchAuxModel();
        int limit = (int)(node.rightWidth() + 1.0) + minLen + (int)(other.leftWidth() + 1.0);
        DLine line = new DLine(node, other, weight, limit, false);
        this.auxDotDigraph.addEdge(line);
    }

    private boolean notNeedOccupySpaceForCluster(DNode node) {
        return node.isVirtual() && !node.isLabelNode() && !node.isFlatLabelNode();
    }

    private void adjClusterEdge(DNode node, DNode other) {
        ContainerContent containerContent;
        if (this.notNeedOccupySpaceForCluster(node) || !this.dotAttachment.haveClusters()) {
            return;
        }
        GraphContainer commonParent = this.dotAttachment.commonParent(node, other);
        if (commonParent == node.getContainer() && commonParent == other.getContainer()) {
            return;
        }
        if (commonParent == node.getContainer()) {
            containerContent = this.getContainerContent(this.dotAttachment.clusterDirectContainer(commonParent, other));
            this.auxDotDigraph.addEdge(new DLine(node, containerContent.leftNode, 0.0, (int)(20.0 + node.rightWidth()), false));
        }
        if (commonParent == other.getContainer()) {
            containerContent = this.getContainerContent(this.dotAttachment.clusterDirectContainer(commonParent, node));
            this.auxDotDigraph.addEdge(new DLine(containerContent.rightNode, other, 0.0, (int)(20.0 + other.leftWidth()), false));
        } else {
            ContainerContent left = this.getContainerContent(this.dotAttachment.clusterDirectContainer(commonParent, node));
            ContainerContent right = this.getContainerContent(this.dotAttachment.clusterDirectContainer(commonParent, other));
            if (left != null && right != null) {
                this.auxDotDigraph.addEdge(new DLine(left.rightNode, right.leftNode, 0.0, 16, false));
            }
        }
    }

    private void containerBorderEdge(DNode node) {
        if (!this.dotAttachment.haveClusters()) {
            return;
        }
        ContainerContent containerContent = this.getContainerContent(node.getContainer());
        if (containerContent.container.isGraphviz()) {
            return;
        }
        this.auxDotDigraph.addEdge(new DLine(containerContent.leftNode, node, 0.0, (int)((double)containerContent.leftMargin + node.leftWidth()), false));
        this.auxDotDigraph.addEdge(new DLine(node, containerContent.rightNode, 0.0, (int)((double)containerContent.rightMargin + node.rightWidth()), false));
    }

    private ContainerContent getContainerContent(GraphContainer container) {
        return this.containerContentMap.get(container);
    }

    private void clear() {
        this.auxDotDigraph = null;
        this.containerContentMap = null;
    }

    private class ContainerContent {
        private final int leftMargin;
        private final int rightMargin;
        private final DNode leftNode;
        private final DNode rightNode;
        private final GraphContainer container;

        private ContainerContent(GraphContainer container) {
            this.container = container;
            this.leftNode = this.newClusterNode();
            this.rightNode = this.newClusterNode();
            this.leftMargin = this.margin(true);
            this.rightMargin = this.margin(false);
        }

        private int minlen() {
            ContainerDrawProp containerDrawProp = CoordinateV2.this.getContainerDrawProp(this.container);
            FlatPoint labelSize = containerDrawProp.getLabelSize();
            if (labelSize == null) {
                return 0;
            }
            return CoordinateV2.this.needFlip ? (int)labelSize.getHeight() : (int)labelSize.getWidth();
        }

        private int margin(boolean left) {
            ContainerDrawProp containerDrawProp = CoordinateV2.this.getContainerDrawProp(this.container);
            if (!CoordinateV2.this.needFlip) {
                return (int)containerDrawProp.getHorMargin();
            }
            return CoordinateV2.this.flipGetMargin(this.container, left, false);
        }

        private DNode newClusterNode() {
            DNode node = new DNode(null, 0.0, 1.0, 0.0);
            node.setContainer(this.container);
            node.switchAuxModel();
            return node;
        }
    }
}

